/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.rules.DependsOn;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.memory.GarbageCollectionInfoRule;
import org.openjdk.jmc.flightrecorder.rules.jdk.memory.GarbageCollectionsInfo;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

@DependsOn(value=GarbageCollectionInfoRule.class)
public class SystemGcRule
implements IRule {
    private static final String SYSTEM_GC_RESULT_ID = "SystemGc";
    public static final TypedPreference<IQuantity> SYSTEM_GC_RATIO_LIMIT = new TypedPreference("systemgc.ratio.limit", Messages.getString("SystemGcRule_CONFIG_WARNING_LIMIT"), Messages.getString("SystemGcRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(0.5));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(SYSTEM_GC_RATIO_LIMIT);
    public static final TypedResult<IQuantity> SYSTEM_GC_RATIO = new TypedResult("systemGcRatio", "System GC Ratio", "The ratio of all GCs caused by System.gc() calls to all GCs.", (ContentType)UnitLookup.PERCENTAGE, IQuantity.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, SYSTEM_GC_RATIO);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.GarbageCollection", RulesToolkit.EventAvailability.ENABLED).build();

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return SystemGcRule.this.getSystemGcResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    private IResult getSystemGcResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        GarbageCollectionsInfo aggregate = (GarbageCollectionsInfo)resultProvider.getResultValue(GarbageCollectionInfoRule.GC_INFO);
        IQuantity limit = (IQuantity)valueProvider.getPreferenceValue(SYSTEM_GC_RATIO_LIMIT);
        if (aggregate.getSystemGcCount() > 0) {
            double systemGcRatio = aggregate.getSystemGcCount() / aggregate.getGcCount();
            double score = RulesToolkit.mapExp100((double)systemGcRatio, (double)limit.doubleValue());
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.get((double)score)).setSummary(Messages.getString("SystemGcRuleFactory_TEXT_INFO")).setExplanation(Messages.getString("SystemGcRuleFactory_TEXT_INFO_LONG")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(SYSTEM_GC_RATIO, (Object)UnitLookup.PERCENT_UNITY.quantity(systemGcRatio)).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("SystemGcRuleFactory_TEXT_OK")).build();
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return SYSTEM_GC_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("SystemGcRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "garbage_collection";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

