/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.browser.remoteagent;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.openjdk.jmc.browser.attach.Messages;
import org.openjdk.jmc.ui.misc.ControlDecorationToolkit;

public class RemoteJMXAgentWizardPage
extends WizardPage {
    private static final String WORD_CHAR_REGEXP = "\\w";
    private static final String NON_WORD_CHAR_REGEXP = "\\W";
    private static final String MANAGEMENT_AGENT_START = "ManagementAgent.start";
    private static final String MANAGEMENT_AGENT_STOP = "ManagementAgent.stop";
    private static final String JDP_PAUSE = "jdp.pause";
    private static final String JDP_TTL = "jdp.ttl";
    private static final String JDP_PORT = "jdp.port";
    private static final String JDP_ADDRESS = "jdp.address";
    private static final String JDP_SOURCE_ADDRESS = "jdp.source_addr";
    private static final String JDP_NAME = "jdp.name";
    private static final String JMXREMOTE_AUTODISCOVERY = "jmxremote.autodiscovery";
    private static final String JMXREMOTE_REGISTRY_SSL = "jmxremote.registry.ssl";
    private static final String JMXREMOTE_RMI_PORT = "jmxremote.rmi.port";
    private static final String JMXREMOTE_AUTHENTICATE = "jmxremote.authenticate";
    private static final String JMXREMOTE_SSL = "jmxremote.ssl";
    private static final String JMXREMOTE_PORT = "jmxremote.port";
    static final String PAGE_NAME = "browser.attach.management.agent.settings.wizard.page";
    private static final int MIN_PORT = 0;
    private static final int MAX_PORT = 65535;
    private static final int MIN_TTL = 0;
    private static final int MAX_TTL = 255;
    private static final String DEFAULT_PORT = "7091";
    private static final String DEFAULT_JDP_TTL = "1";
    private static final String DEFAULT_JDP_NAME = "";
    private static final String DEFAULT_JDP_INTERVAL = "5000";
    private static final String DEFAULT_JDP_PORT = "";
    private static final String DEFAULT_JDP_ADDRESS = "";
    private static final String DEFAULT_JDP_SOURCE_ADDRESS = "";
    private static final Boolean DEFAULT_SSL = Boolean.TRUE;
    private static final Boolean DEFAULT_AUTHENTICATE = Boolean.TRUE;
    private static final Boolean DEFAULT_REGISTRY_SSL = Boolean.FALSE;
    private static final Boolean DEFAULT_AUTODISCOVERY = Boolean.FALSE;
    private static final String EMPTY = "";
    private static final String CMD_SEP = " ";
    private final Map<Control, String> errors = new HashMap<Control, String>();
    private Text commandText;
    private Button stopAgentButton;
    private Button startAgentButton;
    private Button sslButton;
    private Button authenticateButton;
    private Button registrySslButton;
    private Button autodiscoverButton;
    private Text portText;
    private Text rmiPortText;
    private Text ttlText;
    private Text intervalText;
    private Text jdpNameText;
    private String serverName;
    private Boolean agentStarted;
    private Properties initialSettings;
    private boolean enableStop;
    private boolean enableStart;
    private Boolean jdpEnabled;
    private boolean doStart;

    protected RemoteJMXAgentWizardPage(String serverName, Boolean agentStarted, Properties currentSettings) {
        super(PAGE_NAME);
        this.serverName = serverName;
        this.agentStarted = agentStarted;
        this.initialSettings = new Properties();
        this.enableStop = agentStarted == null || agentStarted != false;
        boolean bl = this.enableStart = agentStarted == null || agentStarted == false;
        if (Boolean.TRUE.equals(agentStarted)) {
            if (currentSettings != null) {
                this.initialSettings.putAll((Map<?, ?>)currentSettings);
            }
            this.initialSettings.putIfAbsent(JDP_PAUSE, "");
            this.initialSettings.putIfAbsent(JDP_TTL, "");
        }
        this.doStart = !Boolean.TRUE.equals(agentStarted);
        this.initialSettings.putIfAbsent(JMXREMOTE_REGISTRY_SSL, DEFAULT_REGISTRY_SSL);
        this.initialSettings.putIfAbsent(JMXREMOTE_SSL, DEFAULT_SSL);
        this.initialSettings.putIfAbsent(JMXREMOTE_AUTHENTICATE, DEFAULT_AUTHENTICATE);
        this.initialSettings.putIfAbsent(JMXREMOTE_AUTODISCOVERY, DEFAULT_AUTODISCOVERY);
        this.initialSettings.putIfAbsent(JMXREMOTE_PORT, DEFAULT_PORT);
        this.initialSettings.putIfAbsent(JMXREMOTE_RMI_PORT, DEFAULT_PORT);
        this.initialSettings.putIfAbsent(JDP_PAUSE, DEFAULT_JDP_INTERVAL);
        this.initialSettings.putIfAbsent(JDP_NAME, "");
        this.initialSettings.putIfAbsent(JDP_TTL, DEFAULT_JDP_TTL);
        this.initialSettings.putIfAbsent(JDP_PORT, "");
        this.initialSettings.putIfAbsent(JDP_ADDRESS, "");
        this.initialSettings.putIfAbsent(JDP_SOURCE_ADDRESS, "");
        this.jdpEnabled = (Boolean)this.getInitial(JMXREMOTE_AUTODISCOVERY);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createAgentStatus(composite);
        this.createAgentControls(composite);
        this.createSettingsPanel(composite);
        this.createCommandText(composite);
        this.setStartAgentControlsEditable(this.enableStart);
        composite.layout();
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.openjdk.jmc.browser.communication");
    }

    private void createAgentControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout(256));
        this.createStopAgentButton(composite);
        this.createStartAgentButton(composite);
        GridData gd = new GridData(1, 1, false, false);
        composite.setLayoutData((Object)gd);
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.openjdk.jmc.browser.communication");
    }

    public static String getTitle(Boolean agentStarted, String serverName) {
        String title = agentStarted == null ? Messages.RemoteJMXStarterAction_START_REMOTE_JMX_AGENT_TITLE : (agentStarted != false ? Messages.RemoteJMXStarterAction_START_REMOTE_JMX_AGENT_TITLE_STOP : Messages.RemoteJMXStarterAction_START_REMOTE_JMX_AGENT_TITLE_START);
        return NLS.bind((String)title, (Object)serverName);
    }

    public String getTitle() {
        return RemoteJMXAgentWizardPage.getTitle(this.agentStarted, this.serverName);
    }

    private void createStopAgentButton(Composite parent) {
        if (this.enableStop && this.enableStart) {
            this.stopAgentButton = new Button(parent, 16);
            this.stopAgentButton.setText(Messages.STOP_REMOTE_JMX_AGENT);
            this.stopAgentButton.setToolTipText(Messages.STOP_REMOTE_JMX_AGENT_DESCRIPTION);
            this.stopAgentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RemoteJMXAgentWizardPage.this.setStartAgentControlsEnabled(!RemoteJMXAgentWizardPage.this.stopAgentButton.getSelection());
                    RemoteJMXAgentWizardPage.this.doStart = !RemoteJMXAgentWizardPage.this.stopAgentButton.getSelection();
                    RemoteJMXAgentWizardPage.this.updatePage();
                }
            });
            this.stopAgentButton.setSelection(false);
        }
    }

    private void createStartAgentButton(Composite parent) {
        if (this.enableStart && this.enableStop) {
            this.startAgentButton = new Button(parent, 16);
            this.startAgentButton.setText(Messages.START_REMOTE_JMX_AGENT);
            this.startAgentButton.setToolTipText(Messages.START_REMOTE_JMX_AGENT_DESCRIPTION);
            this.startAgentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RemoteJMXAgentWizardPage.this.setStartAgentControlsEnabled(RemoteJMXAgentWizardPage.this.startAgentButton.getSelection());
                    RemoteJMXAgentWizardPage.this.doStart = RemoteJMXAgentWizardPage.this.startAgentButton.getSelection();
                    RemoteJMXAgentWizardPage.this.updatePage();
                }
            });
            this.startAgentButton.setSelection(true);
            this.doStart = true;
        }
    }

    private void setStartAgentControlsEditable(boolean editable) {
        this.sslButton.setEnabled(editable);
        this.authenticateButton.setEnabled(editable);
        this.registrySslButton.setEnabled(editable);
        this.autodiscoverButton.setEnabled(editable);
        this.portText.setEditable(editable);
        this.rmiPortText.setEditable(editable);
        this.ttlText.setEditable(editable);
        this.intervalText.setEditable(editable);
        this.jdpNameText.setEditable(editable);
    }

    private void setStartAgentControlsEnabled(boolean enabled) {
        this.sslButton.setEnabled(enabled);
        this.authenticateButton.setEnabled(enabled);
        this.registrySslButton.setEnabled(enabled);
        this.autodiscoverButton.setEnabled(enabled);
        this.portText.setEnabled(enabled);
        this.rmiPortText.setEnabled(enabled);
        boolean autodiscover = this.autodiscoverButton.getSelection();
        this.ttlText.setEnabled(enabled && autodiscover);
        this.intervalText.setEnabled(enabled && autodiscover);
        this.jdpNameText.setEnabled(enabled && autodiscover);
    }

    private void createAgentStatus(Composite parent) {
        Composite statusComposite = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, false);
        statusComposite.setLayoutData((Object)gd);
        GridLayout agentGrid = new GridLayout(2, false);
        agentGrid.marginWidth = 0;
        agentGrid.marginHeight = 3;
        agentGrid.verticalSpacing = 0;
        agentGrid.horizontalSpacing = 5;
        statusComposite.setLayout((Layout)agentGrid);
        Label agentStatus = new Label(statusComposite, 0);
        agentStatus.setText(Messages.RemoteJMXStarterWizardPage_AGENT_STATUS);
        Text status = new Text(statusComposite, 2048);
        status.setEnabled(this.agentStarted != null);
        status.setEditable(false);
        status.setText(this.getAgentStatus());
        GridData gdStatus = new GridData(4, 4, true, false);
        status.setLayoutData((Object)gdStatus);
    }

    private String getAgentStatus() {
        if (this.agentStarted == null) {
            return Messages.RemoteJMXStarterWizardPage_AGENT_STATUS_UNKNOWN;
        }
        if (this.agentStarted.booleanValue()) {
            return Messages.RemoteJMXStarterWizardPage_AGENT_STATUS_ENABLED;
        }
        return Messages.RemoteJMXStarterWizardPage_AGENT_STATUS_DISABLED;
    }

    private void createSettingsPanel(Composite parent) {
        Composite settingsComposite = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, false);
        gd.minimumHeight = -1;
        settingsComposite.setLayoutData((Object)gd);
        GridLayout settingsGrid = new GridLayout(1, true);
        settingsGrid.marginWidth = 0;
        settingsGrid.marginHeight = 5;
        settingsGrid.verticalSpacing = 0;
        settingsGrid.horizontalSpacing = 0;
        settingsComposite.setLayout((Layout)settingsGrid);
        Label settingsLabel = new Label(settingsComposite, 0);
        GridData gdLabel = new GridData(4, 4, true, false);
        settingsLabel.setLayoutData((Object)gdLabel);
        settingsLabel.setText(Boolean.TRUE.equals(this.agentStarted) ? Messages.RemoteJMXStarterWizardPage_CURRENT_SETTINGS : Messages.RemoteJMXStarterWizardPage_NEW_SETTINGS);
        this.createSettingsButtonPanel(settingsComposite);
        this.createSettingsTextInputPanel(settingsComposite);
    }

    private void createSettingsTextInputPanel(Composite settingsComposite) {
        Composite textPanel = new Composite(settingsComposite, 0);
        GridData gd2 = new GridData(4, 1, true, false);
        textPanel.setLayoutData((Object)gd2);
        textPanel.setLayout((Layout)new GridLayout(2, false));
        this.portText = this.createTextInput(textPanel, Messages.RemoteJMXStarterWizardPage_PORT_LABEL, Messages.RemoteJMXStarterWizardPage_PORT_DESCRIPTION, (String)this.getInitial(JMXREMOTE_PORT), this.minMaxValidator(0, 65535));
        this.rmiPortText = this.createTextInput(textPanel, Messages.RemoteJMXStarterWizardPage_RMI_PORT_LABEL, Messages.RemoteJMXStarterWizardPage_RMI_PORT_DESCRIPTION, (String)this.getInitial(JMXREMOTE_RMI_PORT), this.minMaxValidator(0, 65535));
        this.ttlText = this.createTextInput(textPanel, Messages.RemoteJMXStarterWizardPage_JDP_TTL_LABEL, Messages.RemoteJMXStarterWizardPage_JDP_TTL_DESCRIPTION, (String)this.getInitial(JDP_TTL), this.minMaxValidator(0, 255));
        this.ttlText.setEnabled(this.jdpEnabled.booleanValue());
        this.intervalText = this.createTextInput(textPanel, Messages.RemoteJMXStarterWizardPage_JDP_PAUSE_LABEL, Messages.RemoteJMXStarterWizardPage_JDP_PAUSE_DESCRIPTION, (String)this.getInitial(JDP_PAUSE), this.minMaxValidator(1, Integer.MAX_VALUE));
        this.intervalText.setEnabled(this.jdpEnabled.booleanValue());
        this.jdpNameText = this.createTextInput(textPanel, Messages.RemoteJMXStarterWizardPage_JDP_NAME_LABEL, Messages.RemoteJMXStarterWizardPage_JDP_NAME_DESCRIPTION, (String)this.getInitial(JDP_NAME), text -> Pattern.compile(NON_WORD_CHAR_REGEXP).matcher((CharSequence)text).find() ? NLS.bind((String)Messages.RemoteJMXStarterWizardPage_INVALID_JDP_NAME, (Object)text.replaceAll(WORD_CHAR_REGEXP, "")) : null);
        this.jdpNameText.setEnabled(this.jdpEnabled.booleanValue());
        if (Boolean.TRUE.equals(this.agentStarted) && this.jdpEnabled.booleanValue()) {
            this.createTextInput(textPanel, Messages.RemoteJMXStarterWizardPage_JDP_PORT_LABEL, Messages.RemoteJMXStarterWizardPage_JDP_PORT_DESCRIPTION, (String)this.getInitial(JDP_PORT), s -> null).setEditable(false);
            this.createTextInput(textPanel, Messages.RemoteJMXStarterWizardPage_JDP_ADDRESS_LABEL, Messages.RemoteJMXStarterWizardPage_JDP_ADDRESS_DESCRIPTION, (String)this.getInitial(JDP_ADDRESS), s -> null).setEditable(false);
            this.createTextInput(textPanel, Messages.RemoteJMXStarterWizardPage_JDP_SOURCE_ADDRESS_LABEL, Messages.RemoteJMXStarterWizardPage_JDP_SOURCE_ADDRESS_DESCRIPTION, (String)this.getInitial(JDP_SOURCE_ADDRESS), s -> null).setEditable(false);
        }
    }

    private void createSettingsButtonPanel(Composite settingsComposite) {
        Composite buttonPanel = new Composite(settingsComposite, 0);
        GridData gd1 = new GridData(4, 1, true, false);
        buttonPanel.setLayout((Layout)new GridLayout(4, false));
        buttonPanel.setLayoutData((Object)gd1);
        this.sslButton = RemoteJMXAgentWizardPage.createButton(buttonPanel, Messages.RemoteJMXStarterWizardPage_SSL_LABEL, Messages.RemoteJMXStarterWizardPage_SSL_DESCRIPTION, (Boolean)this.getInitial(JMXREMOTE_SSL), () -> this.updatePage());
        this.authenticateButton = RemoteJMXAgentWizardPage.createButton(buttonPanel, Messages.RemoteJMXStarterWizardPage_AUTHENTICATE_LABEL, Messages.RemoteJMXStarterWizardPage_AUTHENTICATE_DESCRIPTION, (Boolean)this.getInitial(JMXREMOTE_AUTHENTICATE), () -> this.updatePage());
        this.registrySslButton = RemoteJMXAgentWizardPage.createButton(buttonPanel, Messages.RemoteJMXStarterWizardPage_REGISTRY_SSL_LABEL, Messages.RemoteJMXStarterWizardPage_REGISTRY_SSL_DESCRIPTION, (Boolean)this.getInitial(JMXREMOTE_REGISTRY_SSL), () -> this.updatePage());
        this.autodiscoverButton = RemoteJMXAgentWizardPage.createButton(buttonPanel, Messages.RemoteJMXStarterWizardPage_AUTODISCOVERY_LABEL, Messages.RemoteJMXStarterWizardPage_AUTODISCOVERY_DESCRIPTION, this.jdpEnabled, () -> {
            boolean autodiscover = this.autodiscoverButton.getSelection();
            this.ttlText.setEnabled(autodiscover);
            this.intervalText.setEnabled(autodiscover);
            this.jdpNameText.setEnabled(autodiscover);
            this.updatePage();
        });
    }

    private Object getInitial(String settings) {
        Object o = this.initialSettings.get(settings);
        return o;
    }

    private static Button createButton(Composite parent, String label, String description, boolean defaultVal, final Runnable onSelection) {
        Button b = new Button(parent, 32);
        b.setSelection(defaultVal);
        b.setText(label);
        b.setToolTipText(description);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                onSelection.run();
            }
        });
        return b;
    }

    private Text createTextInput(Composite parent, String label, String description, String defaultVal, final Function<String, String> validator) {
        Label l = new Label(parent, 0);
        l.setText(label);
        final Text text = new Text(parent, 2048);
        text.setText(defaultVal);
        text.setToolTipText(description);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final ControlDecoration errorDec = ControlDecorationToolkit.createErrorDecorator((Control)text, (boolean)false);
        errorDec.hide();
        errorDec.setShowOnlyOnFocus(false);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String valRes = (String)validator.apply(text.getText());
                this.setValid(valRes);
                RemoteJMXAgentWizardPage.this.updatePage();
            }

            private void setValid(String errorText) {
                if (errorText == null) {
                    RemoteJMXAgentWizardPage.this.errors.put((Control)text, null);
                    errorDec.hide();
                } else {
                    RemoteJMXAgentWizardPage.this.errors.put((Control)text, errorText);
                    errorDec.setDescriptionText(errorText);
                    errorDec.show();
                }
            }
        });
        return text;
    }

    private Function<String, String> minMaxValidator(int min, int max) {
        return text -> {
            String errorText = max == Integer.MAX_VALUE ? MessageFormat.format(Messages.RemoteJMXStarterWizardPage_TOO_SMALL_ERROR, min) : MessageFormat.format(Messages.RemoteJMXStarterWizardPage_INTERVAL_ERROR, min, max);
            try {
                int v = Integer.parseInt(text);
                return v >= min && v <= max ? null : errorText;
            }
            catch (NumberFormatException numberFormatException) {
                return NLS.bind((String)Messages.RemoteJMXStarterWizardPage_CANNOT_PARSE_INT, (Object)text);
            }
        };
    }

    private void updatePage() {
        for (Map.Entry<Control, String> error : this.errors.entrySet()) {
            if (!error.getKey().isEnabled() || error.getValue() == null) continue;
            this.setErrorMessage(error.getValue());
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
        this.setCommand(this.getCommand());
    }

    private void createCommandText(Composite composite) {
        this.commandText = new Text(composite, 2122);
        this.commandText.setEditable(false);
        this.setCommand(this.getCommand());
        GridData gd = new GridData(4, 4, true, false);
        gd.widthHint = 0;
        gd.minimumHeight = -1;
        this.commandText.setLayoutData((Object)gd);
    }

    private void setCommand(String command) {
        this.commandText.setText(NLS.bind((String)Messages.RemoteJMXStarterWizardPage_COMMAND, (Object)command));
    }

    String getCommand() {
        return this.doStart ? this.getStartCommand() : this.getStopCommand();
    }

    private String getStartCommand() {
        StringBuilder cb = new StringBuilder(MANAGEMENT_AGENT_START).append(CMD_SEP);
        boolean useJdp = this.autodiscoverButton.getSelection();
        cb.append(JMXREMOTE_AUTODISCOVERY).append("=").append(String.valueOf(useJdp) + CMD_SEP);
        if (useJdp) {
            cb.append(JDP_TTL).append("=").append(String.valueOf(this.ttlText.getText()) + CMD_SEP);
            cb.append(JDP_PAUSE).append("=").append(String.valueOf(this.intervalText.getText()) + CMD_SEP);
            if (this.jdpNameText.getText().length() > 0) {
                cb.append(JDP_NAME).append("=").append(String.valueOf(this.jdpNameText.getText()) + CMD_SEP);
            }
        }
        cb.append(JMXREMOTE_SSL).append("=").append(String.valueOf(this.sslButton.getSelection()) + CMD_SEP);
        cb.append(JMXREMOTE_AUTHENTICATE).append("=").append(String.valueOf(this.authenticateButton.getSelection()) + CMD_SEP);
        cb.append(JMXREMOTE_REGISTRY_SSL).append("=").append(String.valueOf(this.registrySslButton.getSelection()) + CMD_SEP);
        cb.append(JMXREMOTE_PORT).append("=").append(String.valueOf(this.portText.getText()) + CMD_SEP);
        cb.append(JMXREMOTE_RMI_PORT).append("=").append(this.rmiPortText.getText());
        return cb.toString();
    }

    private String getStopCommand() {
        return MANAGEMENT_AGENT_STOP;
    }
}

