/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.attributes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.SectionPart;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.subscription.MRI;
import org.openjdk.jmc.rjmx.ui.RJMXUIPlugin;
import org.openjdk.jmc.rjmx.ui.attributes.Messages;
import org.openjdk.jmc.rjmx.ui.internal.CombinedChartSectionPart;
import org.openjdk.jmc.rjmx.ui.internal.NewChartAction;
import org.openjdk.jmc.rjmx.ui.internal.SectionPartManager;
import org.openjdk.jmc.ui.misc.AbstractStructuredContentProvider;
import org.openjdk.jmc.ui.wizards.IPerformFinishable;

public final class VisualizeWizardPage
extends WizardPage
implements IPerformFinishable {
    private final SectionPartManager m_sectionPartManager;
    private ListViewer m_listViewer;
    private final List<MRI> m_attributes;
    private final IConnectionHandle m_connection;

    public VisualizeWizardPage(SectionPartManager sectionPartManager, List<MRI> attributes, IConnectionHandle ch) {
        super(Messages.VisualizeWizardPage_CREATE_CHART_TITLE_TEXT);
        this.setImageDescriptor(RJMXUIPlugin.getDefault().getMCImageDescriptor("toolbar-general-64.png"));
        this.setDescription(Messages.VisualizeWizardPage_SELECT_CHART_TEXT);
        this.setTitle(Messages.VisualizeWizardPage_CREATE_CHART_TITLE_TEXT);
        this.m_sectionPartManager = sectionPartManager;
        this.m_attributes = attributes;
        this.m_connection = ch;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd1 = new GridData(4, 4, true, true);
        this.m_listViewer = this.createViewer(container);
        this.m_listViewer.getControl().setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 1, false, false);
        Control buttons = this.createButtonContainer(container);
        buttons.setLayoutData((Object)gd2);
        container.setLayout((Layout)new GridLayout(2, false));
        this.updatePageComplete(true);
        this.setControl((Control)container);
    }

    private void updatePageComplete(boolean firstTime) {
        boolean hasCharts = !this.getCharts().isEmpty();
        this.setPageComplete(hasCharts);
        if (!hasCharts && !firstTime) {
            this.setErrorMessage(Messages.VisualizeWizardPage_ERROR_TEXT_ONE_CHART_MUST_BE_SELECTED_TEXT);
        } else {
            this.setErrorMessage(null);
        }
    }

    private Control createButtonContainer(Composite parent) {
        Button addButton = new Button(parent, 0);
        addButton.setText(Messages.VisualizeWizardPage_CREATE_CHART_BUTTON_TEXT);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newChartName = this.requestChartName();
                if (newChartName == null) {
                    return;
                }
                NewChartAction action = new NewChartAction(VisualizeWizardPage.this.m_sectionPartManager, VisualizeWizardPage.this.m_connection, newChartName);
                action.run();
                VisualizeWizardPage.this.m_listViewer.refresh();
                this.selectLastListItem();
                VisualizeWizardPage.this.updatePageComplete(false);
            }

            private String requestChartName() {
                String suggestion = Messages.VisualizeWizardPage_DEFAULT_CHART_NAME;
                Iterator iterator = VisualizeWizardPage.this.m_attributes.iterator();
                if (iterator.hasNext()) {
                    MRI mri = (MRI)iterator.next();
                    suggestion = mri.getDataPath();
                }
                InputDialog id = new InputDialog(VisualizeWizardPage.this.getShell(), Messages.VisualizeWizardPage_TITLE_NEW_CHART, Messages.VisualizeWizardPage_DESCRIPTION_NEW_CHART, suggestion, new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText == null || newText.length() <= 0) {
                            return Messages.VisualizeWizardPage_INVALID_CHART_NAME;
                        }
                        return null;
                    }
                });
                id.open();
                if (id.getReturnCode() == 256) {
                    return null;
                }
                return id.getValue();
            }

            private void selectLastListItem() {
                IStructuredContentProvider listContentProvider = (IStructuredContentProvider)VisualizeWizardPage.this.m_listViewer.getContentProvider();
                Object[] elements = listContentProvider.getElements((Object)VisualizeWizardPage.this.m_sectionPartManager);
                VisualizeWizardPage.this.m_listViewer.setSelection((ISelection)new StructuredSelection(elements[elements.length - 1]));
            }
        });
        return addButton;
    }

    private ListViewer createViewer(Composite container) {
        ListViewer sectionPartViewer = new ListViewer(container);
        sectionPartViewer.setContentProvider((IContentProvider)new SectionPartContentProvider());
        sectionPartViewer.setLabelProvider((IBaseLabelProvider)new SectionPartLabelProvider());
        sectionPartViewer.setInput((Object)this.m_sectionPartManager);
        sectionPartViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                VisualizeWizardPage.this.updatePageComplete(false);
            }
        });
        return sectionPartViewer;
    }

    public boolean performFinish() {
        for (CombinedChartSectionPart part : this.getCharts()) {
            for (MRI mri : this.m_attributes) {
                part.add(mri);
            }
        }
        return true;
    }

    private List<CombinedChartSectionPart> getCharts() {
        ArrayList<CombinedChartSectionPart> list = new ArrayList<CombinedChartSectionPart>();
        IStructuredSelection selection = (IStructuredSelection)this.m_listViewer.getSelection();
        for (Object visualizer : selection) {
            if (!(visualizer instanceof CombinedChartSectionPart)) continue;
            list.add((CombinedChartSectionPart)visualizer);
        }
        return list;
    }

    static class SectionPartContentProvider
    extends AbstractStructuredContentProvider {
        SectionPartContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<IFormPart> list = new ArrayList<IFormPart>();
            SectionPartManager manager = (SectionPartManager)inputElement;
            for (IFormPart visualizer : manager.getParts()) {
                if (!(visualizer instanceof CombinedChartSectionPart)) continue;
                list.add(visualizer);
            }
            return list.toArray();
        }
    }

    static class SectionPartLabelProvider
    extends LabelProvider {
        SectionPartLabelProvider() {
        }

        public String getText(Object element) {
            return ((SectionPart)element).getSection().getText();
        }
    }
}

