/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.commands.internal.executables;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.text.ParseException;
import org.openjdk.jmc.commands.CommandsPlugin;
import org.openjdk.jmc.commands.IExecute;
import org.openjdk.jmc.commands.Statement;
import org.openjdk.jmc.common.io.IOToolkit;

public class Call
implements IExecute {
    private static final String FILENAME_PARAMETER = "filename";

    @Override
    public boolean execute(Statement statement, PrintStream out) {
        if (statement.hasValue(FILENAME_PARAMETER)) {
            try {
                this.execute(out, this.readString(statement.getString(FILENAME_PARAMETER)));
            }
            catch (IOException e) {
                out.print(e.getMessage());
            }
        }
        return false;
    }

    private boolean execute(PrintStream out, String s) {
        try {
            CommandsPlugin.getDefault().execute(s, out);
            return true;
        }
        catch (ParseException e) {
            out.println(e.getMessage());
            return false;
        }
    }

    private String readString(String fileName) throws IOException {
        String s;
        File file = new File(fileName);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        StringBuilder builder = new StringBuilder();
        try {
            while ((s = reader.readLine()) != null) {
                builder.append(String.valueOf(s) + "\r");
            }
        }
        finally {
            IOToolkit.closeSilently((Closeable)reader);
        }
        s = builder.toString();
        return s;
    }
}

