/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.common.security;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openjdk.jmc.ui.common.security.CredentialsNotAvailableException;
import org.openjdk.jmc.ui.common.security.ICredentials;
import org.openjdk.jmc.ui.common.security.SecurityException;
import org.openjdk.jmc.ui.common.security.SecurityManagerFactory;

public class PersistentCredentials
implements ICredentials {
    private final String id;
    private String[] wrapped;
    private static final Pattern PASSWORD_PATTERN = Pattern.compile("^(?=.*[0-9])(?=.*[a-z])(?=.*[A-Z])(?=.*[!@#(&)[{-}]:;',?/*~$^+=<>]).{8,20}$");

    public PersistentCredentials(String id) {
        this.id = id;
    }

    public PersistentCredentials(String username, String password) throws SecurityException {
        this(username, password, null);
    }

    public PersistentCredentials(String username, String password, String family) throws SecurityException {
        this.wrapped = new String[]{username, password};
        this.id = SecurityManagerFactory.getSecurityManager().storeInFamily(family, this.wrapped);
    }

    @Override
    public String getUsername() throws SecurityException {
        return this.getCredentials()[0];
    }

    @Override
    public String getPassword() throws SecurityException {
        return this.getCredentials()[1];
    }

    private String[] getCredentials() throws SecurityException {
        if (this.wrapped == null) {
            this.wrapped = (String[])SecurityManagerFactory.getSecurityManager().get(this.id);
        }
        if (this.wrapped == null || this.wrapped.length != 2) {
            throw new CredentialsNotAvailableException();
        }
        return this.wrapped;
    }

    @Override
    public String getExportedId() {
        return this.id;
    }

    public static boolean isPasswordValid(String password) {
        Matcher matcher = PASSWORD_PATTERN.matcher(password);
        return matcher.matches();
    }
}

