/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.heap.parser;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Logger;
import org.openjdk.jmc.joverflow.heap.parser.ReadBuffer;

class FileReadBuffer
extends ReadBuffer {
    private static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.joverflow.heap.parser");
    private RandomAccessFile file;

    FileReadBuffer(RandomAccessFile file) {
        this.file = file;
    }

    private void seek(long pos) throws IOException {
        this.file.seek(pos);
    }

    @Override
    public void get(long pos, byte[] buf) throws IOException {
        int bytesRead;
        this.seek(pos);
        int remainingBytes = buf.length;
        while ((remainingBytes -= (bytesRead = this.file.read(buf))) > 0) {
        }
    }

    @Override
    public void get(long pos, byte[] buf, int num) throws IOException {
        int bytesRead;
        this.seek(pos);
        int remainingBytes = num;
        while ((remainingBytes -= (bytesRead = this.file.read(buf, 0, num))) > 0) {
        }
    }

    public void get(long pos, byte[] buf, int startPosInBuf, int num) throws IOException {
        int bytesRead;
        this.seek(pos);
        int remainingBytes = num;
        while ((remainingBytes -= (bytesRead = this.file.read(buf, startPosInBuf, num))) > 0) {
        }
    }

    @Override
    public int getInt(long pos) throws IOException {
        this.seek(pos);
        return this.file.readInt();
    }

    @Override
    public long getLong(long pos) throws IOException {
        this.seek(pos);
        return this.file.readLong();
    }

    @Override
    public void close() {
        try {
            this.file.close();
        }
        catch (IOException ex) {
            LOGGER.severe("Failed to close file " + this.file + ": " + ex);
        }
    }
}

