/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.stats;

import java.util.Collection;
import org.openjdk.jmc.joverflow.descriptors.CollectionDescriptors;
import org.openjdk.jmc.joverflow.descriptors.CollectionInstanceDescriptor;
import org.openjdk.jmc.joverflow.heap.model.HeapStringReader;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObject;
import org.openjdk.jmc.joverflow.heap.model.JavaLazyReadObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObjectArray;
import org.openjdk.jmc.joverflow.heap.model.JavaThing;
import org.openjdk.jmc.joverflow.heap.model.JavaValueArray;
import org.openjdk.jmc.joverflow.heap.model.Snapshot;
import org.openjdk.jmc.joverflow.heap.parser.HprofParsingCancelledException;
import org.openjdk.jmc.joverflow.stats.DepthFirstHeapScaner;
import org.openjdk.jmc.joverflow.stats.DupStringHandler;
import org.openjdk.jmc.joverflow.stats.InterimRefChain;
import org.openjdk.jmc.joverflow.stats.ProblemChecker;
import org.openjdk.jmc.joverflow.stats.StringStatsCollector;
import org.openjdk.jmc.joverflow.support.DupStringStats;
import org.openjdk.jmc.joverflow.support.ProblemRecorder;

class DetailedDupStringStatsCalculator
implements ProblemChecker {
    private final Snapshot snapshot;
    private final InterimRefChain refChain;
    private final DepthFirstHeapScaner scaner;
    private final HeapStringReader stringReader;
    private DupStringHandler dupStringHandler;

    public DetailedDupStringStatsCalculator(Snapshot snapshot, ProblemRecorder recorder) {
        this.snapshot = snapshot;
        CollectionDescriptors colDescriptors = new CollectionDescriptors(snapshot);
        this.scaner = new DepthFirstHeapScaner(snapshot, this, recorder, colDescriptors);
        this.refChain = this.scaner.getRefChain();
        this.stringReader = snapshot.getStringReader();
    }

    public DupStringStats calculate() throws HprofParsingCancelledException {
        DupStringStats dss = this.findDupStrings();
        this.findRefsToDupStrings(dss);
        return dss;
    }

    private DupStringStats findDupStrings() {
        Collection<JavaLazyReadObject> allObjects = this.snapshot.getObjects();
        StringStatsCollector stringDupMap = new StringStatsCollector(this.snapshot);
        for (JavaLazyReadObject obj : allObjects) {
            JavaClass clazz = obj.getClazz();
            if (!clazz.isString()) continue;
            stringDupMap.add((JavaObject)obj);
        }
        return stringDupMap.getDuplicationStats();
    }

    private void findRefsToDupStrings(DupStringStats dss) throws HprofParsingCancelledException {
        this.dupStringHandler = new DupStringHandler(this.stringReader, dss.dupStrings, this.refChain, dss.stringInstShallowSize);
        this.scaner.analyzeViaRoots();
    }

    @Override
    public CollectionInstanceDescriptor handleInstance(JavaObject obj, JavaThing[] fields) {
        return null;
    }

    @Override
    public void handleObjectArray(JavaObjectArray array, JavaHeapObject[] elements) {
    }

    @Override
    public void handleValueArray(JavaValueArray array) {
    }

    @Override
    public void handleString(JavaObject strObj) {
        boolean isDuplicated = this.dupStringHandler.handleString(strObj);
        JavaValueArray backingCharArray = this.dupStringHandler.getLastReadBackingArray();
        if (backingCharArray != null) {
            backingCharArray.setVisited();
        }
        if (!isDuplicated) {
            this.refChain.recordCurrentRefChainForNonDupString(strObj, strObj.getSize() + backingCharArray.getSize());
        }
    }

    public int getProgressPercentage() {
        return this.scaner.getProgressPercentage();
    }
}

