/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.stats;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.openjdk.jmc.joverflow.util.IntToObjectMap;

public class LengthHistogram {
    private final ArrayList<Entry> values;
    private static final Comparator<Entry> SPECIAL_LENGTH_COMPARATOR = new Comparator<Entry>(){

        @Override
        public int compare(Entry o1, Entry o2) {
            if (o1.length == -1) {
                return 1;
            }
            if (o2.length == -1) {
                return -1;
            }
            return o1.length - o2.length;
        }
    };

    private LengthHistogram(ArrayList<Entry> values) {
        this.values = values;
    }

    public List<Entry> getPrunedAndSortedEntries(int sizeThreshold) {
        ArrayList<Entry> result = new ArrayList<Entry>(this.values.size() / 2);
        Entry entryForOthers = new Entry(-1);
        for (Entry entry : this.values) {
            if (entry.getSize() >= (long)sizeThreshold) {
                result.add(entry);
                continue;
            }
            entryForOthers.addEntry(entry);
        }
        result.add(entryForOthers);
        result.sort(SPECIAL_LENGTH_COMPARATOR);
        return result;
    }

    /* synthetic */ LengthHistogram(ArrayList arrayList, LengthHistogram lengthHistogram) {
        this(arrayList);
    }

    public static class Builder {
        private final IntToObjectMap<Entry> lenToEntry;

        public Builder(int capacity) {
            this.lenToEntry = new IntToObjectMap(capacity, false);
        }

        public void addInstance(int length, int size) {
            Entry entry = this.lenToEntry.get(length);
            if (entry == null) {
                entry = new Entry(length);
                this.lenToEntry.put(length, entry);
            }
            entry.addInstance(size);
        }

        public LengthHistogram build() {
            ArrayList result = new ArrayList(this.lenToEntry.size());
            result.addAll(this.lenToEntry.values());
            return new LengthHistogram(result, null);
        }

        public int size() {
            return this.lenToEntry.size();
        }
    }

    public static class Entry {
        public static final int SPECIAL_VALUE = -1;
        private final int length;
        private int count;
        private long size;

        private Entry(int length) {
            this.length = length;
        }

        private void addInstance(int instSize) {
            ++this.count;
            this.size += (long)instSize;
        }

        private void addEntry(Entry other) {
            this.count += other.count;
            this.size += other.size;
        }

        public int getLength() {
            return this.length;
        }

        public int getCount() {
            return this.count;
        }

        public long getSize() {
            return this.size;
        }
    }
}

