/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.support;

import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaField;
import org.openjdk.jmc.joverflow.heap.model.Root;
import org.openjdk.jmc.joverflow.support.RefChainElement;
import org.openjdk.jmc.joverflow.util.FastStack;
import org.openjdk.jmc.joverflow.util.IndexContainer;
import org.openjdk.jmc.joverflow.util.StringInterner;

public class RefChainElementImpl {
    private static final int MAX_STATIC_CHILDREN_LIST_SIZE = 100;

    public static InstanceFieldOrLinkedList getInstanceFieldElement(JavaClass clazz, int fieldIdx, RefChainElement refererElement) {
        ElementWithChildren referer = (ElementWithChildren)refererElement;
        ElementWithChildren[] children = (ElementWithChildren[])referer.refererOrChildren;
        int clazzIdx = clazz.getClassListIdx();
        String clazzName = clazz.getName();
        ElementWithChildren[] elementWithChildrenArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            InstanceFieldOrLinkedList ifChild;
            ElementWithChildren child = elementWithChildrenArray[n2];
            if (child instanceof InstanceFieldOrLinkedList && (ifChild = (InstanceFieldOrLinkedList)child).isInstanceField() && ifChild.getFieldIdx() == fieldIdx && (ifChild.getJavaClass().getClassListIdx() == clazzIdx || ifChild.getJavaClass().getName().equals(clazzName))) {
                return ifChild;
            }
            ++n2;
        }
        InstanceFieldOrLinkedList result = new InstanceFieldOrLinkedList(clazz, fieldIdx, true);
        referer.addChild(result);
        return result;
    }

    public static StaticField getStaticFieldElement(JavaClass clazz, int staticFieldIdx, RefChainElement refererElement) {
        ElementWithChildren referer = (ElementWithChildren)refererElement;
        ElementWithChildren[] children = (ElementWithChildren[])referer.refererOrChildren;
        int clazzIdx = clazz.getClassListIdx();
        String clazzName = clazz.getName();
        int nChildren = children.length;
        if (nChildren <= 100) {
            int i = children.length - 1;
            while (i >= 0) {
                StaticField sfChild;
                ElementWithChildren child = children[i];
                if (child instanceof StaticField && (sfChild = (StaticField)child).getFieldIdx() == staticFieldIdx && (sfChild.getJavaClass().getClassListIdx() == clazzIdx || sfChild.getJavaClass().getName().equals(clazzName))) {
                    return sfChild;
                }
                --i;
            }
        } else {
            int hash = (clazz.getName().hashCode() << 4) + staticFieldIdx;
            int pos = (hash & Integer.MAX_VALUE) % nChildren;
            int nIters = 0;
            while (children[pos] != null && nIters++ < nChildren) {
                StaticField sfChild;
                ElementWithChildren child = children[pos];
                if (child instanceof StaticField && (sfChild = (StaticField)child).getFieldIdx() == staticFieldIdx && (sfChild.getJavaClass().getClassListIdx() == clazzIdx || sfChild.getJavaClass().getName().equals(clazzName))) {
                    return sfChild;
                }
                pos = (pos + 1) % nChildren;
            }
        }
        StaticField result = new StaticField(clazz, staticFieldIdx);
        if (nChildren <= 100) {
            referer.addChild(result);
            if (((ElementWithChildren[])referer.refererOrChildren).length > 100) {
                referer.convertChildrenToHashFormat();
            }
        } else {
            referer.addChildToHashChildren(result);
        }
        return result;
    }

    public static Collection getCompoundCollectionElement(JavaClass clazz, RefChainElement refererElement) {
        ElementWithChildren referer = (ElementWithChildren)refererElement;
        ElementWithChildren[] children = (ElementWithChildren[])referer.refererOrChildren;
        int clazzIdx = clazz.getClassListIdx();
        String clazzName = clazz.getName();
        ElementWithChildren[] elementWithChildrenArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ElementWithChildren child = elementWithChildrenArray[n2];
            if (child instanceof Collection && (child.getJavaClass().getClassListIdx() == clazzIdx || child.getJavaClass().getName().equals(clazzName))) {
                return (Collection)child;
            }
            ++n2;
        }
        Collection result = new Collection(clazz);
        referer.addChild(result);
        return result;
    }

    public static InstanceFieldOrLinkedList getCompoundLinkedListElement(JavaClass clazz, int fieldIdx, RefChainElement refererElement) {
        ElementWithChildren referer = (ElementWithChildren)refererElement;
        ElementWithChildren[] children = (ElementWithChildren[])referer.refererOrChildren;
        int clazzIdx = clazz.getClassListIdx();
        ElementWithChildren[] elementWithChildrenArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            InstanceFieldOrLinkedList llChild;
            ElementWithChildren child = elementWithChildrenArray[n2];
            if (child instanceof InstanceFieldOrLinkedList && !(llChild = (InstanceFieldOrLinkedList)child).isInstanceField() && (llChild.getJavaClass().getClassListIdx() == clazzIdx || llChild.getJavaClass().getName().equals(clazz.getName())) && llChild.getFieldIdx() == fieldIdx) {
                return llChild;
            }
            ++n2;
        }
        InstanceFieldOrLinkedList result = new InstanceFieldOrLinkedList(clazz, fieldIdx, false);
        referer.addChild(result);
        return result;
    }

    public static Array getCompoundArrayElement(JavaClass clazz, RefChainElement refererElement) {
        ElementWithChildren[] children;
        ElementWithChildren referer = (ElementWithChildren)refererElement;
        ElementWithChildren[] elementWithChildrenArray = children = (ElementWithChildren[])referer.refererOrChildren;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ElementWithChildren child = elementWithChildrenArray[n2];
            if (child instanceof Array && child.getJavaClass().getName().equals(clazz.getName())) {
                return (Array)child;
            }
            ++n2;
        }
        Array result = new Array(clazz);
        referer.addChild(result);
        return result;
    }

    public static InstanceFieldOrLinkedList createInstanceFieldOrLinkedListElementInFinalForm(JavaClass clazz, int fieldIdx, RefChainElement refererElement, boolean isInstanceField) {
        InstanceFieldOrLinkedList result = new InstanceFieldOrLinkedList(clazz, fieldIdx, isInstanceField);
        result.setReferer(refererElement);
        return result;
    }

    public static StaticField createStaticFieldElementInFinalForm(JavaClass clazz, int staticFieldIdx, RefChainElement refererElement) {
        StaticField result = new StaticField(clazz, staticFieldIdx);
        result.setReferer(refererElement);
        return result;
    }

    public static Collection createCompoundCollectionElementInFinalForm(JavaClass clazz, RefChainElement refererElement) {
        Collection result = new Collection(clazz);
        result.setReferer(refererElement);
        return result;
    }

    public static Array createCompoundArrayElementInFinalForm(JavaClass clazz, RefChainElement refererElement) {
        Array result = new Array(clazz);
        result.setReferer(refererElement);
        return result;
    }

    private static abstract class AbstractElement
    extends ElementWithChildren {
        private final JavaClass clazz;
        protected String cachedToStringValue;

        @Override
        public JavaClass getJavaClass() {
            return this.clazz;
        }

        @Override
        public RefChainElement getReferer() {
            return (RefChainElement)this.refererOrChildren;
        }

        private AbstractElement(JavaClass clazz) {
            this.clazz = clazz;
        }

        @Override
        public boolean equals(Object other) {
            if (!this.shallowEquals(other)) {
                return false;
            }
            return this.referersEqual((AbstractElement)other);
        }

        @Override
        public int hashCode() {
            return (this.referersHashCode() << 4) + this.shallowHashCode();
        }

        @Override
        public boolean shallowEquals(Object otherObj) {
            if (otherObj == this) {
                return true;
            }
            if (otherObj == null) {
                return false;
            }
            if (this.getClass() != otherObj.getClass()) {
                return false;
            }
            return this.clazz.getClassListIdx() == ((AbstractElement)otherObj).clazz.getClassListIdx() || this.clazz.getName().equals(((AbstractElement)otherObj).clazz.getName());
        }

        private boolean referersEqual(AbstractElement other) {
            RefChainElement otherReferer;
            RefChainElement thisReferer = this.getReferer();
            if (thisReferer == (otherReferer = other.getReferer())) {
                return true;
            }
            if (thisReferer == null || otherReferer == null) {
                return false;
            }
            return thisReferer.equals(otherReferer);
        }

        @Override
        public int shallowHashCode() {
            return this.clazz.getName().hashCode();
        }

        private int referersHashCode() {
            RefChainElement referer = this.getReferer();
            if (referer == null) {
                return 0;
            }
            return referer.hashCode();
        }
    }

    public static abstract class AbstractField
    extends AbstractElement {
        protected final char fieldIdx;

        public int getFieldIdx() {
            return this.fieldIdx;
        }

        protected AbstractField(JavaClass clazz, int fieldIdx) {
            super(clazz);
            this.fieldIdx = (char)fieldIdx;
        }

        @Override
        public boolean shallowEquals(Object otherObj) {
            if (!super.shallowEquals(otherObj)) {
                return false;
            }
            return this.fieldIdx == ((AbstractField)otherObj).fieldIdx;
        }

        @Override
        public int shallowHashCode() {
            return (super.shallowHashCode() << 4) + this.fieldIdx;
        }
    }

    public static class Array
    extends AbstractElement {
        private Array(JavaClass clazz) {
            super(clazz);
        }

        public String toString() {
            if (this.cachedToStringValue == null) {
                this.cachedToStringValue = StringInterner.internString(this.getJavaClass().getHumanFriendlyName());
            }
            return this.cachedToStringValue;
        }
    }

    public static class Collection
    extends AbstractElement {
        private Collection(JavaClass clazz) {
            super(clazz);
        }

        public String toString() {
            if (this.cachedToStringValue == null) {
                String clsName = this.getJavaClass().getHumanFriendlyName();
                this.cachedToStringValue = StringInterner.internString(String.valueOf('{') + clsName + '}');
            }
            return this.cachedToStringValue;
        }
    }

    private static abstract class ElementWithChildren
    implements RefChainElement {
        protected static final int INIT_CHILDREN_SIZE = 2;
        protected Object refererOrChildren = new ElementWithChildren[2];

        private ElementWithChildren() {
        }

        void addChild(ElementWithChildren child) {
            ElementWithChildren[] children = (ElementWithChildren[])this.refererOrChildren;
            int curArraySize = children.length;
            if (children[curArraySize - 1] != null) {
                ElementWithChildren[] oldChildren = children;
                children = new ElementWithChildren[curArraySize + 4];
                System.arraycopy(oldChildren, 0, children, 0, curArraySize);
                children[curArraySize] = child;
                this.refererOrChildren = children;
            } else {
                int idx = curArraySize - 1;
                while (idx >= 0 && children[idx] == null) {
                    --idx;
                }
                children[idx + 1] = child;
            }
        }

        void setReferer(RefChainElement referer) {
            this.refererOrChildren = referer;
        }

        static void switchSubtreeToFinalFormat(ElementWithChildren rootElement) {
            FastStack<Object> stack = new FastStack<Object>(80);
            stack.push(rootElement);
            stack.push(rootElement.refererOrChildren);
            stack.push(new IndexContainer());
            while (!stack.isEmpty()) {
                ElementWithChildren parent = (ElementWithChildren)stack.peek(2);
                ElementWithChildren[] children = (ElementWithChildren[])stack.peek(1);
                IndexContainer index = (IndexContainer)stack.peek();
                int nextIdx = index.incrementAndGet();
                while (nextIdx < children.length && children[nextIdx] == null) {
                    nextIdx = index.incrementAndGet();
                }
                if (nextIdx < children.length) {
                    ElementWithChildren child = children[nextIdx];
                    ElementWithChildren[] childsChildren = (ElementWithChildren[])child.refererOrChildren;
                    if (childsChildren[0] != null || childsChildren.length > 2) {
                        stack.push(child);
                        stack.push(child.refererOrChildren);
                        stack.push(new IndexContainer());
                    }
                    child.refererOrChildren = parent;
                    continue;
                }
                stack.pop(3);
            }
        }

        void convertChildrenToHashFormat() {
            ElementWithChildren[] oldChildren = (ElementWithChildren[])this.refererOrChildren;
            int capacity = oldChildren.length * 2 | 1;
            this.createTable(oldChildren, capacity);
        }

        void addChildToHashChildren(ElementWithChildren child) {
            ElementWithChildren[] children = (ElementWithChildren[])this.refererOrChildren;
            int capacity = children.length;
            int pos = (child.shallowHashCode() & Integer.MAX_VALUE) % capacity;
            int seqLen = 0;
            while (children[pos] != null) {
                if (++seqLen > capacity / 8) {
                    this.createTable(children, capacity * 3 / 2 | 1);
                    this.addChildToHashChildren(child);
                    return;
                }
                pos = (pos + 1) % capacity;
            }
            children[pos] = child;
        }

        void createTable(ElementWithChildren[] oldChildren, int capacity) {
            ElementWithChildren[] children = new ElementWithChildren[capacity];
            ElementWithChildren[] elementWithChildrenArray = oldChildren;
            int n = oldChildren.length;
            int n2 = 0;
            while (n2 < n) {
                ElementWithChildren child = elementWithChildrenArray[n2];
                if (child != null) {
                    int pos = (child.shallowHashCode() & Integer.MAX_VALUE) % capacity;
                    while (children[pos] != null) {
                        pos = (pos + 1) % capacity;
                    }
                    children[pos] = child;
                }
                ++n2;
            }
            this.refererOrChildren = children;
        }

        public abstract boolean equals(Object var1);

        public abstract int hashCode();
    }

    public static class GCRoot
    extends ElementWithChildren {
        private final Root root;

        @Override
        public JavaClass getJavaClass() {
            return null;
        }

        @Override
        public RefChainElement getReferer() {
            return null;
        }

        public Root getRoot() {
            return this.root;
        }

        public GCRoot(Root root) {
            this.root = root;
        }

        public void switchTreeToFinalFormat() {
            GCRoot.switchSubtreeToFinalFormat(this);
        }

        public String toString() {
            return StringInterner.internString(this.root.getIdString());
        }

        @Override
        public boolean equals(Object otherObj) {
            if (otherObj == this) {
                return true;
            }
            if (!(otherObj instanceof GCRoot)) {
                return false;
            }
            GCRoot other = (GCRoot)otherObj;
            return this.root == other.root;
        }

        @Override
        public int hashCode() {
            return this.root.hashCode();
        }

        @Override
        public boolean shallowEquals(Object other) {
            return this.equals(other);
        }

        @Override
        public int shallowHashCode() {
            return this.hashCode();
        }
    }

    public static class InstanceFieldOrLinkedList
    extends AbstractField {
        private boolean isInstanceField;

        private InstanceFieldOrLinkedList(JavaClass clazz, int fieldIdx, boolean isInstanceField) {
            super(clazz, fieldIdx);
            this.isInstanceField = isInstanceField;
        }

        public boolean isInstanceField() {
            return this.isInstanceField;
        }

        public String getFieldName() {
            return this.getJavaClass().getFieldForInstance(this.fieldIdx).getName();
        }

        public JavaClass getFieldDeclaringClass() {
            return this.getJavaClass().getDeclaringClassForField(this.fieldIdx);
        }

        public void switchToLinkedList() {
            this.isInstanceField = false;
            this.cachedToStringValue = null;
        }

        public String toString() {
            if (this.cachedToStringValue == null) {
                String clsName = this.getJavaClass().getHumanFriendlyName();
                this.cachedToStringValue = this.isInstanceField ? StringInterner.internString(String.valueOf(clsName) + '.' + this.getFieldName()) : StringInterner.internString(String.valueOf('{') + clsName + '.' + this.getJavaClass().getFieldForInstance(this.fieldIdx).getName() + '}');
            }
            return this.cachedToStringValue;
        }

        @Override
        public boolean shallowEquals(Object otherObj) {
            if (!super.shallowEquals(otherObj)) {
                return false;
            }
            return this.isInstanceField == ((InstanceFieldOrLinkedList)otherObj).isInstanceField;
        }

        @Override
        public int shallowHashCode() {
            return (super.shallowHashCode() << 1) + (this.isInstanceField ? 1 : 0);
        }
    }

    public static class StaticField
    extends AbstractField {
        private StaticField(JavaClass clazz, int fieldIdx) {
            super(clazz, fieldIdx);
        }

        public String toString() {
            if (this.cachedToStringValue == null) {
                String clsName = this.getJavaClass().getHumanFriendlyName();
                JavaField[] statics = this.getJavaClass().getStaticFields();
                this.cachedToStringValue = StringInterner.internString(String.valueOf(clsName) + ':' + statics[this.fieldIdx].getName());
            }
            return this.cachedToStringValue;
        }
    }
}

