/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.mbeanbrowser.metadata;

import java.util.Arrays;
import javax.management.ObjectName;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.console.ui.mbeanbrowser.metadata.ItemContentProvider;
import org.openjdk.jmc.console.ui.mbeanbrowser.metadata.Messages;
import org.openjdk.jmc.console.ui.mbeanbrowser.metadata.MetadataModel;
import org.openjdk.jmc.rjmx.ui.internal.MBeanPropertiesOrderer;
import org.openjdk.jmc.ui.column.ColumnBuilder;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.MementoToolkit;

public final class ItemSectionPart
implements MBeanPropertiesOrderer.IMBeanPropertiesOrderChangedListener {
    private final ColumnManager columnManager;

    public ItemSectionPart(Composite parent, FormToolkit toolkit, IMemento state) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.ItemSectionPart_MBEAN_TITLE_TEXT);
        Tree tree = new Tree((Composite)section, 68354);
        section.setClient((Control)tree);
        TreeViewer viewer = new TreeViewer(tree);
        IColumn itemColumn = new ColumnBuilder(Messages.ItemSectionPart_INFO_ITEM_NAME_TEXT, "item", new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ObjectName) {
                    return Messages.ItemContentProvider_MBEAN_NAME_TEXT;
                }
                if (element instanceof String[]) {
                    return ((String[])element)[0];
                }
                return super.getText(element);
            }
        }).description(Messages.ItemSectionPart_INFO_ITEM_DESCRIPTION_TEXT).build();
        IColumn valueColumn = new ColumnBuilder(Messages.ItemSectionPart_INFO_VALUE_NAME_TEXT, "value", new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ObjectName) {
                    return MBeanPropertiesOrderer.getMBeanPath((ObjectName)((ObjectName)element));
                }
                if (element instanceof String[]) {
                    return ((String[])element)[1];
                }
                return super.getText(element);
            }
        }).description(Messages.ItemSectionPart_INFO_VALUE_DESCRIPTION_TEXT).build();
        this.columnManager = ColumnManager.build((TreeViewer)viewer, Arrays.asList(itemColumn, valueColumn), (TableSettings)TableSettings.forState((IState)MementoToolkit.asState((IMemento)state)));
        viewer.setContentProvider((IContentProvider)new ItemContentProvider());
        viewer.setAutoExpandLevel(-1);
        ColumnMenusFactory.addDefaultMenus((ColumnManager)this.columnManager, (MCContextMenuManager)MCContextMenuManager.create((Control)tree));
    }

    public void saveState(IMemento state) {
        this.columnManager.getSettings().saveState(MementoToolkit.asWritableState((IMemento)state));
    }

    public void setModel(MetadataModel model) {
        this.columnManager.getViewer().setInput((Object)model);
    }

    public void propertiesOrderChanged(PropertyChangeEvent e) {
        this.columnManager.getViewer().refresh();
    }
}

