/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.browser.jdp.preferences;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.openjdk.jmc.browser.jdp.JDPPlugin;
import org.openjdk.jmc.browser.jdp.preferences.Messages;

public class JDPPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private StringFieldEditor jdpAddress;
    private IntegerFieldEditor jdpPort;
    private IntegerFieldEditor heartBeatTimeout;

    public JDPPreferencePage() {
        super(1);
        this.setPreferenceStore(JDPPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.JDPPreferencePage_JDP_PREFERENCES_DESCRIPTION);
    }

    public void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor("org.openjdk.jmc.jdp.auto.discovery", Messages.JDPPreferencePage_JDP_PREFERENCES_ENABLE_AUTO_DISCOVERY, this.getFieldEditorParent()));
        this.jdpAddress = new StringFieldEditor("org.openjdk.jmc.jdp.address", Messages.JDPPreferencePage_CAPTION_MULTICAST_ADDRESS, this.getFieldEditorParent());
        this.addField((FieldEditor)this.jdpAddress);
        this.jdpPort = new IntegerFieldEditor("org.openjdk.jmc.jdp.port", Messages.JDPPreferencePage_CAPTION_MULTICAST_PORT, this.getFieldEditorParent());
        this.addField((FieldEditor)this.jdpPort);
        this.heartBeatTimeout = new IntegerFieldEditor("org.openjdk.jmc.jdp.hbtimeout", Messages.JDPPreferencePage_CAPTION_MAX_HEART_BEAT_TIMEOUT, this.getFieldEditorParent());
        this.addField((FieldEditor)this.heartBeatTimeout);
        this.enableJdpFields(this.isJdpAutoDiscoveryEnabled());
    }

    public void init(IWorkbench workbench) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        FieldEditor editor;
        if (event.getProperty().equals("field_editor_value") && "org.openjdk.jmc.jdp.auto.discovery".equals((editor = (FieldEditor)event.getSource()).getPreferenceName())) {
            if (((Boolean)event.getNewValue()).booleanValue()) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.JDPPreferencePage_JDP_PREFERENCES_ENABLE_WARNING_TITLE, (String)Messages.JDPPreferencePage_JDP_PREFERENCES_ENABLE_WARNING_INFO);
            }
            this.enableJdpFields((Boolean)event.getNewValue());
        }
        super.propertyChange(event);
    }

    private boolean isJdpAutoDiscoveryEnabled() {
        return JDPPlugin.getDefault().getPreferenceStore().getBoolean("org.openjdk.jmc.jdp.auto.discovery");
    }

    private void enableJdpFields(boolean enable) {
        this.jdpAddress.setEnabled(enable, this.getFieldEditorParent());
        this.jdpPort.setEnabled(enable, this.getFieldEditorParent());
        this.heartBeatTimeout.setEnabled(enable, this.getFieldEditorParent());
    }
}

