/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.report.html;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.util.XmlToolkit;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.JfrLoaderToolkit;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.RuleRegistry;
import org.openjdk.jmc.flightrecorder.rules.report.html.internal.HtmlResultGroup;
import org.openjdk.jmc.flightrecorder.rules.report.html.internal.HtmlResultProvider;
import org.openjdk.jmc.flightrecorder.rules.report.html.internal.RulesHtmlToolkit;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JfrHtmlRulesReport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block8: {
            if (args.length == 0) {
                System.err.println("Enter one or two arguments to this program:");
                System.err.println("The first argument must be a JFR file.");
                System.err.println("The second optional argument is the output file.");
                System.err.println("If an output file is not specified, then the output will be written to stdout.");
                System.exit(1);
            }
            try {
                String report = JfrHtmlRulesReport.createReport(new File(args[0]));
                if (args.length > 1) {
                    PrintStream out = null;
                    try {
                        out = new PrintStream(new File(args[1]));
                        out.print(report);
                    }
                    catch (FileNotFoundException e) {
                        try {
                            JfrHtmlRulesReport.getLogger().log(Level.SEVERE, "Could not open output file: " + e.getMessage());
                            System.exit(3);
                        }
                        catch (Throwable throwable) {
                            IOToolkit.closeSilently(out);
                            throw throwable;
                        }
                        IOToolkit.closeSilently((Closeable)out);
                        break block8;
                    }
                    IOToolkit.closeSilently((Closeable)out);
                    break block8;
                }
                System.out.print(report);
            }
            catch (IOException | CouldNotLoadRecordingException e) {
                JfrHtmlRulesReport.getLogger().log(Level.SEVERE, "Could not load recording file: " + e.getMessage());
                System.exit(2);
            }
        }
    }

    private static Logger getLogger() {
        return Logger.getLogger(JfrHtmlRulesReport.class.getName());
    }

    public static String createReport(File jfrFile) throws IOException, CouldNotLoadRecordingException {
        return JfrHtmlRulesReport.createReport(JfrLoaderToolkit.loadEvents((File)jfrFile));
    }

    public static String createReport(InputStream stream) throws IOException, CouldNotLoadRecordingException {
        return JfrHtmlRulesReport.createReport(JfrLoaderToolkit.loadEvents((InputStream)stream));
    }

    public static String createReport(IItemCollection events) {
        Map<IRule, Future<IResult>> resultFutures = RulesToolkit.evaluateParallel(RuleRegistry.getRules(), events, null, 0);
        HashSet<IResult> results = new HashSet<IResult>();
        for (Map.Entry<IRule, Future<IResult>> resultEntry : resultFutures.entrySet()) {
            try {
                results.add(resultEntry.getValue().get());
            }
            catch (Throwable t) {
                JfrHtmlRulesReport.getLogger().log(Level.WARNING, "Error while evaluating rule \"" + resultEntry.getKey().getName() + "\"", t);
            }
        }
        List<HtmlResultGroup> groups = JfrHtmlRulesReport.loadResultGroups();
        String report = RulesHtmlToolkit.generateStructuredHtml(new SimpleResultProvider(results, groups), groups, new HashMap<String, Boolean>(), true);
        return report;
    }

    private static List<HtmlResultGroup> loadResultGroups() {
        Document document;
        InputStream is = JfrHtmlRulesReport.class.getResourceAsStream("resultgroups.xml");
        try {
            document = XmlToolkit.loadDocumentFromStream((InputStream)is);
        }
        catch (SAXException e) {
            JfrHtmlRulesReport.getLogger().log(Level.WARNING, "Could not parse result groups: " + e.getMessage());
            document = JfrHtmlRulesReport.createEmptyGroupsDocument();
        }
        catch (IOException e) {
            JfrHtmlRulesReport.getLogger().log(Level.WARNING, "Could not read result groups file: " + e.getMessage());
            document = JfrHtmlRulesReport.createEmptyGroupsDocument();
        }
        finally {
            IOToolkit.closeSilently((Closeable)is);
        }
        Element element = document.getDocumentElement();
        return JfrHtmlRulesReport.loadResultGroups(element);
    }

    private static Document createEmptyGroupsDocument() {
        try {
            return XmlToolkit.createNewDocument((String)"groups");
        }
        catch (IOException e) {
            JfrHtmlRulesReport.getLogger().log(Level.SEVERE, "Internal error while creating empty XML");
            return null;
        }
    }

    private static List<HtmlResultGroup> loadResultGroups(Element element) {
        ArrayList<HtmlResultGroup> groups = new ArrayList<HtmlResultGroup>();
        NodeList childList = element.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node childNode = childList.item(i);
            if (!childNode.getNodeName().equals("group") || !(childNode instanceof Element)) continue;
            groups.add(new SimpleResultGroup((Element)childNode));
        }
        return groups;
    }

    private static class SimpleResultGroup
    implements HtmlResultGroup {
        String name;
        String image = null;
        List<HtmlResultGroup> children = new ArrayList<HtmlResultGroup>();
        List<String> topics = new ArrayList<String>();

        public SimpleResultGroup(Element element) {
            this.name = element.getAttribute("name");
            if (element.hasAttribute("image")) {
                this.image = element.getAttribute("image");
            }
            NodeList childList = element.getChildNodes();
            for (int i = 0; i < childList.getLength(); ++i) {
                Node childNode = childList.item(i);
                if (!(childNode instanceof Element)) continue;
                Element childElement = (Element)childNode;
                if (childElement.getNodeName().equals("topic") && childElement.hasAttribute("name")) {
                    this.topics.add(childElement.getAttribute("name"));
                    continue;
                }
                if (!childElement.getNodeName().equals("group")) continue;
                this.children.add(new SimpleResultGroup(childElement));
            }
        }

        @Override
        public String getId() {
            return Integer.toString(this.hashCode());
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getImage() {
            return this.image;
        }

        @Override
        public List<HtmlResultGroup> getChildren() {
            return this.children;
        }

        @Override
        public boolean hasChildren() {
            return !this.children.isEmpty();
        }

        @Override
        public Collection<String> getTopics() {
            return this.topics;
        }
    }

    private static class SimpleResultProvider
    implements HtmlResultProvider {
        private Map<String, Collection<IResult>> resultsByTopic = new HashMap<String, Collection<IResult>>();
        private Set<String> unmappedTopics;

        public SimpleResultProvider(Collection<IResult> results, List<HtmlResultGroup> groups) {
            for (IResult result : results) {
                Collection<IResult> topicResults;
                String topic = result.getRule().getTopic();
                if (topic == null) {
                    topic = "";
                }
                if ((topicResults = this.resultsByTopic.get(topic)) == null) {
                    topicResults = new HashSet<IResult>();
                    this.resultsByTopic.put(topic, topicResults);
                }
                topicResults.add(result);
            }
            this.unmappedTopics = new HashSet<String>(this.resultsByTopic.keySet());
            SimpleResultProvider.removeMappedTopics(this.unmappedTopics, groups);
        }

        private static void removeMappedTopics(Set<String> unmappedTopics, List<HtmlResultGroup> groups) {
            for (HtmlResultGroup group : groups) {
                for (String topic : group.getTopics()) {
                    unmappedTopics.remove(topic);
                }
                SimpleResultProvider.removeMappedTopics(unmappedTopics, group.getChildren());
            }
        }

        @Override
        public Collection<IResult> getResults(Collection<String> topics) {
            Collection<String> topics2 = topics;
            if (topics2.contains("")) {
                topics2 = new HashSet<String>(topics);
                topics2.addAll(this.unmappedTopics);
            }
            HashSet<IResult> results = new HashSet<IResult>();
            for (String topic : topics2) {
                Collection<IResult> topicResults = this.resultsByTopic.get(topic);
                if (topicResults == null) continue;
                results.addAll(topicResults);
            }
            return results;
        }
    }
}

