/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.tree.traversal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.flightrecorder.rules.tree.traversal.BFTreeVisitor;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class LayerBreakdownVisitor
extends BFTreeVisitor<IItem> {
    public static final Comparator<LayerBreakdown> BREAKDOWN_COMPARATOR = new Comparator<LayerBreakdown>(){

        @Override
        public int compare(LayerBreakdown o1, LayerBreakdown o2) {
            return o1.layer.compareTo(o2.layer);
        }
    };
    private static final Comparator<LayerEntry> ENTRY_COMPARATOR = new Comparator<LayerEntry>(){

        @Override
        public int compare(LayerEntry o1, LayerEntry o2) {
            return o2.getDuration().compareTo((Object)o1.getDuration());
        }
    };
    private Map<Integer, LayerBreakdown> layersMap = new HashMap<Integer, LayerBreakdown>();

    @Override
    protected void processPayload(IItem value, int level) {
        Integer layer = level;
        LayerBreakdown breakdown = this.layersMap.get(layer);
        if (breakdown == null) {
            breakdown = new LayerBreakdown(level);
            this.layersMap.put(layer, breakdown);
        }
        if (value != null) {
            breakdown.add(value);
        }
    }

    public List<LayerBreakdown> getLayers() {
        ArrayList<LayerBreakdown> layers = new ArrayList<LayerBreakdown>();
        layers.addAll(this.layersMap.values());
        layers.sort(BREAKDOWN_COMPARATOR);
        return layers;
    }

    public static class LayerEntry {
        private final IQuantity duration;
        private final IType<?> type;

        public LayerEntry(IType<?> type, IQuantity duration) {
            this.type = type;
            this.duration = duration;
        }

        public IQuantity getDuration() {
            return this.duration;
        }

        public IType<?> getType() {
            return this.type;
        }
    }

    public static class LayerBreakdown {
        private final Integer layer;
        private Map<IType<?>, IQuantity> typeToDuration = new HashMap();

        public LayerBreakdown(int layer) {
            this.layer = layer;
        }

        public Integer getLayer() {
            return this.layer;
        }

        public void add(IItem value) {
            IQuantity duration = this.typeToDuration.get(value.getType());
            duration = duration == null ? RulesToolkit.getDuration(value) : duration.add(RulesToolkit.getDuration(value));
            this.typeToDuration.put(value.getType(), duration);
        }

        public List<LayerEntry> getLayerEntries() {
            ArrayList<LayerEntry> list = new ArrayList<LayerEntry>();
            for (Map.Entry<IType<?>, IQuantity> entry : this.typeToDuration.entrySet()) {
                list.add(new LayerEntry(entry.getKey(), entry.getValue()));
            }
            list.sort(ENTRY_COMPARATOR);
            return list;
        }

        public IQuantity getDuration() {
            IQuantity totalDuration = null;
            for (IQuantity duration : this.typeToDuration.values()) {
                if (totalDuration == null) {
                    totalDuration = duration;
                    continue;
                }
                totalDuration = totalDuration.add(duration);
            }
            return totalDuration;
        }

        public String toString() {
            return String.format("LayerBreakdown %d: %s", this.layer, this.typeToDuration.toString());
        }
    }
}

