/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.actions;

import org.eclipse.jface.wizard.IWizard;
import org.openjdk.jmc.flightrecorder.configuration.IRecorderConfigurationService;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.ControlPanel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.FlightRecorderProvider;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards.RecordingWizardModel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards.StartRecordingWizard;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.JVMSupportToolkit;
import org.openjdk.jmc.rjmx.services.jfr.FlightRecorderException;
import org.openjdk.jmc.rjmx.services.jfr.IFlightRecorderService;
import org.openjdk.jmc.ui.common.resource.MCFile;
import org.openjdk.jmc.ui.wizards.AbstractWizardUserAction;

public class StartRecordingAction
extends AbstractWizardUserAction {
    private final FlightRecorderProvider recorder;

    public StartRecordingAction(FlightRecorderProvider recorder) {
        super(Messages.ACTION_START_RECORDING_LABEL, Messages.ACTION_START_RECORDING_TOOLTIP, ControlPanel.getDefault().getMCImageDescriptor("jfr_on.png"));
        this.recorder = recorder;
    }

    public IWizard doCreateWizard() throws Exception {
        IConnectionHandle handle;
        block14: {
            StartRecordingWizard startRecordingWizard;
            block15: {
                Throwable throwable = null;
                Object var2_4 = null;
                handle = this.recorder.getServerHandle().connect(Messages.ACTION_START_RECORDING_LABEL);
                try {
                    IFlightRecorderService flrService = (IFlightRecorderService)handle.getServiceOrNull(IFlightRecorderService.class);
                    if (flrService == null || !JVMSupportToolkit.hasFlightRecorder((IConnectionHandle)handle)) {
                        throw new FlightRecorderException(JVMSupportToolkit.getNoFlightRecorderErrorMessage((IConnectionHandle)handle, (boolean)false));
                    }
                    if (!flrService.isEnabled() && !ControlPanel.askUserForEnable(flrService, Messages.COMMERCIAL_FEATURES_QUESTION)) break block14;
                    MCFile recFile = ControlPanel.getDefaultRecordingFile(this.recorder.getServerHandle());
                    RecordingWizardModel model = new RecordingWizardModel((IRecorderConfigurationService)flrService, recFile);
                    this.recorder.resetWarning();
                    startRecordingWizard = new StartRecordingWizard(model, this.recorder);
                    if (handle == null) break block15;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (handle != null) {
                                handle.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        this.recorder.setWarning(e.getLocalizedMessage());
                        throw e;
                    }
                }
                handle.close();
            }
            return startRecordingWizard;
        }
        if (handle != null) {
            handle.close();
        }
        return null;
    }
}

