/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards;

import java.io.Closeable;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.RecordingProvider;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import org.openjdk.jmc.rjmx.ConnectionException;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.subscription.IMBeanHelperService;
import org.openjdk.jmc.ui.common.resource.MCFile;

public class DumpRecordingWizardModel {
    private final IConnectionHandle m_connection;
    private final RecordingProvider m_recordingProvider;
    private MCFile m_path;
    private IQuantity m_recordingStartTime;

    public DumpRecordingWizardModel(RecordingProvider recording) throws ConnectionException {
        this.m_recordingProvider = recording;
        this.m_path = recording.getDumpToFile();
        this.m_recordingStartTime = recording.getRecordingDescriptor().getStartTime();
        if (this.m_recordingStartTime == null) {
            this.m_recordingStartTime = this.currentServerTime();
        }
        this.m_connection = recording.getServerHandle().connect(NLS.bind((String)Messages.DUMP_RECORDING_CONNECTION, (Object)recording.getName()));
    }

    public IQuantity recordingEndTime() {
        IQuantity endTime = this.m_recordingProvider.getEndTime();
        if (endTime != null && this.recordingIsStopped()) {
            return endTime;
        }
        return this.currentServerTime();
    }

    private boolean recordingIsStopped() {
        return this.m_recordingProvider != null && this.m_recordingProvider.isStopped();
    }

    private IQuantity currentServerTime() {
        IMBeanHelperService service = (IMBeanHelperService)this.m_connection.getServiceOrDummy(IMBeanHelperService.class);
        return UnitLookup.EPOCH_MS.quantity(service.getApproximateServerTime(System.currentTimeMillis()));
    }

    public RecordingProvider getRecordingProvider() {
        return this.m_recordingProvider;
    }

    public MCFile getPath() {
        return this.m_path;
    }

    public IQuantity getRecordingStartTime() {
        return this.m_recordingStartTime;
    }

    public void setPath(MCFile path) {
        this.m_path = path;
    }

    public void dispose() {
        IOToolkit.closeSilently((Closeable)this.m_connection);
    }
}

