/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.common.unit.IConstrainedMap;
import org.openjdk.jmc.common.unit.IDescribedMap;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.configuration.IRecorderConfigurationService;
import org.openjdk.jmc.flightrecorder.configuration.events.EventOptionID;
import org.openjdk.jmc.flightrecorder.configuration.events.IEventConfiguration;
import org.openjdk.jmc.flightrecorder.configuration.events.IEventTypeID;
import org.openjdk.jmc.flightrecorder.configuration.events.SchemaVersion;
import org.openjdk.jmc.flightrecorder.configuration.recording.RecordingOptionsBuilder;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.ControlPanel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.model.ConfigurationRepositoryFactory;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.model.EventConfiguration;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.model.EventConfigurationRepository;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.model.VolatileStorageDelegate;
import org.openjdk.jmc.rjmx.services.jfr.FlightRecorderException;
import org.openjdk.jmc.rjmx.services.jfr.IEventTypeInfo;
import org.openjdk.jmc.rjmx.services.jfr.IFlightRecorderService;
import org.openjdk.jmc.rjmx.services.jfr.IRecordingDescriptor;
import org.openjdk.jmc.ui.common.idesupport.IDESupportToolkit;
import org.openjdk.jmc.ui.common.resource.MCFile;

public class RecordingWizardModel
extends Observable {
    private static final String DEFAULT_SELECTED_TEMPLATE = "Profiling";
    protected static final IQuantity DEFAULT_DURATION = UnitLookup.MINUTE.quantity(1L);
    protected static final IQuantity DEFAULT_DELAY = UnitLookup.SECOND.quantity(0L);
    private static final Pattern NOT_ALLOWED_IN_NAME = Pattern.compile("[=:;,]");
    private static final IQuantity MIN_SIZE = UnitLookup.BYTE.quantity(0L);
    private static final IQuantity MIN_AGE = UnitLookup.SECOND.quantity(0L);
    private static final IQuantity MIN_DELAY = UnitLookup.SECOND.quantity(0L);
    public static final IQuantity MIN_USABLE_DELAY = UnitLookup.SECOND.quantity(1L);
    private static final IQuantity MIN_DURATION = UnitLookup.SECOND.quantity(1L);
    protected static final String JRE_VERSION_CHANGED = "jreVersionChanged";
    private final boolean m_editing;
    private final EventConfigurationRepository m_templateRepository;
    private MCFile m_path;
    private String m_name;
    private boolean m_fixedRecording;
    private String m_durationString = "";
    private String m_delayString = "";
    private String m_maxSizeString = "";
    private String m_maxAgeString = "";
    private final IDescribedMap<String> m_recordingOptions;
    private final IDescribedMap<EventOptionID> m_eventDefaults;
    private final Map<? extends IEventTypeID, ? extends IEventTypeInfo> m_eventTypeInfos;
    private SchemaVersion m_version;
    private final List<IEventConfiguration> m_activeConfigStack = new ArrayList<IEventConfiguration>();

    private RecordingWizardModel(IRecorderConfigurationService configService, boolean editing, MCFile path) {
        this.m_recordingOptions = configService.getDefaultRecordingOptions();
        this.m_version = SchemaVersion.fromBeanVersion((String)configService.getVersion());
        if (this.m_version == null) {
            throw new IllegalArgumentException("Schema version cannot be null");
        }
        if (configService instanceof IFlightRecorderService) {
            Map eventTypeInfos;
            IFlightRecorderService flrService = (IFlightRecorderService)configService;
            try {
                eventTypeInfos = flrService.getEventTypeInfoMapByID();
            }
            catch (FlightRecorderException e) {
                ControlPanel.getDefault().getLogger().log(Level.WARNING, "Could not get initial state from flight recorder", e);
                eventTypeInfos = Collections.emptyMap();
            }
            this.m_eventTypeInfos = eventTypeInfos;
            this.m_templateRepository = this.createRepository(flrService);
        } else {
            this.m_eventTypeInfos = Collections.emptyMap();
            this.m_templateRepository = this.createRepository(this.m_version);
        }
        this.m_eventDefaults = configService.getDefaultEventOptions();
        this.m_editing = editing;
        this.m_path = path;
    }

    public RecordingWizardModel(IRecorderConfigurationService configService, MCFile filename) {
        this(configService, false, filename);
        this.m_name = Messages.RECORDING_DESCRIPTOR_DEFAULT_NAME;
        if (configService instanceof IFlightRecorderService) {
            this.m_name = this.findUniqueName((IFlightRecorderService)configService, this.m_name);
        }
        this.setDelay(DEFAULT_DELAY.interactiveFormat());
        this.setDuration(DEFAULT_DURATION.interactiveFormat());
        this.m_fixedRecording = true;
        this.initActive();
    }

    private void initActive() {
        List<IEventConfiguration> templates = this.m_templateRepository.getTemplates(this.m_version);
        if (!templates.isEmpty()) {
            IEventConfiguration best = templates.get(0);
            for (IEventConfiguration config : templates) {
                if (!DEFAULT_SELECTED_TEMPLATE.equals(config.getName()) || !Messages.VOLATILE_CONFIGURATION_ON_SERVER.equals(config.getLocationInfo())) continue;
                best = config;
                break;
            }
            for (IEventConfiguration config : templates) {
                if (!Messages.VOLATILE_CONFIGURATION_LAST_STARTED.equals(config.getLocationInfo())) continue;
                best = config;
            }
            this.setActiveConfigurationTemplate(best);
        }
    }

    public RecordingWizardModel(IFlightRecorderService flrService, IRecordingDescriptor recordingDescriptor, MCFile filename) {
        this((IRecorderConfigurationService)flrService, true, filename);
        this.setActiveConfigurationTemplate(this.createRunningConfig(flrService, recordingDescriptor));
        this.m_templateRepository.notifyObservers();
        this.m_name = recordingDescriptor.getName();
        this.setDuration(recordingDescriptor.getDuration().interactiveFormat());
        this.setMaxSize(recordingDescriptor.getMaxSize().interactiveFormat());
        this.setMaxAge(recordingDescriptor.getMaxAge().interactiveFormat());
        this.m_fixedRecording = !recordingDescriptor.isContinuous();
    }

    private IEventConfiguration createRunningConfig(IFlightRecorderService flrService, IRecordingDescriptor recordingDescriptor) {
        IEventConfiguration config = EventConfiguration.createEmpty(VolatileStorageDelegate.getRunningRecordingDelegate(), this.m_version);
        try {
            IConstrainedMap settings = flrService.getEventSettings(recordingDescriptor);
            for (EventOptionID key : settings.keySet()) {
                String persisted = settings.getPersistableString((Object)key);
                if (persisted == null) continue;
                config.putPersistedString(key, persisted);
            }
            config.setName(recordingDescriptor.getName());
        }
        catch (FlightRecorderException flightRecorderException) {}
        config.setDescription(Messages.EDIT_RECORDING_WIZARD_RUNNING_CONFIGURATION_DESCRIPTION);
        this.m_templateRepository.add(config);
        return config;
    }

    private EventConfigurationRepository createRepository(IFlightRecorderService flrService) {
        SchemaVersion version = SchemaVersion.fromBeanVersion((String)flrService.getVersion());
        EventConfigurationRepository repo = this.createRepository(version);
        try {
            for (String templateXML : flrService.getServerTemplates()) {
                try {
                    repo.add(new EventConfiguration(EventConfiguration.createModel(templateXML), VolatileStorageDelegate.getOnServerDelegate()));
                }
                catch (ParseException e) {
                    ControlPanel.getDefault().getLogger().log(Level.SEVERE, "Failed to parse template", e);
                }
                catch (IOException e) {
                    ControlPanel.getDefault().getLogger().log(Level.SEVERE, "Failed to load template", e);
                }
            }
        }
        catch (FlightRecorderException e) {
            ControlPanel.getDefault().getLogger().log(Level.SEVERE, "Failed to load server templates", e);
        }
        repo.notifyObservers();
        return repo;
    }

    protected EventConfigurationRepository createRepository(SchemaVersion version) {
        EventConfigurationRepository repo = ConfigurationRepositoryFactory.create();
        repo.setPrototypeTemplate(EventConfiguration.createEmpty(VolatileStorageDelegate.getWorkingCopyDelegate(), version));
        return repo;
    }

    public IDescribedMap<EventOptionID> getEventOptions() {
        return this.m_eventDefaults;
    }

    public Map<? extends IEventTypeID, ? extends IEventTypeInfo> getEventTypeInfoMap() {
        return this.m_eventTypeInfos;
    }

    private String findUniqueName(IFlightRecorderService flrService, String base) {
        boolean hasFoundUniqueName = false;
        String name = base;
        List<IRecordingDescriptor> descriptors = this.getDescriptors(flrService);
        if (descriptors == null) {
            return name;
        }
        int count = 2;
        while (!hasFoundUniqueName) {
            try {
                boolean exists = this.existsRecordingName(descriptors, name);
                if (exists) {
                    name = String.valueOf(base) + ' ' + count++;
                    continue;
                }
                hasFoundUniqueName = true;
            }
            catch (Exception exception) {
                break;
            }
        }
        return name;
    }

    private boolean existsRecordingName(List<IRecordingDescriptor> descriptors, String name) {
        for (IRecordingDescriptor descriptor : descriptors) {
            if (!name.equals(descriptor.getName())) continue;
            return true;
        }
        return false;
    }

    private List<IRecordingDescriptor> getDescriptors(IFlightRecorderService flrService) {
        try {
            return flrService.getAvailableRecordings();
        }
        catch (FlightRecorderException e) {
            ControlPanel.getDefault().getLogger().log(Level.WARNING, "Could not retrieve recording descriptors!", e);
            return null;
        }
    }

    public MCFile getPath() {
        return this.m_path;
    }

    public boolean isFixedRecording() {
        return this.m_fixedRecording;
    }

    public boolean isContinuous() {
        return !this.isFixedRecording();
    }

    public String getDurationString() {
        return this.m_durationString;
    }

    public IQuantity getDuration() throws QuantityConversionException {
        if (this.m_durationString.length() > 0) {
            return this.doGetDuration();
        }
        return null;
    }

    private IQuantity doGetDuration() throws QuantityConversionException {
        ITypedQuantity duration = UnitLookup.TIMESPAN.parseInteractive(this.m_durationString);
        if (duration.compareTo((Object)MIN_DURATION) < 0) {
            throw QuantityConversionException.tooLow((IQuantity)duration, (IQuantity)MIN_DURATION);
        }
        return duration;
    }

    public IQuantity getDelay() throws QuantityConversionException {
        if (this.m_delayString.length() > 0) {
            ITypedQuantity delay = UnitLookup.TIMESPAN.parseInteractive(this.m_delayString);
            if (delay.compareTo((Object)MIN_DELAY) < 0) {
                throw QuantityConversionException.tooLow((IQuantity)delay, (IQuantity)MIN_DELAY);
            }
            if (delay.compareTo((Object)MIN_USABLE_DELAY) < 0) {
                return MIN_DELAY;
            }
            return delay;
        }
        return null;
    }

    public String getDelayString() {
        return this.m_delayString;
    }

    private IQuantity getMaxSize() throws QuantityConversionException {
        if (this.m_maxSizeString.length() > 0) {
            ITypedQuantity size = UnitLookup.MEMORY.parseInteractive(this.m_maxSizeString);
            if (size.compareTo((Object)MIN_SIZE) < 0) {
                throw QuantityConversionException.tooLow((IQuantity)size, (IQuantity)MIN_SIZE);
            }
            return size;
        }
        return null;
    }

    public String getMaxAgeString() {
        return this.m_maxAgeString;
    }

    private IQuantity getMaxAge() throws QuantityConversionException {
        if (this.m_maxAgeString.length() > 0) {
            ITypedQuantity age = UnitLookup.TIMESPAN.parseInteractive(this.m_maxAgeString);
            if (age.compareTo((Object)MIN_AGE) < 0) {
                throw QuantityConversionException.tooLow((IQuantity)age, (IQuantity)MIN_AGE);
            }
            return age;
        }
        return null;
    }

    public String getMaxSizeString() {
        return this.m_maxSizeString;
    }

    public IConstrainedMap<String> buildOptions() throws QuantityConversionException {
        RecordingOptionsBuilder builder = new RecordingOptionsBuilder(this.m_recordingOptions.emptyWithSameConstraints());
        builder.name(this.getName());
        if (this.isFixedRecording()) {
            builder.duration(this.getDuration()).maxSize(0L).maxAge(0L).toDisk(true);
        } else {
            IQuantity maxAge;
            builder.duration(0L);
            IQuantity maxSize = this.getMaxSize();
            if (maxSize != null) {
                builder.maxSize(maxSize).toDisk(true);
            }
            if ((maxAge = this.getMaxAge()) != null) {
                builder.maxAge(maxAge).toDisk(true);
            }
        }
        return builder.build();
    }

    public IEventConfiguration getAndSaveActiveConfiguration() {
        IEventConfiguration config = this.getActiveConfiguration();
        if (config != null) {
            IEventConfiguration lastStarted = config.createWorkingCopy();
            if (this.getName() != null) {
                String name = NLS.bind((String)Messages.RECORDING_WIZARD_LAST_STARTED_SETTINGS_FOR_NAME_MSG, (Object)this.getName());
                lastStarted.setName(name);
            }
            if (this.getPath() != null) {
                String desc = NLS.bind((String)Messages.RECORDING_WIZARD_LAST_STARTED_DESCRIPTION_MSG, (Object)this.getPath().getPath());
                lastStarted.setDescription(desc);
            }
            ConfigurationRepositoryFactory.saveAsLastStarted(lastStarted);
        }
        return config;
    }

    public IConstrainedMap<EventOptionID> getAndSaveEventSettings() {
        IEventConfiguration config = this.getAndSaveActiveConfiguration();
        return config.getEventOptions(this.m_eventDefaults.emptyWithSameConstraints());
    }

    public void setActiveConfigurationTemplate(IEventConfiguration template) {
        this.m_activeConfigStack.clear();
        if (template != null) {
            this.m_activeConfigStack.add(template);
        }
        this.onChange();
    }

    public IEventConfiguration getActiveConfiguration() {
        if (!this.m_activeConfigStack.isEmpty()) {
            return this.m_activeConfigStack.get(this.m_activeConfigStack.size() - 1);
        }
        return null;
    }

    public IEventConfiguration getCurrentConfigurationAt(int wizardStage) {
        if (this.m_activeConfigStack.size() > wizardStage) {
            return this.m_activeConfigStack.get(wizardStage);
        }
        if (this.m_activeConfigStack.isEmpty()) {
            return null;
        }
        if (wizardStage > 0) {
            IEventConfiguration base = this.getCurrentConfigurationAt(wizardStage - 1);
            assert (this.m_activeConfigStack.size() == wizardStage);
            IEventConfiguration derived = base.createWorkingCopy();
            this.m_activeConfigStack.add(derived);
            return derived;
        }
        return null;
    }

    public void flushConfigurationsBeyond(int wizardStage) {
        int maxSize = wizardStage + 1;
        while (this.m_activeConfigStack.size() > maxSize) {
            this.m_activeConfigStack.remove(maxSize);
        }
    }

    public boolean isEditing() {
        return this.m_editing;
    }

    public void setMaxSize(String maxSizeText) {
        this.m_maxSizeString = maxSizeText;
        this.onChange();
    }

    public void setMaxAge(String maxAgeText) {
        this.m_maxAgeString = maxAgeText;
        this.onChange();
    }

    public String getName() {
        return this.m_name;
    }

    public EventConfigurationRepository getTemplateRepository() {
        return this.m_templateRepository;
    }

    public void setPath(MCFile path) {
        this.m_path = path;
        this.onChange();
    }

    public void setName(String name) {
        this.m_name = name;
        this.onChange();
    }

    public void setFixedRecording(boolean fixedRecording) {
        this.m_fixedRecording = fixedRecording;
        this.onChange();
    }

    public void setDuration(String durationText) {
        this.m_durationString = durationText;
        this.onChange();
    }

    public void setDelay(String delayText) {
        this.m_delayString = delayText;
        this.onChange();
    }

    public IDescribedMap<String> getAvailableRecordingOptions() {
        return this.m_recordingOptions;
    }

    protected void onChange() {
        this.setChanged();
        this.notifyObservers();
    }

    protected String checkForErrors(boolean hasExtraTemplate) {
        IStatus validation;
        if (this.m_fixedRecording) {
            try {
                this.getDelay();
            }
            catch (QuantityConversionException e) {
                return NLS.bind((String)Messages.RECORDING_WIZARD_PAGE_DELAY_TIME_ERROR_MSG, (Object)e.getLocalizedMessage());
            }
            try {
                this.doGetDuration();
            }
            catch (QuantityConversionException e) {
                return NLS.bind((String)Messages.RECORDING_WIZARD_PAGE_RECORDING_TIME_ERROR_MSG, (Object)e.getLocalizedMessage());
            }
        }
        if (this.m_name.length() == 0) {
            return Messages.RECORDING_WIZARD_PAGE_RECORDING_NAME_ERROR_MSG;
        }
        if (NOT_ALLOWED_IN_NAME.matcher(this.m_name).find()) {
            return NLS.bind((String)Messages.RECORDING_WIZARD_PAGE_RECORDING_NAME_INVALID_CHARS, (Object)NOT_ALLOWED_IN_NAME);
        }
        if (this.getActiveConfiguration() == null) {
            EventConfigurationRepository repo = this.getTemplateRepository();
            if (repo.isEmpty() && !hasExtraTemplate) {
                return Messages.RECORDING_WIZARD_PAGE_NO_TEMPLATES_IN_MANAGER_ERROR_MSG;
            }
            return Messages.RECORDING_WIZARD_PAGE_NO_TEMPLATE_SELECTED_ERROR_MSG;
        }
        if (!this.m_fixedRecording) {
            try {
                this.getMaxSize();
            }
            catch (QuantityConversionException e) {
                return NLS.bind((String)Messages.RECORDING_WIZARD_PAGE_MAX_SIZE_ERROR_MSG, (Object)e.getLocalizedMessage());
            }
            try {
                this.getMaxAge();
            }
            catch (QuantityConversionException e) {
                return NLS.bind((String)Messages.RECORDING_WIZARD_PAGE_MAX_AGE_ERROR_MSG, (Object)e.getLocalizedMessage());
            }
        }
        if ((validation = IDESupportToolkit.validateFileResourcePath((String)this.m_path.getPath())).getSeverity() == 4) {
            return validation.getMessage();
        }
        return null;
    }

    public String getWarningMessage() {
        IStatus validation = IDESupportToolkit.validateFileResourcePath((String)this.m_path.getPath());
        return ControlPanel.getRecordingFileValidationMessage(validation);
    }

    public final SchemaVersion getVersion() {
        return this.m_version;
    }

    protected void setVersion(SchemaVersion version) {
        this.m_version = version;
    }

    public boolean isCompatibleVersion(IEventConfiguration configuration) {
        return this.m_version.equals((Object)configuration.getVersion());
    }
}

