/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.formpage.commands.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.openjdk.jmc.ui.formpage.commands.internal.IVisitor;

public final class Traverser {
    private static final String GET_DATA_KEY = "name";
    private static final String GET_DATA_METHOD = "getData";
    private static final String GET_TEXT_METHOD = "getText";
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final Class<?>[] ZERO_ARGUMENTS = new Class[0];
    private static final String[] CHILDREN_METHODS = new String[]{"getChildren", "getColumns", "getItems"};

    public static void visit(Object o, IVisitor visitor) {
        if (o != null) {
            for (Object child : Traverser.getSubItems(o)) {
                if (child instanceof Text) {
                    visitor.visit(child, Traverser.quote(Traverser.getText(child)), Traverser.ensureValid(Traverser.getDataName(child)));
                } else {
                    visitor.visit(child, Traverser.quote(Traverser.ensureValid(Traverser.getText(child))), Traverser.ensureValid(Traverser.getDataName(child)));
                }
                Traverser.visit(child, visitor);
            }
        }
    }

    private static String quote(String text) {
        if (text != null) {
            return "\"" + text + "\"";
        }
        return null;
    }

    private static String ensureValid(String text) {
        if (text != null && text.trim().length() == 0) {
            return null;
        }
        return text;
    }

    static List<Object> getSubItems(Object o) {
        ArrayList<Object> children = new ArrayList<Object>();
        if (o != null) {
            String[] stringArray = CHILDREN_METHODS;
            int n = CHILDREN_METHODS.length;
            int n2 = 0;
            while (n2 < n) {
                Object object;
                String childrenMethod = stringArray[n2];
                Method method = Traverser.lookupMethod(o.getClass(), childrenMethod);
                if (method != null && (object = Traverser.invoke(method, o)) != null && object.getClass().isArray()) {
                    Object[] objectArray = (Object[])object;
                    int n3 = objectArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object element = objectArray[n4];
                        children.add(element);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return children;
    }

    private static Object invoke(Method method, Object o) {
        try {
            return method.invoke(o, EMPTY_ARRAY);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Method lookupMethod(Class<?> clazz, String childrenMethod) {
        if ((clazz.equals(Tree.class) || clazz.equals(Table.class)) && childrenMethod.equals("getItems")) {
            return null;
        }
        try {
            return clazz.getMethod(childrenMethod, ZERO_ARGUMENTS);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static String getDataName(Object o) {
        if (o != null) {
            try {
                Method f = o.getClass().getMethod(GET_DATA_METHOD, String.class);
                Object result = f.invoke(o, GET_DATA_KEY);
                if (result instanceof String) {
                    return (String)result;
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    static String getText(Object o) {
        if (o != null) {
            try {
                Object result;
                Method f = o.getClass().getMethod(GET_TEXT_METHOD, new Class[0]);
                if (f != null && (result = f.invoke(o, new Object[0])) instanceof String) {
                    return (String)result;
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

