/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.heap.parser;

import java.io.Closeable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.joverflow.heap.parser.ByteArrayReadBuffer;
import org.openjdk.jmc.joverflow.heap.parser.CachedReadBuffer;
import org.openjdk.jmc.joverflow.heap.parser.FileReadBuffer;
import org.openjdk.jmc.joverflow.heap.parser.MappedReadBuffer;
import org.openjdk.jmc.joverflow.heap.parser.MappedReadMultiBuffer;

public abstract class ReadBuffer {
    public abstract void get(long var1, byte[] var3) throws IOException;

    public abstract void get(long var1, byte[] var3, int var4) throws IOException;

    public abstract int getInt(long var1) throws IOException;

    public abstract long getLong(long var1) throws IOException;

    public abstract void close();

    public static class ByteArrayBufferFactory
    extends Factory {
        private final byte[] fileImageBytes;

        public ByteArrayBufferFactory(byte[] fileImageBytes) {
            this.fileImageBytes = fileImageBytes;
        }

        @Override
        String getFileName() {
            return null;
        }

        @Override
        byte[] getFileImageBytes() {
            return this.fileImageBytes;
        }

        @Override
        public ReadBuffer create(Object supplementalInfo) {
            return new ByteArrayReadBuffer(this.fileImageBytes);
        }
    }

    public static class CachedReadBufferFactory
    extends Factory {
        private final String fileName;
        private final int preferredCacheSize;

        public CachedReadBufferFactory(String fileName, int preferredCacheSize) {
            this.fileName = fileName;
            this.preferredCacheSize = preferredCacheSize;
        }

        @Override
        String getFileName() {
            return this.fileName;
        }

        @Override
        byte[] getFileImageBytes() {
            return null;
        }

        @Override
        public ReadBuffer create(Object supplementalInfo) throws IOException {
            RandomAccessFile file = new RandomAccessFile(this.fileName, "r");
            try {
                return CachedReadBuffer.createInstance(file, this.preferredCacheSize);
            }
            catch (IOException e) {
                IOToolkit.closeSilently((Closeable)file);
                throw e;
            }
        }
    }

    public static abstract class Factory {
        abstract String getFileName();

        abstract byte[] getFileImageBytes();

        public abstract ReadBuffer create(Object var1) throws IOException;
    }

    public static class MmappedBufferFactory
    extends Factory {
        private final String fileName;

        @Override
        String getFileName() {
            return this.fileName;
        }

        @Override
        byte[] getFileImageBytes() {
            return null;
        }

        public MmappedBufferFactory(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public ReadBuffer create(Object supplementalInfo) throws IOException {
            long[] mappedBBEndOfs = (long[])supplementalInfo;
            int maxSingleMappedBufSize = Integer.MAX_VALUE;
            RandomAccessFile file = new RandomAccessFile(this.fileName, "r");
            FileChannel ch = file.getChannel();
            try {
                long size = ch.size();
                if (size <= (long)maxSingleMappedBufSize) {
                    MappedByteBuffer buf = ch.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                    MappedReadBuffer mappedReadBuffer = new MappedReadBuffer(buf);
                    return mappedReadBuffer;
                }
                if (mappedBBEndOfs != null) {
                    MappedByteBuffer[] bufs = new MappedByteBuffer[mappedBBEndOfs.length];
                    long startOfs = 0L;
                    int i = 0;
                    while (i < mappedBBEndOfs.length) {
                        bufs[i] = ch.map(FileChannel.MapMode.READ_ONLY, startOfs, mappedBBEndOfs[i] - startOfs + 1L);
                        startOfs = mappedBBEndOfs[i] + 1L;
                        ++i;
                    }
                    ch.close();
                    file.close();
                    MappedReadMultiBuffer mappedReadMultiBuffer = new MappedReadMultiBuffer(bufs, mappedBBEndOfs, maxSingleMappedBufSize);
                    return mappedReadMultiBuffer;
                }
            }
            finally {
                IOToolkit.closeSilently((Closeable)ch);
                IOToolkit.closeSilently((Closeable)file);
            }
            return new FileReadBuffer(file);
        }
    }
}

