/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.browser.wizards;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.openjdk.jmc.browser.views.BrowserLabelProvider;
import org.openjdk.jmc.browser.wizards.ConnectionWizardModel;
import org.openjdk.jmc.browser.wizards.Messages;
import org.openjdk.jmc.browser.wizards.UserActionContentProvider;
import org.openjdk.jmc.ui.common.action.IUserAction;
import org.openjdk.jmc.ui.common.util.AdapterUtil;
import org.openjdk.jmc.ui.misc.DialogToolkit;
import org.openjdk.jmc.ui.wizards.RelinkableWizardPage;

public class ActionWizardPage
extends RelinkableWizardPage {
    static final String PAGE_NAME = "org.openjdk.jmc.browser.server.connect.action.selection";
    private final ConnectionWizardModel m_serverConnectModel;
    private TableViewer m_serverComponentViewer;
    private Object m_currentSelected;

    protected ActionWizardPage(ConnectionWizardModel serverConnectModel) {
        super(PAGE_NAME, NLS.bind((String)Messages.ServerConnectWizardPage_TOOL_SELECT_DESCRIPTION, (Object)""), null);
        this.m_serverConnectModel = serverConnectModel;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        this.createViewer(container);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        this.m_serverComponentViewer.getControl().setLayoutData((Object)gd);
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.openjdk.jmc.browser.select_action");
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.openjdk.jmc.browser.select_action");
    }

    private void createViewer(Composite container) {
        this.m_serverComponentViewer = new TableViewer(container);
        this.m_serverComponentViewer.setContentProvider((IContentProvider)new UserActionContentProvider());
        this.m_serverComponentViewer.setLabelProvider((IBaseLabelProvider)new BrowserLabelProvider());
        this.m_serverComponentViewer.setInput(null);
        this.m_serverComponentViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ActionWizardPage.this.handleSelection(((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
    }

    protected void showException(Exception e) {
        DialogToolkit.showException((Shell)this.getShell(), (String)Messages.ServerConnectWizardPage_SERVER_COMPONENT_ERROR, (Throwable)e);
    }

    private void handleSelection(Object selected) {
        if (selected == null || !selected.equals(this.m_currentSelected)) {
            this.setNextPage(null);
            this.m_currentSelected = selected;
            if (selected instanceof IUserAction) {
                IUserAction action = (IUserAction)selected;
                this.handleSelectedAction(action);
            }
            this.setPageComplete(selected != null);
        }
    }

    private void handleSelectedAction(IUserAction action) {
        this.m_serverConnectModel.action = action;
        if (!AdapterUtil.hasAdapter((Object)action, IWizard.class)) {
            this.setNextPage(null);
        }
    }

    public IWizardPage getNextPage() {
        try {
            IWizard w = (IWizard)AdapterUtil.getAdapter((Object)this.m_serverConnectModel.action, IWizard.class);
            if (w != null) {
                w.addPages();
                return w.getStartingPage();
            }
        }
        catch (Exception e) {
            this.m_currentSelected = null;
            this.showException(e);
            this.m_serverComponentViewer.refresh();
        }
        return null;
    }

    protected boolean hasNextPage() {
        return AdapterUtil.hasAdapter((Object)this.m_serverConnectModel.action, IWizard.class);
    }

    public boolean isPageComplete() {
        return this.m_serverConnectModel.connectToServer != null && this.m_currentSelected != null && !this.hasNextPage();
    }

    public boolean canFlipToNextPage() {
        return this.m_currentSelected != null && this.hasNextPage();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            Object input = this.createInput();
            if (this.m_serverComponentViewer.getInput() == null || !this.m_serverComponentViewer.getInput().equals(input)) {
                this.m_serverComponentViewer.setInput(input);
            }
            String serverName = this.m_serverConnectModel.connectToServer != null ? this.m_serverConnectModel.connectToServer.getServerHandle().getServerDescriptor().getDisplayName() : "";
            this.setTitle(NLS.bind((String)Messages.ServerConnectWizardPage_TOOL_SELECT_DESCRIPTION, (Object)serverName));
        }
    }

    private Object createInput() {
        if (this.m_serverConnectModel.connectToServer != null) {
            return this.m_serverConnectModel.connectToServer.getActionProvider();
        }
        return null;
    }
}

