/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.attributes;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.CompletableFuture;
import javax.management.Descriptor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IMemento;
import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.TypeHandling;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.services.IAttribute;
import org.openjdk.jmc.rjmx.services.IAttributeChild;
import org.openjdk.jmc.rjmx.services.IReadOnlyAttribute;
import org.openjdk.jmc.rjmx.services.IUpdateInterval;
import org.openjdk.jmc.rjmx.subscription.IMRIMetadata;
import org.openjdk.jmc.rjmx.subscription.IMRIMetadataProvider;
import org.openjdk.jmc.rjmx.subscription.IMRIMetadataService;
import org.openjdk.jmc.rjmx.subscription.IMRITransformationFactory;
import org.openjdk.jmc.rjmx.subscription.MRI;
import org.openjdk.jmc.rjmx.subscription.MRIMetadataToolkit;
import org.openjdk.jmc.rjmx.subscription.MRIValueEvent;
import org.openjdk.jmc.rjmx.subscription.internal.MRITransformationToolkit;
import org.openjdk.jmc.rjmx.ui.attributes.ChangeValueAction;
import org.openjdk.jmc.rjmx.ui.attributes.EditDisplayNameAction;
import org.openjdk.jmc.rjmx.ui.attributes.Messages;
import org.openjdk.jmc.rjmx.ui.attributes.ReadOnlyMRIAttribute;
import org.openjdk.jmc.rjmx.ui.attributes.SetUnitMenuManager;
import org.openjdk.jmc.rjmx.ui.attributes.UpdateIntervalManager;
import org.openjdk.jmc.rjmx.ui.attributes.ValueColumnLabelProvider;
import org.openjdk.jmc.rjmx.ui.attributes.VisualizeAction;
import org.openjdk.jmc.rjmx.ui.internal.InsertArrayElementMenuAction;
import org.openjdk.jmc.rjmx.ui.internal.RemoveArrayElementMenuAction;
import org.openjdk.jmc.rjmx.ui.internal.SectionPartManager;
import org.openjdk.jmc.ui.celleditors.AttributeEditingSupport;
import org.openjdk.jmc.ui.celleditors.UnitCellEditor;
import org.openjdk.jmc.ui.celleditors.UpdateIntervalEditingSupport;
import org.openjdk.jmc.ui.column.ColumnBuilder;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.ActionToolkit;
import org.openjdk.jmc.ui.handlers.InFocusHandlerActivator;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.DisplayToolkit;
import org.openjdk.jmc.ui.misc.MementoToolkit;
import org.openjdk.jmc.ui.misc.OptimisticComparator;
import org.openjdk.jmc.ui.misc.SWTColorToolkit;
import org.openjdk.jmc.ui.misc.TreeStructureContentProvider;
import org.openjdk.jmc.ui.misc.TypedLabelProvider;

public class MRIAttributeInspector {
    private static final int MAX_DESCRIPTORS = 8;
    private static final int TOOLTIP_MAX_LENGTH = 100;
    private static final String NOT_AVAILABLE = String.valueOf('[') + Messages.MRIAttributeInspector_LABEL_NOT_AVAILABLE + ']';
    public static final String MBEANBROWSER_ATTRIBUTESTAB_ATTRIBUTESTREE_NAME = "mbeanbrowser.AttributesTab.AttributesTree";
    private final Observer metadataObserver = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            MRIAttributeInspector.this.viewer.getTree().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!MRIAttributeInspector.this.viewer.getTree().isDisposed()) {
                        MRIAttributeInspector.this.viewer.refresh(true);
                    }
                }
            });
        }
    };
    private final IConnectionHandle connection;
    private final ColumnManager columnManager;
    private final TreeViewer viewer;
    private final MRIAttributeEditingSupport valueEditingSupport;
    private Collection<?> elements = Collections.emptyList();
    private final MCContextMenuManager menu;

    public MRIAttributeInspector(SectionPartManager sectionPartManager, Composite parent, IMemento settings, IConnectionHandle connectionHandle, boolean useOnlyDisplayName, IColumn ... additionalColumns) {
        this.connection = connectionHandle;
        Tree tree = new Tree(parent, 268503810);
        this.viewer = new TreeViewer(tree);
        this.viewer.setContentProvider((IContentProvider)new TreeStructureContentProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        tree.setData("name", (Object)MBEANBROWSER_ATTRIBUTESTAB_ATTRIBUTESTREE_NAME);
        this.valueEditingSupport = new MRIAttributeEditingSupport((ColumnViewer)this.viewer);
        NameLabelProvider nameLabelProvider = new NameLabelProvider(useOnlyDisplayName);
        ValueLabelProvider valueLabelProvider = new ValueLabelProvider();
        ValueAccessor valueAccessor = new ValueAccessor();
        ArrayList<IColumn> columns = new ArrayList<IColumn>();
        columns.add(new ColumnBuilder(Messages.AttributeInspector_NAME_COLUMN_HEADER, "name", (ColumnLabelProvider)nameLabelProvider).comparator((Comparator)new OptimisticComparator((ILabelProvider)nameLabelProvider)).build());
        IColumn valueColumn = new ColumnBuilder(Messages.AttributeInspector_VALUE_COLUMN_HEADER, "value", (IMemberAccessor)valueAccessor).labelProvider((ColumnLabelProvider)valueLabelProvider).editingSupport((EditingSupport)this.valueEditingSupport).comparator((Comparator)new OptimisticComparator((IMemberAccessor)valueAccessor, (ILabelProvider)valueLabelProvider)).build();
        columns.add(valueColumn);
        columns.add(new ColumnBuilder(Messages.AttributeInspector_TYPE_COLUMN_HEADER, "type", (ColumnLabelProvider)new TypeLabelProvider()).build());
        if (!useOnlyDisplayName) {
            columns.add(new ColumnBuilder(Messages.MRIAttributeInspector_DISPLAY_NAME_COLUMN_HEADER, "displayName", (ColumnLabelProvider)new DisplayNameLabelProvider()).build());
        }
        columns.add(new ColumnBuilder(Messages.MRIAttributeInspector_UPDATE_INTERVAL_COLUMN_HEADER, "update", (IMemberAccessor)new UpdateIntervalAccessor()).labelProvider((ColumnLabelProvider)new UpdateIntervalLabelProvider()).editingSupport((EditingSupport)new UpdateIntervalEditingSupportWithRefresh((ColumnViewer)this.viewer)).build());
        columns.add(new ColumnBuilder(Messages.MRIAttributeInspector_DESCRIPTION_COLUMN_HEADER, "description", (ColumnLabelProvider)new DescriptionLabelProvider()).build());
        columns.addAll(Arrays.asList(additionalColumns));
        this.columnManager = ColumnManager.build((TreeViewer)this.viewer, columns, (TableSettings)TableSettings.forState((IState)MementoToolkit.asState((IMemento)settings)));
        this.menu = MCContextMenuManager.create((Control)tree);
        ColumnMenusFactory.addDefaultMenus((ColumnManager)this.columnManager, (MCContextMenuManager)this.menu);
        this.menu.add((IAction)new ChangeValueAction((ColumnViewer)this.viewer, this.columnManager, valueColumn));
        this.menu.add((IContributionItem)InsertArrayElementMenuAction.createInsertArrayElementMenuActionContribution((IMenuManager)this.menu, this.columnManager, valueColumn, false));
        this.menu.add((IContributionItem)InsertArrayElementMenuAction.createInsertArrayElementMenuActionContribution((IMenuManager)this.menu, this.columnManager, valueColumn, true));
        this.menu.add((IContributionItem)RemoveArrayElementMenuAction.createRemoveArrayElementMenuActionContribution((IMenuManager)this.menu, this.columnManager, valueColumn));
        this.menu.add((IContributionItem)new Separator());
        IAction refreshAction = ActionToolkit.commandAction(() -> this.asyncRefresh(true, this.elements), (String)"org.eclipse.ui.file.refresh");
        this.menu.add(refreshAction);
        this.menu.add((IContributionItem)new Separator());
        if (sectionPartManager != null) {
            this.addVisualizeContextMenuActions((IMenuManager)this.menu, sectionPartManager);
            this.menu.add((IContributionItem)new Separator());
        }
        this.menu.add((IContributionItem)new UpdateIntervalManager(this.viewer).getUpdateIntervalMenu());
        this.menu.add((IContributionItem)new SetUnitMenuManager((ISelectionProvider)this.viewer, this.connection, (IMenuManager)this.menu));
        final IMRIMetadataService mds = (IMRIMetadataService)this.connection.getServiceOrDummy(IMRIMetadataService.class);
        this.menu.add((IAction)new EditDisplayNameAction(mds, (ISelectionProvider)this.viewer));
        mds.addObserver(this.metadataObserver);
        tree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                mds.deleteObserver(MRIAttributeInspector.this.metadataObserver);
            }
        });
        InFocusHandlerActivator.install((Control)tree, (IAction)refreshAction);
        this.setupDoubleClickListener();
    }

    public void setInput(Collection<?> elements) {
        this.elements = elements;
        this.viewer.setInput((Object)elements.toArray());
        this.asyncRefresh(true, elements);
    }

    public void saveState(IMemento state) {
        this.columnManager.getSettings().saveState(MementoToolkit.asWritableState((IMemento)state));
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public MenuManager getMenuManager() {
        return this.menu;
    }

    private void setupDoubleClickListener() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object elementNode = selection.getFirstElement();
                MRIAttributeInspector.this.viewer.setExpandedState(elementNode, !MRIAttributeInspector.this.viewer.getExpandedState(elementNode));
            }
        });
    }

    private void addVisualizeContextMenuActions(IMenuManager menuManager, SectionPartManager sectionPartManager) {
        menuManager.add((IAction)new VisualizeAction(Messages.VisualizeAction_VISUALIZE_ATTRIBUTE_TEXT, sectionPartManager, this.connection, (ISelectionProvider)this.viewer));
        IMenuManager transformationMenu = menuManager;
        int count = this.countFactories();
        if (count > 1) {
            transformationMenu = new MenuManager(Messages.VisualizeAction_VISUALIZE_ATTRIBUTE_TRANSFORM_TEXT);
            menuManager.add((IContributionItem)transformationMenu);
        }
        for (IMRITransformationFactory transformationFactory : MRITransformationToolkit.getFactories()) {
            transformationMenu.add((IAction)new VisualizeAction(transformationFactory.getVisualizationLabel(), sectionPartManager, this.connection, (ISelectionProvider)this.viewer, transformationFactory));
        }
    }

    private int countFactories() {
        int count = 0;
        Iterator iter = MRITransformationToolkit.getFactories().iterator();
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        return count;
    }

    private String getDisplayNameText(ReadOnlyMRIAttribute attribute) {
        return MRIMetadataToolkit.getDisplayName((IConnectionHandle)this.connection, (MRI)attribute.getMRI());
    }

    private String getDescriptionText(ReadOnlyMRIAttribute attribute) {
        return MRIMetadataToolkit.getDescription((IConnectionHandle)this.connection, (MRI)attribute.getMRI());
    }

    private static String getTypeText(ReadOnlyMRIAttribute attribute) {
        if (attribute.getInfo().getType() == null) {
            return NOT_AVAILABLE;
        }
        IUnit unit = attribute.getUnit();
        return unit == null ? TypeHandling.simplifyType((String)attribute.getInfo().getType()) : unit.getContentType().getName();
    }

    private static IUnit getUnit(Object attribute) {
        if (attribute instanceof ReadOnlyMRIAttribute) {
            return ((ReadOnlyMRIAttribute)((Object)attribute)).getUnit();
        }
        if (attribute instanceof IAttributeChild) {
            return null;
        }
        return null;
    }

    private void asyncRefresh(boolean fullRefresh, Collection<?> elements) {
        CompletableFuture.runAsync(() -> {
            HashMap<MRI, ReadOnlyMRIAttribute> attributeMap = new HashMap<MRI, ReadOnlyMRIAttribute>();
            for (Object element : elements) {
                ReadOnlyMRIAttribute mriAttribute;
                if (!(element instanceof ReadOnlyMRIAttribute) || (mriAttribute = (ReadOnlyMRIAttribute)((Object)((Object)element))).getMRI().getType() != MRI.Type.ATTRIBUTE) continue;
                attributeMap.put(mriAttribute.getMRI(), mriAttribute);
            }
            ReadOnlyMRIAttribute.refresh(this.connection, attributeMap);
        }).thenRunAsync(() -> {
            if (!this.viewer.getTree().isDisposed()) {
                if (fullRefresh) {
                    this.viewer.refresh();
                } else {
                    this.viewer.update(elements.toArray(), null);
                }
            }
        }, DisplayToolkit.inDisplayThread());
    }

    private static String valueOrNotAvailable(Object value) {
        if (value == null) {
            return NOT_AVAILABLE;
        }
        return String.valueOf(value);
    }

    private class DescriptionLabelProvider
    extends TypedLabelProvider<ReadOnlyMRIAttribute> {
        public DescriptionLabelProvider() {
            super(ReadOnlyMRIAttribute.class);
        }

        protected String getTextTyped(ReadOnlyMRIAttribute element) {
            return MRIAttributeInspector.this.getDescriptionText(element);
        }

        protected String getDefaultText(Object element) {
            if (element instanceof ErroneousAttribute) {
                return String.valueOf(((ErroneousAttribute)element).getDescriptionText());
            }
            return super.getDefaultText(element);
        }
    }

    private class DisplayNameLabelProvider
    extends TypedLabelProvider<IReadOnlyAttribute> {
        public DisplayNameLabelProvider() {
            super(IReadOnlyAttribute.class);
        }

        protected String getTextTyped(IReadOnlyAttribute element) {
            return element instanceof ReadOnlyMRIAttribute ? MRIAttributeInspector.this.getDisplayNameText((ReadOnlyMRIAttribute)element) : element.getInfo().getName();
        }
    }

    public static class ErroneousAttribute {
        private final String errorDescription;
        private final String name;
        private final String type;
        private final String description;

        public ErroneousAttribute(String name, String type, String description) {
            this.name = name;
            this.type = type;
            this.description = description;
            this.errorDescription = name == null ? Messages.MRIAttributeInspector_ATTRIBUTE_NAME_MISSING : (type == null ? Messages.MRIAttributeInspector_ATTRIBUTE_TYPE_MISSING : null);
        }

        public String toString() {
            return this.errorDescription;
        }

        public String getErrorDescription() {
            return this.errorDescription;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getDescriptionText() {
            return this.description != null ? this.description : "";
        }
    }

    private static class MRIAttributeEditingSupport
    extends AttributeEditingSupport<IAttribute> {
        private final UnitCellEditor unitCellEditor;

        public MRIAttributeEditingSupport(ColumnViewer viewer) {
            super(viewer, IAttribute.class);
            this.unitCellEditor = new UnitCellEditor((Composite)viewer.getControl());
        }

        protected CellEditor getCellEditorTyped(IAttribute element) {
            IUnit unit = MRIAttributeInspector.getUnit(element);
            String type = element.getInfo().getType();
            if (unit != null && UnitCellEditor.canEdit((String)type)) {
                this.unitCellEditor.setUnit(unit, type);
                return this.unitCellEditor;
            }
            return super.getCellEditorTyped(element);
        }

        protected boolean canEditTyped(IAttribute element) {
            return element.getValue() != MRIValueEvent.UNAVAILABLE_VALUE && (MRIAttributeInspector.getUnit(element) != null && UnitCellEditor.canEdit((String)element.getInfo().getType()) || super.canEditTyped(element));
        }

        protected void setValueTyped(IAttribute element, Object value) {
            super.setValueTyped(element, value);
            this.getViewer().refresh();
        }
    }

    private class NameLabelProvider
    extends TypedLabelProvider<ReadOnlyMRIAttribute> {
        private static final String COLON_SPACE = ": ";
        private static final String COLON_NL = ":\n";
        private static final String COLON_NL_SPACE = ":\n ";
        private static final String NL_SPACE = "\n ";
        private static final String NL = "\n";
        private static final String ELLIPSIS_STRING = "...";
        private final boolean useOnlyDisplayName;

        public NameLabelProvider(boolean useOnlyDisplayName) {
            super(ReadOnlyMRIAttribute.class);
            this.useOnlyDisplayName = useOnlyDisplayName;
        }

        protected String getDefaultText(Object element) {
            if (element instanceof ReadOnlyMRIAttribute && this.useOnlyDisplayName) {
                return MRIAttributeInspector.this.getDisplayNameText((ReadOnlyMRIAttribute)((Object)element));
            }
            if (element instanceof IReadOnlyAttribute) {
                return ((IReadOnlyAttribute)element).getInfo().getName();
            }
            if (element instanceof ErroneousAttribute) {
                return MRIAttributeInspector.valueOrNotAvailable(((ErroneousAttribute)element).getName());
            }
            return element == null ? "" : element.toString();
        }

        public org.eclipse.swt.graphics.Color getForeground(Object element) {
            if (element instanceof ErroneousAttribute) {
                return JFaceResources.getColorRegistry().get("ERROR_COLOR");
            }
            return null;
        }

        public Font getFont(Object element) {
            if (element instanceof ErroneousAttribute) {
                return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
            }
            if (element instanceof IAttribute) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
            }
            return JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        }

        protected Image getImageTyped(ReadOnlyMRIAttribute element) {
            IMRIMetadata metadata = MRIMetadataToolkit.getMRIMetadata((IConnectionHandle)MRIAttributeInspector.this.connection, (MRI)element.getMRI());
            if (metadata == null) {
                return null;
            }
            Color color = MRIMetadataToolkit.getColor((IMRIMetadataProvider)metadata);
            return color == null ? null : SWTColorToolkit.getColorThumbnail((RGB)SWTColorToolkit.asRGB((Color)color));
        }

        protected Image getToolTipImageTyped(ReadOnlyMRIAttribute element) {
            return this.getImageTyped(element);
        }

        protected org.eclipse.swt.graphics.Color getBackgroundTyped(ReadOnlyMRIAttribute element) {
            Descriptor desc;
            IMRIMetadata metadata = MRIMetadataToolkit.getMRIMetadata((IConnectionHandle)MRIAttributeInspector.this.connection, (MRI)element.getMRI());
            Descriptor descriptor = desc = metadata == null ? null : MRIMetadataToolkit.getDescriptor((IMRIMetadataProvider)metadata);
            if (desc != null && "true".equals(desc.getFieldValue("synthetic"))) {
                return Display.getDefault().getSystemColor(22);
            }
            return null;
        }

        protected String getToolTipTextTyped(ReadOnlyMRIAttribute element) {
            Descriptor desc;
            StringBuilder sb = new StringBuilder();
            if (element.getRefreshProblem() != null) {
                sb.append(Messages.MRIAttributeInspector_ERROR_GETTING_VALUE).append(COLON_NL).append(element.getRefreshProblem()).append(NL).append(NL);
            } else if (element.getInfo().getType() == null) {
                sb.append(Messages.MRIAttributeInspector_ERROR_IN_ATTRIBUTE).append(COLON_NL).append(Messages.MRIAttributeInspector_ATTRIBUTE_TYPE_MISSING).append(NL).append(NL);
            }
            sb.append(Messages.AttributeInspector_NAME_COLUMN_HEADER).append(COLON_SPACE).append(this.shorten(this.getText((Object)element))).append(NL);
            sb.append(Messages.MRIAttributeInspector_DISPLAY_NAME_COLUMN_HEADER).append(COLON_SPACE).append(this.shorten(MRIAttributeInspector.this.getDisplayNameText(element))).append(NL);
            sb.append(Messages.MRIAttributeInspector_DESCRIPTION_COLUMN_HEADER).append(COLON_SPACE).append(this.shorten(MRIAttributeInspector.this.getDescriptionText(element))).append(NL);
            sb.append(Messages.AttributeInspector_VALUE_COLUMN_HEADER).append(COLON_SPACE).append(this.shorten(TypeHandling.getValueString((Object)element.getValue()))).append(NL);
            sb.append(Messages.AttributeInspector_TYPE_COLUMN_HEADER).append(COLON_SPACE).append(this.shorten(TypeHandling.simplifyType((String)element.getInfo().getType()))).append(NL);
            IMRIMetadata metadata = MRIMetadataToolkit.getMRIMetadata((IConnectionHandle)MRIAttributeInspector.this.connection, (MRI)element.getMRI());
            Descriptor descriptor = desc = metadata == null ? null : MRIMetadataToolkit.getDescriptor((IMRIMetadataProvider)metadata);
            if (desc != null && desc.getFields() != null && desc.getFields().length > 0) {
                sb.append(Messages.MRIAttributeInspector_DESCRIPTOR).append(COLON_NL_SPACE);
                String[] fields = desc.getFields();
                int i = 0;
                while (i < Math.min(fields.length, 8)) {
                    sb.append(this.shorten(fields[i])).append(NL_SPACE);
                    ++i;
                }
            }
            return sb.toString().trim();
        }

        public String getToolTipText(Object element) {
            if (element instanceof ErroneousAttribute) {
                ErroneousAttribute attr = (ErroneousAttribute)element;
                StringBuilder sb = new StringBuilder();
                sb.append(Messages.MRIAttributeInspector_ERROR_IN_ATTRIBUTE).append(COLON_NL).append(attr.getErrorDescription()).append(NL).append(NL);
                sb.append(Messages.AttributeInspector_NAME_COLUMN_HEADER).append(COLON_SPACE).append(this.shorten(String.valueOf(attr.getName()))).append(NL);
                sb.append(Messages.MRIAttributeInspector_DESCRIPTION_COLUMN_HEADER).append(COLON_SPACE).append(this.shorten(String.valueOf(attr.getDescriptionText()))).append(NL);
                sb.append(Messages.AttributeInspector_TYPE_COLUMN_HEADER).append(COLON_SPACE).append(this.shorten(String.valueOf(attr.getType()))).append(NL);
                return sb.toString().trim();
            }
            return super.getToolTipText(element);
        }

        private String shorten(String s) {
            if (s.length() > 100) {
                return s.subSequence(0, 100 - ELLIPSIS_STRING.length()) + ELLIPSIS_STRING;
            }
            return s;
        }
    }

    private static class TypeLabelProvider
    extends TypedLabelProvider<IReadOnlyAttribute> {
        public TypeLabelProvider() {
            super(IReadOnlyAttribute.class);
        }

        protected String getTextTyped(IReadOnlyAttribute attribute) {
            if (attribute instanceof ReadOnlyMRIAttribute) {
                return MRIAttributeInspector.getTypeText((ReadOnlyMRIAttribute)attribute);
            }
            return TypeHandling.simplifyType((String)attribute.getInfo().getType());
        }

        protected String getDefaultText(Object element) {
            if (element instanceof ErroneousAttribute) {
                return MRIAttributeInspector.valueOrNotAvailable(((ErroneousAttribute)element).getType());
            }
            return super.getDefaultText(element);
        }

        public org.eclipse.swt.graphics.Color getForeground(Object element) {
            if (this.typeIsNull(element)) {
                return JFaceResources.getColorRegistry().get("ERROR_COLOR");
            }
            return null;
        }

        public Font getFont(Object element) {
            if (this.typeIsNull(element)) {
                return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
            }
            return super.getFont(element);
        }

        public String getToolTipText(Object element) {
            if (this.typeIsNull(element)) {
                return Messages.MRIAttributeInspector_ATTRIBUTE_TYPE_MISSING;
            }
            return super.getToolTipText(element);
        }

        private boolean typeIsNull(Object element) {
            if (element instanceof ErroneousAttribute && ((ErroneousAttribute)element).getType() == null) {
                return true;
            }
            return element instanceof IReadOnlyAttribute && ((IReadOnlyAttribute)element).getInfo().getType() == null;
        }
    }

    private static class UpdateIntervalAccessor
    implements IMemberAccessor<Object, Object> {
        private UpdateIntervalAccessor() {
        }

        public Object getMember(Object o) {
            if (o instanceof IUpdateInterval) {
                return ((IUpdateInterval)o).getUpdateInterval();
            }
            return null;
        }
    }

    private static class UpdateIntervalEditingSupportWithRefresh
    extends UpdateIntervalEditingSupport {
        public UpdateIntervalEditingSupportWithRefresh(ColumnViewer viewer) {
            super(viewer);
        }

        protected void setValue(Object element, Object value) {
            super.setValue(element, value);
            this.getViewer().refresh(element);
        }
    }

    private static class UpdateIntervalLabelProvider
    extends TypedLabelProvider<IUpdateInterval> {
        public UpdateIntervalLabelProvider() {
            super(IUpdateInterval.class);
        }

        protected String getTextTyped(IUpdateInterval paramater) {
            int val = paramater.getUpdateInterval();
            switch (val) {
                case -1: {
                    return Messages.MRIAttributeInspector_UPDATE_INTERVAL_DEFAULT;
                }
                case 0: {
                    return Messages.MRIAttributeInspector_UPDATE_INTERVAL_ONCE;
                }
            }
            return UnitLookup.MILLISECOND.quantity((long)val).displayUsing("auto");
        }
    }

    private static class ValueAccessor
    implements IMemberAccessor<Object, Object> {
        private ValueAccessor() {
        }

        public Object getMember(Object o) {
            if (o instanceof IReadOnlyAttribute) {
                return ValueAccessor.getValue((IReadOnlyAttribute)o);
            }
            return null;
        }

        private static Object getValue(IReadOnlyAttribute a) {
            Object val = a.getValue();
            if (a instanceof ReadOnlyMRIAttribute) {
                IUnit unit = ((ReadOnlyMRIAttribute)a).getUnit();
                if (val instanceof Number && unit != null) {
                    return unit.quantity((Number)val);
                }
            }
            return val;
        }
    }

    private class ValueLabelProvider
    extends ValueColumnLabelProvider {
        private ValueLabelProvider() {
        }

        @Override
        protected org.eclipse.swt.graphics.Color getForegroundTyped(IReadOnlyAttribute attribute) {
            if (attribute.getValue() == MRIValueEvent.UNAVAILABLE_VALUE) {
                return JFaceResources.getColorRegistry().get("ERROR_COLOR");
            }
            return super.getForegroundTyped(attribute);
        }

        protected org.eclipse.swt.graphics.Color getBackgroundTyped(IReadOnlyAttribute element) {
            return MRIAttributeInspector.this.valueEditingSupport.canEdit(element) ? Display.getDefault().getSystemColor(29) : null;
        }

        @Override
        protected boolean isValid(IReadOnlyAttribute attribute) {
            return super.isValid(attribute) && attribute.getValue() != MRIValueEvent.UNAVAILABLE_VALUE;
        }

        @Override
        protected String getToolTipTextTyped(IReadOnlyAttribute attribute) {
            if (attribute instanceof ReadOnlyMRIAttribute && ((ReadOnlyMRIAttribute)attribute).getRefreshProblem() != null) {
                return ((ReadOnlyMRIAttribute)attribute).getRefreshProblem();
            }
            Object val = ValueAccessor.getValue(attribute);
            if (val instanceof IDisplayable) {
                return ((IDisplayable)val).displayUsing("verbose");
            }
            return super.getToolTipTextTyped(attribute);
        }

        @Override
        protected Object getValue(IReadOnlyAttribute attribute) {
            return ValueAccessor.getValue(attribute);
        }
    }
}

