/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.greychart.ui.views;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.function.Consumer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.openjdk.jmc.common.unit.IFormatter;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.TypedUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.greychart.ChartRenderer;
import org.openjdk.jmc.greychart.GreyChart;
import org.openjdk.jmc.greychart.SeriesGreyChart;
import org.openjdk.jmc.greychart.TickDensity;
import org.openjdk.jmc.greychart.TickFormatter;
import org.openjdk.jmc.greychart.XAxis;
import org.openjdk.jmc.greychart.YAxis;
import org.openjdk.jmc.greychart.impl.DefaultXYGreyChart;
import org.openjdk.jmc.greychart.impl.DefaultXYLineRenderer;
import org.openjdk.jmc.greychart.impl.DefaultYAxis;
import org.openjdk.jmc.greychart.impl.EmptyTitleRenderer;
import org.openjdk.jmc.greychart.impl.NanosXAxis;
import org.openjdk.jmc.greychart.impl.OptimizingProvider;
import org.openjdk.jmc.greychart.impl.SamplePoint;
import org.openjdk.jmc.greychart.impl.TimestampFormatter;
import org.openjdk.jmc.greychart.impl.WorldToDeviceConverter;
import org.openjdk.jmc.greychart.ui.messages.internal.Messages;
import org.openjdk.jmc.greychart.ui.views.AntiAliasingListener;
import org.openjdk.jmc.greychart.ui.views.ChartMenuBuilder;
import org.openjdk.jmc.greychart.ui.views.ChartModel;
import org.openjdk.jmc.greychart.ui.views.ChartSampleTooltipProvider;
import org.openjdk.jmc.greychart.ui.views.ExportChartAsImage;
import org.openjdk.jmc.greychart.ui.views.SelectionCanvas;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.accessibility.AccessibilityConstants;
import org.openjdk.jmc.ui.accessibility.FocusTracker;
import org.openjdk.jmc.ui.accessibility.MCAccessibleListener;
import org.openjdk.jmc.ui.common.util.Environment;
import org.openjdk.jmc.ui.common.xydata.DefaultXYData;
import org.openjdk.jmc.ui.common.xydata.ITimestampedData;
import org.openjdk.jmc.ui.common.xydata.IXYData;

public class ChartComposite
extends SelectionCanvas {
    public static final long ONE_SECOND = 1000000000L;
    public static final long ONE_MINUTE = 60000000000L;
    public static final long ONE_HOUR = 3600000000000L;
    public static final long ONE_DAY = 86400000000000L;
    public static final long ONE_WEEK = 604800000000000L;
    private static final long MINIMUM_WORLD_WIDTH = 1000000000L;
    private static final double WORLD_PADDING = 0.05;
    private static final double ZOOM_FACTOR_MENU_OUT = 2.0;
    private static final double ZOOM_FACTOR_MENU_IN = 0.5;
    private static final double ZOOM_FACTOR_WHEEL_OUT = 1.25;
    private static final double ZOOM_FACTOR_WHEEL_IN = 0.8;
    private static final double ZOOM_MIDDLE = 0.5;
    private static final String DRAW_PROPERTY = "org.openjdk.jmc.rjmx.ui.chart.immediatedraw";
    private static final boolean IMMEDIATE_DRAWING;
    private IAction zoomInAction;
    private IAction zoomOutAction;
    private DefaultYAxis yAxis;
    private final ChartModel m_chartModel = new ChartModel();
    private final DefaultXYGreyChart<ITimestampedData> m_chart;
    private long m_viewWidth;
    private long m_viewEnd = System.currentTimeMillis() * 1000L * 1000L;
    private long m_dataStart = Long.MAX_VALUE;
    private long m_dataEnd = Long.MIN_VALUE;
    private boolean m_enableUpdates;
    private final Consumer<Boolean> m_enableUpdatesCallback;
    private ChartSampleTooltipProvider m_cstp = null;
    private Rectangle m_plotBounds;

    static {
        boolean drawImmediately = System.getProperty(DRAW_PROPERTY) != null ? Boolean.getBoolean(DRAW_PROPERTY) : Environment.getOSType() == Environment.OSType.MAC;
        IMMEDIATE_DRAWING = drawImmediately;
    }

    public ChartComposite(Composite parent, int style, Consumer<Boolean> enableUpdatesCallback) {
        super(parent);
        this.m_chart = this.createChart();
        this.m_enableUpdatesCallback = enableUpdatesCallback;
        this.setupAntiAliasingListener();
        this.setupObservers();
        MenuManager popupMenu = this.createContextMenu();
        this.setMenu(popupMenu.createContextMenu((Control)this));
        this.setupAccessibility();
        this.setupMouseTracker();
        this.updateXAxis();
        this.updateYAxis();
        this.setupMouseWheelListener();
        this.yAxis.setTickDensity(TickDensity.NORMAL);
    }

    public void refresh() {
        if (!this.isDisposed()) {
            this.zoomInAction.setEnabled(this.m_viewWidth > 1000000000L && !this.m_enableUpdates);
            ((NanosXAxis)this.getChart().getXAxis()).setRange((Number)(this.m_viewEnd - this.m_viewWidth), (Number)this.m_viewEnd);
            this.m_chart.setXAxis(this.m_chart.getXAxis());
            this.redraw();
        }
    }

    private NanosXAxis getXAxis() {
        return (NanosXAxis)this.getChart().getXAxis();
    }

    private void setupMouseWheelListener() {
        this.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                if (!ChartComposite.this.m_enableUpdates) {
                    Rectangle bounds = ChartComposite.this.getXAxis().getRenderedBounds();
                    int x = Math.max(ChartComposite.this.translateDisplayToImageXCoordinate(event.x) - bounds.x, 0);
                    x = Math.min(x, bounds.width);
                    double location = (double)x / (double)bounds.width;
                    if (event.count < 0) {
                        ChartComposite.this.zoom(1.25, location);
                    } else if (event.count > 0 && ChartComposite.this.zoomInAction.isEnabled()) {
                        ChartComposite.this.zoom(0.8, location);
                    }
                }
            }
        });
    }

    private void setupAntiAliasingListener() {
        final AntiAliasingListener antialiasingListener = new AntiAliasingListener((GreyChart)this.m_chart);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)antialiasingListener);
            }
        });
        UIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)antialiasingListener);
    }

    private void setupAccessibility() {
        FocusTracker.enableFocusTracking((Composite)this);
        final MCAccessibleListener accessabilityListener = new MCAccessibleListener();
        accessabilityListener.setComponentType(AccessibilityConstants.COMPONENT_TYPE_GRAPH);
        this.getAccessible().addAccessibleListener((AccessibleListener)accessabilityListener);
        this.m_chartModel.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                accessabilityListener.setName(ChartComposite.this.m_chartModel.getChartTitle());
            }
        });
    }

    private void setupMouseTracker() {
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                Rectangle plotArea = ChartComposite.this.m_plotBounds;
                if (!ChartComposite.this.m_enableUpdates && plotArea != null) {
                    org.eclipse.swt.graphics.Rectangle clientArea = ChartComposite.this.getClientArea();
                    int topMargin = plotArea.x + clientArea.x;
                    int leftMargin = plotArea.y + clientArea.y;
                    Point translated = ChartComposite.this.translateDisplayToImageCoordinates(e.x, e.y);
                    Point mousePoint = new Point(translated.x - topMargin, translated.y - leftMargin);
                    SamplePoint closestSample = null;
                    OptimizingProvider closestProvider = null;
                    long distance = Long.MAX_VALUE;
                    if (ChartComposite.this.getChart().getOptimizingProvider() != null) {
                        OptimizingProvider[] optimizingProviderArray = ChartComposite.this.getChart().getOptimizingProvider().getChildren();
                        int n = optimizingProviderArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Iterator samples;
                            OptimizingProvider provider = optimizingProviderArray[n2];
                            WorldToDeviceConverter yConverter = provider.getYSampleToDeviceConverterFor((YAxis)ChartComposite.this.yAxis);
                            SamplePoint data = ChartComposite.getClosestPoint(yConverter, mousePoint, samples = provider.getSamples(plotArea.width));
                            if (data != null) {
                                long newDistance = ChartComposite.getSquaredDistance(yConverter, data, mousePoint);
                                if (closestSample == null || newDistance < distance) {
                                    closestSample = data;
                                    closestProvider = provider;
                                    distance = newDistance;
                                    if (distance == 0L) break;
                                }
                            }
                            ++n2;
                        }
                    }
                    if (closestSample != null && closestProvider != null && ChartComposite.this.m_cstp != null) {
                        WorldToDeviceConverter yConverter = closestProvider.getYSampleToDeviceConverterFor((YAxis)ChartComposite.this.yAxis);
                        DefaultXYData xyData = new DefaultXYData((Object)closestSample.x, (Object)yConverter.getDeviceCoordinate(closestSample.y));
                        ChartComposite.this.getChart().getPlotRenderer().circleValue((IXYData)xyData);
                        ChartComposite.this.setToolTipText(ChartComposite.this.m_cstp.getTooltip(closestProvider.getDataSeries(), closestSample.y));
                        ChartComposite.this.redraw();
                    }
                } else {
                    ChartComposite.this.clearCircledValue();
                }
            }

            public void mouseExit(MouseEvent e) {
                ChartComposite.this.clearCircledValue();
            }
        });
    }

    public void setChartSampleTooltipProvider(ChartSampleTooltipProvider cstp) {
        this.m_cstp = cstp;
    }

    private DefaultXYGreyChart<ITimestampedData> createChart() {
        DefaultXYGreyChart chart = new DefaultXYGreyChart();
        chart.setTitleRenderer((ChartRenderer)new EmptyTitleRenderer((GreyChart)chart, 10));
        chart.setIndexRenderer(null);
        chart.setAntialiasingEnabled(AntiAliasingListener.isUsingAntialiasing());
        chart.setAutoUpdateOnAxisChange(false);
        DefaultXYLineRenderer plotRenderer = chart.getPlotRenderer();
        plotRenderer.setUseClip(false);
        plotRenderer.setDrawOnXAxis(true);
        plotRenderer.setExtrapolateMissingData(false);
        NanosXAxis d = new NanosXAxis((SeriesGreyChart)chart);
        d.setFormatter((TickFormatter)TimestampFormatter.createNanoTimestampFormatter());
        chart.setXAxis((XAxis)d);
        chart.getXAxis().setTitle(Messages.ChartComposite_X_AXIS_TITLE);
        this.yAxis = new DefaultYAxis(chart);
        this.yAxis.setPosition(YAxis.Position.LEFT);
        chart.addYAxis((YAxis)this.yAxis);
        return chart;
    }

    private void updateXAxis() {
        NanosXAxis xAxis = (NanosXAxis)this.getChart().getXAxis();
        xAxis.setTitle(this.getChartModel().getXAxis().getTitle());
        this.redraw();
    }

    private void updateYAxis() {
        ChartModel.RangedAxis axisModel = this.getChartModel().getYAxis();
        DefaultYAxis yAxisLeft = this.getFirstLeftAxis();
        yAxisLeft.setTitle(axisModel.getTitle());
        KindOfQuantity<?> kindOfQuantity = axisModel.getKindOfQuantity();
        if (kindOfQuantity == UnitLookup.MEMORY) {
            yAxisLeft.setContentType("bytes");
        } else {
            yAxisLeft.setContentType("unknown");
        }
        yAxisLeft.setFormatter((TickFormatter)new QuantityFormatter(kindOfQuantity));
        switch (axisModel.getRangeType()) {
            case AUTO: {
                yAxisLeft.setAutoRangeEnabled(true);
                yAxisLeft.setAlwaysShowZero(false);
                yAxisLeft.setAutoPadding(0.2);
                break;
            }
            case AUTO_ZERO: {
                yAxisLeft.setAutoRangeEnabled(true);
                yAxisLeft.setAlwaysShowZero(true);
                yAxisLeft.setAutoPadding(0.2);
                break;
            }
            case CUSTOM: {
                yAxisLeft.setAutoRangeEnabled(false);
                yAxisLeft.setAlwaysShowZero(false);
                TypedUnit outUnit = axisModel.getKindOfQuantity().getDefaultUnit();
                yAxisLeft.setRange((Number)axisModel.getMinValue().doubleValueIn((IUnit)outUnit), (Number)axisModel.getMaxValue().doubleValueIn((IUnit)outUnit));
                yAxisLeft.setAutoPadding(0.0);
            }
        }
        this.redraw();
    }

    private DefaultYAxis getFirstLeftAxis() {
        YAxis[] yAxis;
        YAxis[] yAxisArray = yAxis = this.getChart().getYAxis();
        int n = yAxis.length;
        int n2 = 0;
        while (n2 < n) {
            YAxis y = yAxisArray[n2];
            if (((DefaultYAxis)y).getPosition() == YAxis.Position.LEFT) {
                return (DefaultYAxis)y;
            }
            ++n2;
        }
        return (DefaultYAxis)yAxis[0];
    }

    private void setupObservers() {
        this.getChartModel().getXAxis().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                ChartComposite.this.updateXAxis();
            }
        });
        this.getChartModel().getYAxis().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                ChartComposite.this.updateYAxis();
            }
        });
    }

    public ChartModel getChartModel() {
        return this.m_chartModel;
    }

    private void clearCircledValue() {
        this.getChart().getPlotRenderer().circleValue(null);
        this.setToolTipText(null);
        this.redraw();
    }

    public DefaultXYGreyChart<ITimestampedData> getChart() {
        return this.m_chart;
    }

    private static SamplePoint getClosestPoint(WorldToDeviceConverter yConverter, Point mousePoint, Iterator<SamplePoint> s) {
        SamplePoint result = null;
        long distance = Long.MAX_VALUE;
        Iterator<SamplePoint> iter = s;
        while (iter.hasNext()) {
            SamplePoint data = iter.next();
            long tmpDist = ChartComposite.getSquaredDistance(yConverter, data, mousePoint);
            if (tmpDist >= distance) continue;
            distance = tmpDist;
            result = data;
        }
        return result;
    }

    private static long getSquaredDistance(WorldToDeviceConverter yConverter, SamplePoint data, Point mousePoint) {
        long xdiff = data.x - mousePoint.x;
        long ydiff = yConverter.getDeviceCoordinate(data.y) - mousePoint.y;
        return xdiff * xdiff + ydiff * ydiff;
    }

    private MenuManager createContextMenu() {
        MenuManager popupMenu = new MenuManager();
        popupMenu.add(ChartMenuBuilder.createShowMenu(this));
        popupMenu.add(ChartMenuBuilder.createRangeMenu(this.m_chartModel));
        popupMenu.add(ChartMenuBuilder.createLabelDensityMenu(this.yAxis));
        popupMenu.add(ChartMenuBuilder.createRenderingModeMenu(this.m_chartModel));
        popupMenu.add(ChartMenuBuilder.createTitleMenu(this.m_chartModel));
        this.zoomInAction = new Action(Messages.ChartComposite_MENU_ZOOM_IN_TEXT){

            public void run() {
                ChartComposite.this.zoom(0.5, 0.5);
            }
        };
        this.zoomOutAction = new Action(Messages.ChartComposite_MENU_ZOOM_OUT_TEXT){

            public void run() {
                ChartComposite.this.zoom(2.0, 0.5);
            }
        };
        popupMenu.add(this.zoomInAction);
        popupMenu.add(this.zoomOutAction);
        popupMenu.add((IAction)new ExportChartAsImage((GreyChart)this.m_chart));
        return popupMenu;
    }

    public void showLast(long viewWidth) {
        this.m_viewWidth = viewWidth;
        if (this.m_enableUpdatesCallback != null) {
            this.m_enableUpdatesCallback.accept(true);
        }
        if (this.m_dataEnd > 0L) {
            this.m_viewEnd = this.m_dataEnd;
        }
        this.refresh();
    }

    public void showAll() {
        this.m_viewWidth = this.m_dataEnd - this.m_dataStart;
        this.m_viewEnd = this.m_dataEnd;
        this.refresh();
    }

    public void extendsDataRangeToInclude(long timestamp) {
        this.setDataRange(Math.min(this.m_dataStart, timestamp), Math.max(this.m_dataEnd, timestamp));
    }

    public void setDataRange(long dataStart, long dataEnd) {
        if (dataEnd > 0L && (this.m_enableUpdates || this.m_dataEnd < 0L)) {
            this.m_viewEnd = dataEnd;
        }
        this.m_dataStart = dataStart;
        this.m_dataEnd = dataEnd;
        this.refresh();
    }

    public void setUpdatesEnabled(boolean enabled) {
        this.m_enableUpdates = enabled;
        this.zoomInAction.setEnabled(!enabled);
        this.zoomOutAction.setEnabled(!enabled);
        if (this.m_enableUpdates && this.m_dataEnd > 0L) {
            this.m_viewEnd = this.m_dataEnd;
            this.refresh();
        }
    }

    private void zoom(double factor, double location) {
        if (this.m_dataEnd > this.m_dataStart) {
            double padding = (double)this.m_viewWidth * 0.05;
            long worldStart = this.m_viewEnd - this.m_viewWidth;
            double zoomPoint = (double)worldStart + (double)this.m_viewWidth * location;
            double newWorldEnd = zoomPoint + ((double)this.m_viewEnd - zoomPoint) * factor;
            double newWorldStart = zoomPoint - (zoomPoint - (double)worldStart) * factor;
            this.m_viewEnd = (long)Math.min(Math.max((double)this.m_viewEnd, (double)this.m_dataEnd + padding), newWorldEnd);
            newWorldStart = Math.max(Math.min((double)worldStart, (double)this.m_dataStart - padding), newWorldStart);
            this.m_viewWidth = (long)((double)this.m_viewEnd - newWorldStart);
            this.refresh();
        }
    }

    @Override
    protected Rectangle render(Graphics2D ctx, Rectangle where) {
        this.m_chart.render(ctx, where);
        this.m_plotBounds = this.m_chart.getPlotRenderer().getRenderedBounds();
        return this.m_plotBounds;
    }

    @Override
    protected void selectionStart() {
        if (this.m_enableUpdatesCallback != null) {
            this.m_enableUpdatesCallback.accept(false);
        }
    }

    @Override
    protected void selectionComplete(double start, double end) {
        this.m_viewEnd -= (long)((1.0 - end) * (double)this.m_viewWidth);
        this.m_viewWidth = (long)((double)this.m_viewWidth * (end - start));
        this.refresh();
    }

    private static class QuantityFormatter
    implements TickFormatter {
        private final IUnit outUnit;
        private final IFormatter<IQuantity> formatter;

        private QuantityFormatter(KindOfQuantity<?> kindOfQuantity) {
            this.outUnit = kindOfQuantity.getDefaultUnit();
            this.formatter = kindOfQuantity.getDefaultFormatter();
        }

        public String getUnitString(Number min, Number max) {
            return "";
        }

        public String format(Number value, Number min, Number max, Number labelDistance) {
            return this.formatter.format((Object)this.outUnit.quantity(value));
        }
    }
}

