/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.tabs.memory;

import java.util.logging.Level;
import javax.inject.Inject;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.openjdk.jmc.console.ui.ConsolePlugin;
import org.openjdk.jmc.console.ui.editor.IConsolePageContainer;
import org.openjdk.jmc.console.ui.editor.IConsolePageStateHandler;
import org.openjdk.jmc.console.ui.editor.internal.ConsoleEditor;
import org.openjdk.jmc.console.ui.editor.internal.ConsoleFormPage;
import org.openjdk.jmc.console.ui.messages.internal.Messages;
import org.openjdk.jmc.console.ui.tabs.memory.GcTableSectionPart;
import org.openjdk.jmc.console.ui.tabs.memory.HeapHistogram;
import org.openjdk.jmc.console.ui.tabs.memory.MemoryPoolModel;
import org.openjdk.jmc.console.ui.tabs.memory.MemoryPoolTableSectionPart;
import org.openjdk.jmc.rjmx.ConnectionToolkit;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.services.IDiagnosticCommandService;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.misc.DialogToolkit;
import org.openjdk.jmc.ui.misc.MCActionContributionItem;
import org.openjdk.jmc.ui.misc.MCLayoutFactory;

public class MemoryTab
implements IConsolePageStateHandler {
    private static final String HEAP_HISTOGRAM_ID = "heapHistogram";
    private static final String GC_TABLE_ID = "gcTable";
    private static final String MEMORY_POOL_ID = "memoryPool";
    private HeapHistogram histogram;
    private GcTableSectionPart gcTableSectionPart;
    private MemoryPoolTableSectionPart poolTable;

    @Inject
    protected void createPageContent(IConsolePageContainer page, IManagedForm managedForm, IConnectionHandle handle) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        Composite container = managedForm.getForm().getBody();
        container.setLayout(MCLayoutFactory.createFormPageLayout());
        form.getToolBarManager().appendToGroup("first", (IContributionItem)new MCActionContributionItem((IAction)new GCAction(handle, ((ConsoleFormPage)page).getEditorSite().getShell())));
        form.getToolBarManager().update(true);
        IMemento currentState = page.loadConfig();
        this.histogram = HeapHistogram.create(container, toolkit, handle, currentState.getChild(HEAP_HISTOGRAM_ID));
        if (this.histogram != null) {
            managedForm.addPart((IFormPart)this.histogram);
            MCLayoutFactory.addGrabOnExpandLayoutData((Section)this.histogram.getSection());
        }
        this.gcTableSectionPart = new GcTableSectionPart(((ConsoleEditor)page.getEditor()).getSectionPartManagers().get(0), container, toolkit, handle, currentState.getChild(GC_TABLE_ID));
        managedForm.addPart((IFormPart)this.gcTableSectionPart);
        MCLayoutFactory.addGrabOnExpandLayoutData((Section)this.gcTableSectionPart.getSection());
        this.poolTable = new MemoryPoolTableSectionPart(container, toolkit, new MemoryPoolModel(handle), currentState.getChild(MEMORY_POOL_ID));
        managedForm.addPart((IFormPart)this.poolTable);
        MCLayoutFactory.addGrabOnExpandLayoutData((Section)this.poolTable.getSection());
        this.validateDependencies(page, handle);
    }

    private void validateDependencies(IConsolePageContainer page, IConnectionHandle connectionHandle) {
        MBeanServerConnection connection = (MBeanServerConnection)connectionHandle.getServiceOrNull(MBeanServerConnection.class);
        try {
            if (connection.queryNames(new ObjectName("java.lang:type=GarbageCollector,*"), null).isEmpty() || connection.queryNames(new ObjectName("java.lang:type=MemoryPool,*"), null).isEmpty()) {
                page.presentError(Messages.ConsoleEditor_PLATFORM_MBEANS_UNAVAILABLE);
            } else if (connectionHandle.getServiceOrNull(IDiagnosticCommandService.class) == null) {
                page.presentError(Messages.ConsoleEditor_DIAGNOSTIC_COMMANDS_UNAVAILABLE);
            }
        }
        catch (Exception exception) {
            page.presentError(Messages.ConsoleEditor_CONNECTION_LOST);
        }
    }

    @Override
    public boolean saveState(IMemento state) {
        if (this.histogram != null) {
            this.histogram.saveState(state.createChild(HEAP_HISTOGRAM_ID));
        }
        this.gcTableSectionPart.saveState(state.createChild(GC_TABLE_ID));
        this.poolTable.saveState(state.createChild(MEMORY_POOL_ID));
        return true;
    }

    @Override
    public void dispose() {
    }

    private static class GCAction
    extends Action {
        private final IConnectionHandle handle;
        private final Shell messageShell;

        public GCAction(IConnectionHandle connection, Shell shell) {
            super(null, 1);
            this.setText(Messages.MemoryTab_RUN_GC_ACTION_DESCRIPTION_TEXT);
            this.setToolTipText(Messages.MemoryTab_RUN_GC_ACTION_DESCRIPTION_TEXT);
            this.setImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("trash.png"));
            this.setId("gc");
            this.handle = connection;
            this.messageShell = shell;
        }

        public void run() {
            try {
                ConnectionToolkit.getMemoryBean((MBeanServerConnection)((MBeanServerConnection)this.handle.getServiceOrThrow(MBeanServerConnection.class))).gc();
            }
            catch (Exception o) {
                ConsolePlugin.getDefault().getLogger().log(Level.SEVERE, Messages.MemoryTab_TITLE_COULD_NOT_RUN_GC, o);
                DialogToolkit.showException((Shell)this.messageShell, (String)Messages.MemoryTab_TITLE_COULD_NOT_RUN_GC, (Throwable)o);
            }
        }
    }
}

