/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.subscription.IMRIMetadataService;
import org.openjdk.jmc.rjmx.subscription.IMRIService;
import org.openjdk.jmc.rjmx.subscription.IMRIValueListener;
import org.openjdk.jmc.rjmx.subscription.ISubscriptionService;
import org.openjdk.jmc.rjmx.subscription.MRI;
import org.openjdk.jmc.rjmx.subscription.MRIValueEvent;
import org.openjdk.jmc.rjmx.ui.attributes.MRIAttribute;
import org.openjdk.jmc.rjmx.ui.attributes.MRIAttributeInspector;
import org.openjdk.jmc.rjmx.ui.attributes.ReadOnlyMRIAttribute;
import org.openjdk.jmc.rjmx.ui.internal.AddAttibutesAction;
import org.openjdk.jmc.rjmx.ui.internal.IAttributeSet;
import org.openjdk.jmc.rjmx.ui.internal.Messages;
import org.openjdk.jmc.rjmx.ui.internal.RemoveAttributeAction;
import org.openjdk.jmc.rjmx.ui.internal.SectionPartManager;
import org.openjdk.jmc.ui.column.ColumnBuilder;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.handlers.InFocusHandlerActivator;
import org.openjdk.jmc.ui.misc.DisplayToolkit;
import org.openjdk.jmc.ui.misc.MCLayoutFactory;
import org.openjdk.jmc.ui.misc.MCSectionPart;
import org.openjdk.jmc.ui.misc.TypedLabelProvider;

public class AttributeSectionPart
extends MCSectionPart
implements IAttributeSet {
    private static final String ATTRIBUTE_ID = "attribute";
    private MRIAttributeInspector inspector;
    private final IConnectionHandle connection;
    private final Map<MRI, ReadOnlyMRIAttribute> model = new HashMap<MRI, ReadOnlyMRIAttribute>();
    private final IMRIValueListener listener = new IMRIValueListener(){

        public void valueChanged(final MRIValueEvent event) {
            DisplayToolkit.safeAsyncExec((Widget)AttributeSectionPart.this.getSection(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    ReadOnlyMRIAttribute attribute;
                    if (!AttributeSectionPart.this.inspector.getViewer().getControl().isDisposed() && (attribute = (ReadOnlyMRIAttribute)((Object)AttributeSectionPart.this.model.get(event.getMRI()))) != null) {
                        attribute.updateValue(event.getValue());
                        AttributeSectionPart.this.inspector.getViewer().update((Object)attribute, null);
                    }
                }
            });
        }
    };

    public AttributeSectionPart(SectionPartManager sectionPartManager, Composite parent, FormToolkit toolkit, String title, IConnectionHandle connection, IMemento settings) {
        super(parent, toolkit, title);
        this.connection = connection;
        Composite body = this.createSectionBody(MCLayoutFactory.createMarginFreeFormPageLayout());
        IColumn objectNameColumn = new ColumnBuilder(Messages.AttributeSectionPart_OBJECT_NAME_COLUMN_HEADER, "objectName", (ColumnLabelProvider)new TypedLabelProvider<ReadOnlyMRIAttribute>(ReadOnlyMRIAttribute.class){

            protected String getTextTyped(ReadOnlyMRIAttribute element) {
                return element.getMRI().getObjectName().getCanonicalName();
            }
        }).build();
        this.inspector = new MRIAttributeInspector(sectionPartManager, body, settings, connection, true, objectNameColumn);
        this.getMCToolBarManager().add((IAction)new AddAttibutesAction((IMRIMetadataService)connection.getServiceOrDummy(IMRIMetadataService.class), (IMRIService)connection.getServiceOrDummy(IMRIService.class), this, false), 0);
        TreeViewer tree = this.inspector.getViewer();
        tree.getTree().setLayoutData(MCLayoutFactory.createFormPageLayoutData());
        RemoveAttributeAction removeAction = new RemoveAttributeAction((StructuredViewer)tree, this);
        this.inspector.getMenuManager().appendToGroup("group.edit", (IAction)removeAction);
        InFocusHandlerActivator.install((Control)tree.getControl(), (IAction)removeAction);
        if (settings != null) {
            this.restoreState(settings);
        }
    }

    @Override
    public void add(MRI ... mris) {
        MRI[] mRIArray = mris;
        int n = mris.length;
        int n2 = 0;
        while (n2 < n) {
            MRI mri = mRIArray[n2];
            if (!this.model.containsKey(mri)) {
                this.model.put(mri, MRIAttribute.create(this.connection, mri));
                ((ISubscriptionService)this.connection.getServiceOrDummy(ISubscriptionService.class)).addMRIValueListener(mri, this.listener);
            }
            ++n2;
        }
        this.inspector.setInput(this.model.values());
    }

    @Override
    public void remove(MRI ... mris) {
        MRI[] mRIArray = mris;
        int n = mris.length;
        int n2 = 0;
        while (n2 < n) {
            MRI mri = mRIArray[n2];
            this.model.remove(mri);
            ((ISubscriptionService)this.connection.getServiceOrDummy(ISubscriptionService.class)).removeMRIValueListener(mri, this.listener);
            ++n2;
        }
        this.inspector.setInput(this.model.values());
    }

    public void saveState(IMemento state) {
        this.inspector.saveState(state);
        for (MRI mri : this.model.keySet()) {
            state.createChild(ATTRIBUTE_ID).putTextData(mri.getQualifiedName());
        }
    }

    public void restoreState(IMemento state) {
        this.model.clear();
        IMemento[] iMementoArray = state.getChildren(ATTRIBUTE_ID);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            this.add(MRI.createFromQualifiedName((String)child.getTextData().trim()));
            ++n2;
        }
    }

    public boolean isEmpty() {
        return false;
    }

    public MRI[] elements() {
        return this.model.keySet().toArray(new MRI[this.model.keySet().size()]);
    }
}

