/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.services.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.openjdk.jmc.rjmx.ConnectionToolkit;

public class CommercialFeaturesServiceUtil {
    private static final Logger LOGGER = Logger.getLogger("CommercialFeaturesServiceUtil");
    private static final String JDK_MANAGEMENT_JFR_MBEAN_NAME = "jdk.management.jfr:type=FlightRecorder";

    public static boolean isJfrMBeanAvailable(MBeanServerConnection server) {
        try {
            CommercialFeaturesServiceUtil.getJfrMBeanObjectName(server);
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Got exception while fetching MBean information.", e);
            return false;
        }
    }

    public static ObjectName getJfrMBeanObjectName(MBeanServerConnection server) throws Exception {
        ObjectName candidateObjectName = ConnectionToolkit.createObjectName(JDK_MANAGEMENT_JFR_MBEAN_NAME);
        server.getMBeanInfo(candidateObjectName);
        return candidateObjectName;
    }
}

