/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.exceptions;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCPackage;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class LuceneVersionRule
implements IRule {
    private static final String RESULT_ID = "LuceneVersion";
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.JavaErrorThrow", RulesToolkit.EventAvailability.ENABLED).addEventType("jdk.JavaExceptionThrow", RulesToolkit.EventAvailability.ENABLED).build();
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE);
    private static final String LOOKAHEAD_SUCCESS_NAME = "org.apache.lucene.queryparser.classic.QueryParser$LookaheadSuccess";

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        return new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return LuceneVersionRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
    }

    private IResult getResult(IItemCollection items, IPreferenceValueProvider vp, IResultValueProvider rp) {
        IItemCollection throwables = items.apply(JdkFilters.THROWABLES).apply(ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.EXCEPTION_THROWNCLASS_NAME, (Object)LOOKAHEAD_SUCCESS_NAME));
        IQuantity lookaheadSuccessErrors = (IQuantity)throwables.getAggregate(Aggregators.count());
        LuceneConsumer consumerType = this.isElasticSearch(throwables);
        if (lookaheadSuccessErrors.longValue() > 1L) {
            double score = RulesToolkit.mapExp100((double)lookaheadSuccessErrors.longValue(), (double)2.0, (double)20.0);
            ResultBuilder builder = ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.get((double)score)).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score));
            switch (consumerType) {
                case ELASTIC_SEARCH: {
                    return builder.setSummary(Messages.getString("LuceneVersionRule_SHORT_DESCRIPTION_ES")).setExplanation(Messages.getString("LuceneVersionRule_LONG_DESCRIPTION_ES")).build();
                }
                case SOLR: {
                    return builder.setSummary(Messages.getString("LuceneVersionRule_SHORT_DESCRIPTION_SOLR")).setExplanation(Messages.getString("LuceneVersionRule_LONG_DESCRIPTION_SOLR")).build();
                }
            }
            return builder.setSummary(Messages.getString("LuceneVersionRule_SHORT_DESCRIPTION_LUCENE")).setExplanation(Messages.getString("LuceneVersionRule_LONG_DESCRIPTION_LUCENE")).build();
        }
        if (lookaheadSuccessErrors.longValue() == 1L) {
            ResultBuilder builder = ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.OK);
            switch (consumerType) {
                case ELASTIC_SEARCH: {
                    return builder.setSummary(Messages.getString("LuceneVersionRule_OK_TEXT_ES")).build();
                }
                case SOLR: {
                    return builder.setSummary(Messages.getString("LuceneVersionRule_OK_TEXT_SOLR")).build();
                }
            }
            return builder.setSummary(Messages.getString("LuceneVersionRule_OK_TEXT_LUCENE")).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.NA).setSummary(Messages.getString("LuceneVersionRule_NA_TEXT")).build();
    }

    private LuceneConsumer isElasticSearch(IItemCollection items) {
        for (IItemIterable itemIterable : items) {
            IMemberAccessor stacktraceAccessor = JfrAttributes.EVENT_STACKTRACE.getAccessor(itemIterable.getType());
            for (IItem item : itemIterable) {
                IMCStackTrace member = (IMCStackTrace)stacktraceAccessor.getMember((Object)item);
                for (IMCFrame frame : member.getFrames()) {
                    IMCPackage aPackage = frame.getMethod().getType().getPackage();
                    if (aPackage == null) continue;
                    if (aPackage.getName().startsWith("org.elasticsearch")) {
                        return LuceneConsumer.ELASTIC_SEARCH;
                    }
                    if (!aPackage.getName().startsWith("org.apache.solr")) continue;
                    return LuceneConsumer.SOLR;
                }
            }
        }
        return LuceneConsumer.LUCENE;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("LuceneVersionRule_RULE_NAME");
    }

    public String getTopic() {
        return "exceptions";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }

    private static enum LuceneConsumer {
        LUCENE,
        SOLR,
        ELASTIC_SEARCH;

    }
}

