/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui.swt;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.openjdk.jmc.joverflow.ui.swt.Breadcrumb;

public class BreadcrumbItem
extends Item {
    private static final int PADDING = 4;
    private static final int ARROW_WIDTH = 4;
    private Breadcrumb parent;
    private Color background = null;
    private Color foreground = null;
    private Font font = null;
    private Rectangle bounds = null;
    private Rectangle textBounds = null;
    private Color darkenBackground = null;
    private Color lighterForeground = null;

    public BreadcrumbItem(Breadcrumb parent, int style) {
        super((Widget)Breadcrumb.checkNull((Composite)parent), style);
        this.parent = parent;
        parent.createItem(this);
    }

    void paintItem(GC gc, Rectangle bounds) {
        Color bg = gc.getBackground();
        Color fg = gc.getForeground();
        Font font = gc.getFont();
        gc.setFont(this.getFont());
        this.textBounds = new Rectangle(bounds.x + 4 + 4, bounds.y + 4, bounds.width, bounds.height);
        Point textExtent = gc.textExtent(this.getText());
        this.textBounds.width = textExtent.x;
        this.textBounds.height = textExtent.y;
        this.bounds = bounds = new Rectangle(bounds.x, bounds.y, this.textBounds.width + 8 + 8, this.textBounds.height + 8);
        gc.setForeground(this.getBackground());
        gc.setBackground(this.getDarkenBackground());
        gc.fillGradientRectangle(bounds.x, bounds.y, bounds.width, bounds.height, true);
        gc.setBackground(this.getBackground());
        gc.setForeground(this.getForeground());
        int[] polygon = new int[]{bounds.x, bounds.y, bounds.x + 4, bounds.y + bounds.height / 2, bounds.x, bounds.y + bounds.height};
        gc.fillPolygon(polygon);
        polygon = new int[]{bounds.x + bounds.width - 4, bounds.y, bounds.x + bounds.width, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height, bounds.x + bounds.width - 4, bounds.y + bounds.height, bounds.x + bounds.width, bounds.y + bounds.height / 2};
        gc.fillPolygon(polygon);
        gc.setForeground(this.getLighterForeground());
        polygon = new int[]{bounds.x, bounds.y, bounds.x + bounds.width - 4, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height / 2, bounds.x + bounds.width - 4, bounds.y + bounds.height, bounds.x, bounds.y + bounds.height, bounds.x + 4, bounds.y + bounds.height / 2};
        gc.drawPolygon(polygon);
        gc.setForeground(this.getForeground());
        gc.drawText(this.getText(), this.textBounds.x, this.textBounds.y, true);
        gc.setBackground(bg);
        gc.setForeground(fg);
        gc.setFont(font);
    }

    Point getDimension(GC gc) {
        Font font = gc.getFont();
        gc.setFont(this.getFont());
        Point extend = gc.textExtent(this.getText());
        extend.x += 16;
        extend.y += 8;
        gc.setFont(font);
        return extend;
    }

    public void clear() {
        this.foreground = null;
        this.background = null;
        this.font = null;
        this.setData(null);
        this.setText("");
    }

    public void dispose() {
        if (this.darkenBackground != null && !this.darkenBackground.isDisposed()) {
            this.darkenBackground.dispose();
        }
        if (this.lighterForeground != null && !this.lighterForeground.isDisposed()) {
            this.lighterForeground.dispose();
        }
        super.dispose();
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.background != null) {
            return this.background;
        }
        return this.parent.getBackground();
    }

    private Color getDarkenBackground() {
        if (this.darkenBackground == null || this.darkenBackground.isDisposed()) {
            Color bg = this.getBackground();
            int r = (int)((double)bg.getRed() * 0.9);
            int g = (int)((double)bg.getGreen() * 0.9);
            int b = (int)((double)bg.getBlue() * 0.9);
            this.darkenBackground = new Color((Device)Display.getCurrent(), r, g, b);
        }
        return this.darkenBackground;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        this.background = color;
        if (this.darkenBackground != null && !this.darkenBackground.isDisposed()) {
            this.darkenBackground.dispose();
        }
        this.darkenBackground = null;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return this.bounds;
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font != null) {
            return this.font;
        }
        return this.parent.getFont();
    }

    public void setFont(Font font) {
        this.checkWidget();
        this.font = font;
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.foreground != null) {
            return this.foreground;
        }
        return this.parent.getForeground();
    }

    private Color getLighterForeground() {
        if (this.lighterForeground == null || this.lighterForeground.isDisposed()) {
            Color bg = this.getForeground();
            int r = Math.min(bg.getRed() * 2, 255);
            int g = Math.min(bg.getGreen() * 2, 255);
            int b = Math.min(bg.getBlue() * 2, 255);
            this.lighterForeground = new Color((Device)Display.getCurrent(), r, g, b);
        }
        return this.lighterForeground;
    }

    public void setForeground(Color color) {
        this.checkWidget();
        this.foreground = color;
        if (this.lighterForeground != null && !this.lighterForeground.isDisposed()) {
            this.lighterForeground.dispose();
        }
        this.lighterForeground = null;
    }

    public Breadcrumb getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Rectangle getTextBounds() {
        this.checkWidget();
        return this.textBounds;
    }
}

