/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.misc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.charts.SubdividedQuantityRange;
import org.openjdk.jmc.ui.charts.XYChart;
import org.openjdk.jmc.ui.misc.ChartCanvas;
import org.openjdk.jmc.ui.misc.ChartTextCanvas;
import org.openjdk.jmc.ui.misc.DisplayToolkit;
import org.openjdk.jmc.ui.misc.Messages;
import org.openjdk.jmc.ui.misc.PatternFly;

public class ChartButtonGroup
extends Composite {
    private static final String DEFAULT_CURSOR = "defaultCursor";
    private static final String HAND_CURSOR = "handCursor";
    private static final String ZOOM_IN_CURSOR = "zoomInCursor";
    private static final String ZOOM_OUT_CURSOR = "zoomOutCursor";
    private static final int ZOOM_INCREMENT = 1;
    private List<Button> buttonGroup;
    private Map<String, Cursor> cursors;
    private Button scaleToFitBtn;
    private Button selectionBtn;
    private Button zoomInBtn;
    private Button zoomOutBtn;
    private Button zoomPanBtn;
    private ChartCanvas chartCanvas;
    private ChartTextCanvas textCanvas;
    private Runnable resetLaneHeightAction;
    private XYChart chart;
    private ZoomPan zoomPan;

    public ChartButtonGroup(Composite parent) {
        super(parent, 0);
        GridLayout gl = new GridLayout(5, true);
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        this.setLayout((Layout)gl);
        this.setLayoutData(new GridData(4, 4, false, false));
        this.cursors = new HashMap<String, Cursor>();
        this.initCursorMap();
        this.buttonGroup = new ArrayList<Button>();
        this.initSelectionButton();
        this.initZoomInButton();
        this.initZoomOutButton();
        this.initZoomPanButton();
        this.initScaleToFitButton();
    }

    private void initCursorMap() {
        this.cursors.put(DEFAULT_CURSOR, this.getDisplay().getSystemCursor(0));
        this.cursors.put(HAND_CURSOR, this.getDisplay().getSystemCursor(21));
        this.cursors.put(ZOOM_IN_CURSOR, new Cursor((Device)this.getDisplay(), UIPlugin.getDefault().getImage("fa-zoom-in-16.png").getImageData(), 0, 0));
        this.cursors.put(ZOOM_OUT_CURSOR, new Cursor((Device)this.getDisplay(), UIPlugin.getDefault().getImage("fa-zoom-out-16.png").getImageData(), 0, 0));
    }

    private void initSelectionButton() {
        this.selectionBtn = new Button((Composite)this, 2);
        this.selectionBtn.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.selectionBtn.setImage(UIPlugin.getDefault().getImage("fa-selection-16.png"));
        this.selectionBtn.setSelection(true);
        this.selectionBtn.setToolTipText(Messages.ChartDisplayControlBar_SELECTION_TOOL_TOOLTIP);
        this.selectionBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ChartButtonGroup.this.setButtonSelectionStates(ChartButtonGroup.this.selectionBtn, null);
                ChartButtonGroup.this.changeCursor(ChartButtonGroup.DEFAULT_CURSOR);
            }
        });
        this.buttonGroup.add(this.selectionBtn);
    }

    private void initZoomInButton() {
        this.zoomInBtn = new Button((Composite)this, 2);
        this.zoomInBtn.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.zoomInBtn.setImage(UIPlugin.getDefault().getImage("fa-zoom-in-16.png"));
        this.zoomInBtn.setSelection(false);
        StringBuilder sb = new StringBuilder();
        sb.append(Messages.ChartDisplayControlBar_ZOOM_IN_CLICK_TOOLTIP);
        sb.append(System.getProperty("line.separator"));
        sb.append(Messages.ChartDisplayControlBar_ZOOM_IN_HOLD_TOOLTIP);
        this.zoomInBtn.setToolTipText(sb.toString());
        this.zoomInBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ChartButtonGroup.this.setButtonSelectionStates(ChartButtonGroup.this.zoomInBtn, ChartButtonGroup.this.zoomPanBtn);
                ChartButtonGroup.this.changeCursor(ChartButtonGroup.ZOOM_IN_CURSOR);
            }
        });
        this.zoomInBtn.addMouseListener((MouseListener)new LongPressListener(1));
        this.buttonGroup.add(this.zoomInBtn);
    }

    private void initZoomOutButton() {
        this.zoomOutBtn = new Button((Composite)this, 2);
        this.zoomOutBtn.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.zoomOutBtn.setImage(UIPlugin.getDefault().getImage("fa-zoom-out-16.png"));
        this.zoomOutBtn.setSelection(false);
        StringBuilder sb = new StringBuilder();
        sb.append(Messages.ChartDisplayControlBar_ZOOM_OUT_CLICK_TOOLTIP);
        sb.append(System.getProperty("line.separator"));
        sb.append(Messages.ChartDisplayControlBar_ZOOM_OUT_HOLD_TOOLTIP);
        this.zoomOutBtn.setToolTipText(sb.toString());
        this.zoomOutBtn.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ChartButtonGroup.this.setButtonSelectionStates(ChartButtonGroup.this.zoomOutBtn, ChartButtonGroup.this.zoomPanBtn);
                ChartButtonGroup.this.changeCursor(ChartButtonGroup.ZOOM_OUT_CURSOR);
            }
        });
        this.zoomOutBtn.addMouseListener((MouseListener)new LongPressListener(-1));
        this.buttonGroup.add(this.zoomOutBtn);
    }

    private void initZoomPanButton() {
        this.zoomPanBtn = new Button((Composite)this, 2);
        this.zoomPanBtn.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.zoomPanBtn.setImage(UIPlugin.getDefault().getImage("fa-zoom-pan-16.png"));
        this.zoomPanBtn.setSelection(false);
        this.zoomPanBtn.setToolTipText(Messages.ChartDisplayControlBar_ZOOM_PAN_TOOLTIP);
        this.zoomPanBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ChartButtonGroup.this.showZoomPanDisplay(ChartButtonGroup.this.zoomPanBtn.getSelection());
            }
        });
        this.buttonGroup.add(this.zoomPanBtn);
    }

    private void initScaleToFitButton() {
        this.scaleToFitBtn = new Button((Composite)this, 8);
        this.scaleToFitBtn.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.scaleToFitBtn.setImage(UIPlugin.getDefault().getImage("fa-scale-to-fit-16.png"));
        this.scaleToFitBtn.setSelection(false);
        this.scaleToFitBtn.setToolTipText(Messages.ChartDisplayControlBar_SCALE_TO_FIT_TOOLTIP);
        this.scaleToFitBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ChartButtonGroup.this.chart.resetTimeline();
                ChartButtonGroup.this.chartCanvas.redrawChart();
                ChartButtonGroup.this.getDisplay().syncExec(ChartButtonGroup.this.resetLaneHeightAction);
            }
        });
        this.buttonGroup.add(this.scaleToFitBtn);
    }

    void setChart(XYChart chart) {
        this.chart = chart;
    }

    void setResetLaneHeightAction(Runnable resetLaneHeightAction) {
        this.resetLaneHeightAction = resetLaneHeightAction;
    }

    void setChartCanvas(ChartCanvas chartCanvas) {
        this.chartCanvas = chartCanvas;
    }

    void setTextCanvas(ChartTextCanvas textCanvas) {
        this.textCanvas = textCanvas;
    }

    public void updateZoomPanIndicator() {
        this.zoomPan.redraw();
    }

    public void zoomOnClick(Boolean mouseDown) {
        boolean shouldZoom;
        boolean bl = shouldZoom = this.zoomInBtn.getSelection() || this.zoomOutBtn.getSelection();
        if (shouldZoom) {
            if (mouseDown.booleanValue()) {
                this.chart.clearSelection();
            } else {
                int zoomAmount = this.zoomInBtn.getSelection() ? 1 : -1;
                this.zoom(zoomAmount);
                if (this.textCanvas != null) {
                    this.textCanvas.redrawChartText();
                }
            }
        }
    }

    public void zoomToSelection() {
        if (this.zoomInBtn.getSelection()) {
            IQuantity selectionStart = this.chart.getSelectionStart();
            IQuantity selectionEnd = this.chart.getSelectionEnd();
            if (selectionStart == null || selectionEnd == null) {
                this.chart.clearVisibleRange();
            } else {
                this.chart.setVisibleRange(selectionStart, selectionEnd);
                this.chartCanvas.redrawChart();
            }
        }
    }

    private void changeCursor(String cursorName) {
        this.chartCanvas.changeCursor(this.cursors.get(cursorName));
    }

    private void setButtonSelectionStates(Button buttonSelected, Button dependentButton) {
        for (Button button : this.buttonGroup) {
            if ((button.getStyle() & 2) != 0) {
                if (button.equals(buttonSelected)) {
                    button.setSelection(true);
                } else if (dependentButton != null) {
                    if (button.equals(dependentButton)) {
                        button.setSelection(true);
                    } else {
                        button.setSelection(false);
                    }
                } else {
                    button.setSelection(false);
                }
            }
            this.showZoomPanDisplay(this.zoomPanBtn.getSelection());
        }
    }

    private void zoom(int zoomAmount) {
        this.chart.zoom(zoomAmount);
        this.chartCanvas.redrawChart();
    }

    public void createZoomPan(Composite parent) {
        this.zoomPan = new ZoomPan(parent);
        parent.setVisible(false);
    }

    private void showZoomPanDisplay(boolean show) {
        if (show) {
            this.zoomPan.getParent().setVisible(true);
            this.zoomPan.redrawZoomPan();
        } else {
            this.zoomPan.getParent().setVisible(false);
        }
    }

    private class LongPressListener
    extends MouseAdapter {
        private static final long LONG_PRESS_TIME = 500L;
        private Timer timer;
        private int zoomAmount;

        LongPressListener(int zoomAmount) {
            this.zoomAmount = zoomAmount;
        }

        public void mouseDown(MouseEvent e) {
            if (e.button == 1) {
                this.timer = new Timer();
                this.timer.schedule((TimerTask)new LongPress(), 500L, 750L);
            }
        }

        public void mouseUp(MouseEvent e) {
            this.timer.cancel();
        }

        private void doZoomInOut(int zoomAmount) {
            DisplayToolkit.inDisplayThread().execute(() -> ChartButtonGroup.this.zoom(zoomAmount));
        }

        public class LongPress
        extends TimerTask {
            @Override
            public void run() {
                LongPressListener.this.doZoomInOut(LongPressListener.this.zoomAmount);
            }
        }
    }

    private class ZoomPan
    extends Canvas {
        private static final int BORDER_PADDING = 2;
        private static final double MIN_HEIGHT_PERCENT = 0.15;
        private static final double MIN_WIDTH_PERCENT = 0.08;
        private IRange<IQuantity> chartRange;
        private IRange<IQuantity> lastChartZoomedRange;
        private Rectangle zoomRect;

        public ZoomPan(Composite parent) {
            super(parent, 262144);
            this.addPaintListener(new Painter());
            PanDetector panDetector = new PanDetector();
            this.addMouseListener((MouseListener)panDetector);
            this.addMouseMoveListener(panDetector);
            this.addMouseWheelListener(panDetector);
            this.chartRange = ChartButtonGroup.this.chart.getVisibleRange();
        }

        public void redrawZoomPan() {
            this.redraw();
        }

        private void updateZoomRectFromPan(int xdiff, int ydiff) {
            Point bounds = this.getParent().getSize();
            boolean xModified = false;
            boolean yModified = false;
            int xOld = this.zoomRect.x;
            this.zoomRect.x += xdiff;
            if (this.zoomRect.x > bounds.x - this.zoomRect.width - 2 - 1) {
                this.zoomRect.x = bounds.x - this.zoomRect.width - 2 - 1;
            } else if (this.zoomRect.x < 2) {
                this.zoomRect.x = 2;
            }
            xModified = xOld != this.zoomRect.x;
            int yOld = this.zoomRect.y;
            this.zoomRect.y += ydiff;
            if (this.zoomRect.y < 2) {
                this.zoomRect.y = 2;
            } else if (this.zoomRect.y > bounds.y - this.zoomRect.height - 2 - 1) {
                this.zoomRect.y = bounds.y - this.zoomRect.height - 2 - 1;
            }
            boolean bl = yModified = yOld != this.zoomRect.y;
            if (xModified || yModified) {
                this.updateChartFromZoomRect(xModified, yModified);
                ChartButtonGroup.this.chartCanvas.redrawChart();
            }
        }

        private void updateChartFromZoomRect(boolean updateXRange, boolean updateYRange) {
            double ratio;
            Rectangle zoomCanvasBounds = new Rectangle(0, 0, this.getParent().getSize().x, this.getParent().getSize().y);
            Rectangle totalBounds = ChartButtonGroup.this.chartCanvas.getBounds();
            if (updateXRange) {
                ratio = this.getVisibilityRatio(this.zoomRect.x - 2, zoomCanvasBounds.x, zoomCanvasBounds.width - 2);
                int start = this.getPixelLocation(ratio, totalBounds.width, 0);
                ratio = this.getVisibilityRatio(this.zoomRect.x + this.zoomRect.width + 2 + 1, zoomCanvasBounds.width, zoomCanvasBounds.width - 2);
                int end = this.getPixelLocation(ratio, totalBounds.width, totalBounds.width);
                SubdividedQuantityRange xAxis = new SubdividedQuantityRange((IQuantity)this.chartRange.getStart(), (IQuantity)this.chartRange.getEnd(), totalBounds.width, 1);
                ChartButtonGroup.this.chart.setVisibleRange(xAxis.getQuantityAtPixel(start), xAxis.getQuantityAtPixel(end));
                this.lastChartZoomedRange = ChartButtonGroup.this.chart.getVisibleRange();
            }
            if (updateYRange) {
                ratio = this.getVisibilityRatio(this.zoomRect.y - 2, 0.0, zoomCanvasBounds.height - 2);
                int top = this.getPixelLocation(ratio, totalBounds.height, 0);
                Point p = ((ScrolledComposite)ChartButtonGroup.this.chartCanvas.getParent()).getOrigin();
                p.y = top;
                if (ChartButtonGroup.this.textCanvas != null) {
                    ChartButtonGroup.this.textCanvas.syncScroll(p);
                }
                ChartButtonGroup.this.chartCanvas.syncScroll(p);
            }
        }

        private void updateZoomRectFromChart() {
            double ratio;
            Rectangle zoomCanvasBounds = new Rectangle(0, 0, this.getParent().getSize().x, this.getParent().getSize().y);
            IRange<IQuantity> zoomedRange = ChartButtonGroup.this.chart.getVisibleRange();
            IQuantity visibleWidth = (IQuantity)this.chartRange.getExtent();
            double visibleHeight = ((ChartButtonGroup)ChartButtonGroup.this).chartCanvas.getParent().getBounds().height;
            Rectangle totalBounds = ChartButtonGroup.this.chartCanvas.getBounds();
            if (this.zoomRect == null) {
                this.zoomRect = new Rectangle(0, 0, 0, 0);
            }
            if (!ChartButtonGroup.this.chart.getVisibleRange().equals(this.lastChartZoomedRange)) {
                ratio = this.getVisibilityRatio((IQuantity)zoomedRange.getStart(), (IQuantity)this.chartRange.getStart(), visibleWidth);
                int start = this.getPixelLocation(ratio, zoomCanvasBounds.width, 0);
                ratio = this.getVisibilityRatio((IQuantity)zoomedRange.getEnd(), (IQuantity)this.chartRange.getEnd(), visibleWidth);
                int end = this.getPixelLocation(ratio, zoomCanvasBounds.width, zoomCanvasBounds.width);
                this.zoomRect.x = start + 2;
                this.zoomRect.width = end - start - 4 - 1;
                this.lastChartZoomedRange = ChartButtonGroup.this.chart.getVisibleRange();
            }
            ratio = this.getVisibilityRatio(0.0, totalBounds.y, totalBounds.height);
            int top = this.getPixelLocation(ratio, zoomCanvasBounds.height, 0);
            ratio = this.getVisibilityRatio(visibleHeight, totalBounds.height + totalBounds.y, totalBounds.height);
            int bottom = this.getPixelLocation(ratio, zoomCanvasBounds.height, zoomCanvasBounds.height);
            this.zoomRect.y = top + 2;
            this.zoomRect.height = bottom - top - 4 - 1;
        }

        private double getVisibilityRatio(double visibleBound, double borderBound, double totalLength) {
            double diff = visibleBound - borderBound;
            return diff / totalLength;
        }

        private double getVisibilityRatio(IQuantity visibleBound, IQuantity borderBound, IQuantity totalLength) {
            IQuantity diff = visibleBound.subtract(borderBound);
            return diff.ratioTo(totalLength);
        }

        private int getPixelLocation(double visiblityRatio, int totalLength, int offset) {
            return offset + (int)(visiblityRatio * (double)totalLength);
        }

        class Painter
        implements PaintListener {
            Painter() {
            }

            public void paintControl(PaintEvent e) {
                Rectangle backgroundRect = new Rectangle(0, 0, ZoomPan.this.getParent().getSize().x, ZoomPan.this.getParent().getSize().y);
                GC gc = e.gc;
                gc.setBackground(PatternFly.Palette.PF_BLACK_400.getSWTColor());
                gc.fillRectangle(backgroundRect);
                gc.setForeground(PatternFly.Palette.PF_BLACK_900.getSWTColor());
                gc.drawRectangle(0, 0, backgroundRect.width - 1, backgroundRect.height - 1);
                ZoomPan.this.updateZoomRectFromChart();
                gc.setBackground(PatternFly.Palette.PF_BLACK_100.getSWTColor());
                gc.fillRectangle(ZoomPan.this.zoomRect);
                gc.setForeground(PatternFly.Palette.PF_BLACK_900.getSWTColor());
                gc.drawRectangle(ZoomPan.this.zoomRect);
            }
        }

        private class PanDetector
        extends MouseAdapter
        implements MouseMoveListener,
        MouseWheelListener {
            Point currentSelection;
            Point lastSelection;
            boolean isPan = false;

            private PanDetector() {
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1 && this.inBounds(e)) {
                    this.isPan = true;
                    ChartButtonGroup.this.chart.setIsZoomPanDrag(this.isPan);
                    this.currentSelection = ChartButtonGroup.this.chartCanvas.translateDisplayToImageCoordinates(e.x, e.y);
                }
            }

            private boolean inBounds(MouseEvent e) {
                Point zoomCanvasBounds = ZoomPan.this.getParent().getSize();
                if ((double)((ZoomPan)ZoomPan.this).zoomRect.height < 0.15 * (double)zoomCanvasBounds.y || (double)((ZoomPan)ZoomPan.this).zoomRect.width < 0.08 * (double)zoomCanvasBounds.x) {
                    return zoomCanvasBounds.x >= e.x && zoomCanvasBounds.y >= e.y;
                }
                return ZoomPan.this.zoomRect.contains(e.x, e.y);
            }

            public void mouseUp(MouseEvent e) {
                this.isPan = false;
                ChartButtonGroup.this.chart.setIsZoomPanDrag(this.isPan);
            }

            public void mouseMove(MouseEvent e) {
                ChartButtonGroup.this.zoomPan.setCursor((Cursor)ChartButtonGroup.this.cursors.get(ChartButtonGroup.HAND_CURSOR));
                if (this.isPan && ZoomPan.this.getParent().getSize().x >= e.x && ZoomPan.this.getParent().getSize().y >= e.y) {
                    this.lastSelection = this.currentSelection;
                    this.currentSelection = ChartButtonGroup.this.chartCanvas.translateDisplayToImageCoordinates(e.x, e.y);
                    int xdiff = this.currentSelection.x - this.lastSelection.x;
                    int ydiff = this.currentSelection.y - this.lastSelection.y;
                    ZoomPan.this.updateZoomRectFromPan(xdiff, ydiff);
                }
            }

            public void mouseScrolled(MouseEvent e) {
                ZoomPan.this.updateZoomRectFromPan(0, -e.count);
            }
        }
    }
}

