/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.triggers.fields.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.util.XmlToolkit;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.triggers.ISetting;
import org.w3c.dom.Element;

public abstract class Field
implements ISetting {
    private static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.rjmx.triggers.fields.internal");
    private final String m_id;
    private final String m_name;
    private final String m_description;
    private String m_value;
    private final ArrayList<FieldValueChangeListener> m_fieldValueChangeListener = new ArrayList();

    protected Field(String id, String name, String defaultValue, String description) throws Exception {
        if (id == null) {
            throw new IllegalArgumentException("Id can't be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name can't be null");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("Default value can't be null");
        }
        if (description == null) {
            throw new IllegalArgumentException("Description can't be null");
        }
        this.m_id = id;
        this.initDefaultValue(defaultValue);
        this.initDefaultPreferenceValue();
        this.m_name = name;
        this.m_description = description;
    }

    abstract void initDefaultValue(String var1);

    public void initDefaultPreferenceValue() {
        String prefDefault;
        if (this.m_id != null && (prefDefault = RJMXPlugin.getDefault().getRJMXPreferences().get(this.m_id, null)) != null && prefDefault.trim().length() != 0) {
            this.setValue(prefDefault);
        }
    }

    public synchronized void addFieldValueListener(FieldValueChangeListener listener) {
        this.m_fieldValueChangeListener.add(listener);
    }

    public synchronized boolean removeFieldValueListener(FieldValueChangeListener listener) {
        return this.m_fieldValueChangeListener.remove(listener);
    }

    public synchronized void updateListener() {
        for (FieldValueChangeListener fcl : this.m_fieldValueChangeListener) {
            fcl.onChange(this);
        }
    }

    public synchronized String getValue() {
        return this.m_value;
    }

    public synchronized boolean setValue(String value) {
        String newValue;
        if (value == null) {
            return false;
        }
        try {
            newValue = this.parsedValue(value);
        }
        catch (Exception exception) {
            return false;
        }
        if (newValue == null) {
            return false;
        }
        if (!this.equalsValue(newValue)) {
            this.putValue(newValue);
            this.updateListener();
        }
        return true;
    }

    public synchronized boolean setUncheckedValue(String value) {
        if (value == null) {
            return false;
        }
        if (!this.equalsValue(value)) {
            this.putValue(value);
            this.updateListener();
        }
        return true;
    }

    protected void putValue(String newValue) {
        this.m_value = newValue;
    }

    protected boolean equalsValue(String value) {
        String currentValue = this.getValue();
        if (value == null) {
            return currentValue == null;
        }
        return value.equals(currentValue);
    }

    public boolean validateValue(String value) {
        try {
            return this.parsedValue(value) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    abstract String parsedValue(String var1) throws Exception;

    public void initializeFromXml(Element node) {
        this.setValue(XmlToolkit.getSetting((Element)node, (String)this.getId(), (String)""));
    }

    public void exportToXml(Element node) {
        String object = this.getValue();
        try {
            XmlToolkit.setSetting((Element)node, (String)this.getId(), (String)object);
        }
        catch (Exception exception) {
            LOGGER.severe(String.valueOf('|') + object + '|');
        }
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public Date getDate() {
        return null;
    }

    @Override
    public Date getDateTime() {
        return null;
    }

    @Override
    public String getString() {
        return null;
    }

    @Override
    public Integer getInteger() {
        return null;
    }

    @Override
    public String getFileName() {
        return null;
    }

    @Override
    public Float getFloat() {
        return null;
    }

    @Override
    public Boolean getBoolean() {
        return null;
    }

    @Override
    public Long getLong() {
        return null;
    }

    @Override
    public String getPassword() {
        return null;
    }

    @Override
    public IQuantity getQuantity() {
        return null;
    }

    public static interface FieldValueChangeListener {
        public void onChange(Field var1);
    }
}

