/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.misc;

import java.awt.Color;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.openjdk.jmc.common.util.ColorToolkit;
import org.openjdk.jmc.ui.UIPlugin;

public class SWTColorToolkit {
    private static final int THUMBNAIL_SIZE = 16;
    private static final RGB BG_COLOR = new RGB(255, 255, 255);
    private static final RGB BORDER_COLOR = new RGB(0, 0, 0);

    private SWTColorToolkit() {
        throw new UnsupportedOperationException("Do not instantiate toolkit");
    }

    public static Color asAwtColor(RGB rgb) {
        return new Color(rgb.red, rgb.green, rgb.blue);
    }

    public static RGB asRGB(Color color) {
        if (color.getAlpha() < 255) {
            color = ColorToolkit.blend((Color)color, (Color)Color.WHITE);
        }
        return new RGB(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static ImageDescriptor getColorThumbnailDescriptor(RGB color) {
        String id;
        ImageRegistry ir = UIPlugin.getDefault().getImageRegistry();
        ImageDescriptor desc = ir.getDescriptor(id = SWTColorToolkit.getColorKey(color));
        if (desc == null) {
            Image i = SWTColorToolkit.createColoredSquare(Display.getDefault(), 16, color);
            ir.put(id, i);
        }
        return ir.getDescriptor(id);
    }

    public static Image getColorThumbnail(Color color) {
        return SWTColorToolkit.getColorThumbnail(SWTColorToolkit.asRGB(color));
    }

    public static Image getColorThumbnail(RGB color) {
        String id;
        ImageRegistry ir = UIPlugin.getDefault().getImageRegistry();
        Image i = ir.get(id = SWTColorToolkit.getColorKey(color));
        if (i == null) {
            i = SWTColorToolkit.createColoredSquare(Display.getDefault(), 16, color);
            ir.put(id, i);
        }
        return i;
    }

    private static String getColorKey(RGB color) {
        return String.valueOf(UIPlugin.ImageRegistryPrefixes.COLORED_SQUARE.name()) + color;
    }

    private static Image createColoredSquare(Display disp, int size, RGB color) {
        Image i = new Image((Device)disp, size, size);
        GC gc = new GC((Drawable)i);
        gc.setBackground(SWTColorToolkit.getColor(BG_COLOR));
        gc.fillRectangle(0, 0, size - 1, size - 1);
        gc.setBackground(SWTColorToolkit.getColor(color));
        gc.fillRectangle(1, 1, size - 3, size - 3);
        gc.setForeground(SWTColorToolkit.getColor(BORDER_COLOR));
        gc.drawRectangle(1, 1, size - 3, size - 3);
        gc.dispose();
        return i;
    }

    public static ImageDescriptor createGradientThumbnail(RGB start, RGB end, boolean vertical) {
        return ImageDescriptor.createFromImageDataProvider(zoom -> {
            int size = 16;
            Image i = new Image((Device)Display.getDefault(), size, size);
            GC gc = new GC((Drawable)i);
            gc.setBackground(SWTColorToolkit.getColor(BG_COLOR));
            gc.fillRectangle(0, 0, size - 1, size - 1);
            gc.setForeground(SWTColorToolkit.getColor(start));
            gc.setBackground(SWTColorToolkit.getColor(end));
            gc.fillGradientRectangle(1, 1, size - 3, size - 3, vertical);
            gc.setForeground(SWTColorToolkit.getColor(BORDER_COLOR));
            gc.drawRectangle(1, 1, size - 3, size - 3);
            gc.dispose();
            ImageData imageData = i.getImageData(zoom);
            i.dispose();
            return imageData;
        });
    }

    public static org.eclipse.swt.graphics.Color getColor(RGB rgb) {
        String key = rgb.toString();
        org.eclipse.swt.graphics.Color color = JFaceResources.getColorRegistry().get(key);
        if (color == null) {
            JFaceResources.getColorRegistry().put(key, rgb);
            color = JFaceResources.getColorRegistry().get(key);
        }
        return color;
    }
}

