/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.DropdownLaneFilter;
import org.openjdk.jmc.flightrecorder.ui.common.FlavorSelector;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogram;
import org.openjdk.jmc.flightrecorder.ui.common.ItemRow;
import org.openjdk.jmc.flightrecorder.ui.common.ThreadGraphLanes;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.pages.ThreadsPageLayoutUI;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.QuantitySpanRenderer;
import org.openjdk.jmc.ui.charts.RendererToolkit;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.ActionToolkit;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;

public class ThreadsPage
extends AbstractDataPage {
    private static final String THREAD_START_COL = "threadStart";
    private static final String THREAD_END_COL = "threadEnd";
    private static final String THREAD_DURATION_COL = "threadDuration";
    private static final String THREAD_LANE = "threadLane";
    private static final IItemFilter pageFilter = ItemFilters.hasAttribute((ICanonicalAccessorFactory)JfrAttributes.EVENT_THREAD);
    private static final ItemHistogram.ItemHistogramBuilder HISTOGRAM = new ItemHistogram.ItemHistogramBuilder();
    private FlavorSelector.FlavorSelectorState flavorSelectorState;
    private ColumnManager.SelectionState histogramSelectionState;
    private IItemFilter tableFilter;
    private IRange<IQuantity> visibleRange;

    static {
        HISTOGRAM.addColumn(JdkAttributes.EVENT_THREAD_GROUP_NAME);
        HISTOGRAM.addColumn(JdkAttributes.EVENT_THREAD_ID);
        HISTOGRAM.addColumn(THREAD_START_COL, Aggregators.min((String)Messages.JavaApplicationPage_COLUMN_THREAD_START, (String)Messages.JavaApplicationPage_COLUMN_THREAD_START_DESC, (String)"jdk.ThreadStart", (IAttribute)JfrAttributes.EVENT_TIMESTAMP));
        HISTOGRAM.addColumn(THREAD_END_COL, Aggregators.max((String)Messages.JavaApplicationPage_COLUMN_THREAD_END, (String)Messages.JavaApplicationPage_COLUMN_THREAD_END_DESC, (String)"jdk.ThreadEnd", (IAttribute)JfrAttributes.EVENT_TIMESTAMP));
        HISTOGRAM.addColumn(THREAD_DURATION_COL, ic -> {
            IQuantity threadStart = (IQuantity)ic.apply(ItemFilters.type((String)"jdk.ThreadStart")).getAggregate(Aggregators.min((IAttribute)JfrAttributes.EVENT_TIMESTAMP));
            IQuantity threadEnd = (IQuantity)ic.apply(ItemFilters.type((String)"jdk.ThreadEnd")).getAggregate(Aggregators.max((IAttribute)JfrAttributes.EVENT_TIMESTAMP));
            if (threadStart != null && threadEnd != null) {
                return threadEnd.subtract(threadStart);
            }
            return null;
        }, Messages.JavaApplicationPage_COLUMN_THREAD_DURATION, Messages.JavaApplicationPage_COLUMN_THREAD_DURATION_DESC);
    }

    public ThreadsPage(IPageDefinition definition, StreamModel model, IPageContainer editor) {
        super(definition, model, editor);
        this.visibleRange = editor.getRecordingRange();
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer editor, IState state) {
        return new ThreadsPageUi(parent, toolkit, editor, state);
    }

    public static class ThreadsPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.ThreadsPage_NAME;
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"threads"};
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/threadgraph.png");
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition definition, StreamModel items, IPageContainer editor) {
            return new ThreadsPage(definition, items, editor);
        }
    }

    private class ThreadsPageUi
    extends ThreadsPageLayoutUI {
        private static final String THREADS_TABLE_FILTER = "threadsTableFilter";
        private static final String FOLD_CHART_ACTION = "foldChartAction";
        private static final String FOLD_TABLE_ACTION = "foldTableAction";
        private static final String HIDE_THREAD = "hideThread";
        private static final String RESET_CHART = "resetChart";
        public static final String TOOLBAR_FOLD_ACTIONS = "foldActions";
        private Boolean isChartMenuActionsInit;
        private Boolean isChartModified;
        private Boolean reloadThreads;
        private IAction foldChartAction;
        private IAction foldTableAction;
        private IAction hideThreadActionChart;
        private IAction hideThreadActionText;
        private IAction resetChartAction;
        private int[] weights;
        private List<IXDataRenderer> threadRows;
        private MCContextMenuManager mmChart;
        private MCContextMenuManager mmText;
        private MCContextMenuManager[] mms;
        private ThreadGraphLanes lanes;
        private DropdownLaneFilter laneFilter;

        ThreadsPageUi(Composite parent, FormToolkit toolkit, IPageContainer editor, IState state) {
            super(pageFilter, ThreadsPage.this.getDataSource(), parent, toolkit, editor, state, ThreadsPage.this.getName(), pageFilter, ThreadsPage.this.getIcon(), ThreadsPage.this.flavorSelectorState, JfrAttributes.EVENT_THREAD);
            this.mmChart = (MCContextMenuManager)this.chartCanvas.getContextMenu();
            this.mmText = (MCContextMenuManager)this.textCanvas.getContextMenu();
            this.mms = new MCContextMenuManager[]{this.mmChart, this.mmText};
            this.initializeStoredSashWeights();
            this.canvasSash.setOrientation(256);
            this.addResizeListenerToTableAndChartComponents();
            this.addActionsToContextMenu();
            this.lanes.updateContextMenus(this.mms, false);
            this.addActionsToToolbar(this.form.getToolBarManager());
            this.chartLegend.getControl().dispose();
            this.form.getToolBarManager().update(true);
            this.setupLaneFilter();
            this.buildChart(true);
            this.table.getManager().setSelectionState(ThreadsPage.this.histogramSelectionState);
            this.tableFilterComponent.loadState(state.getChild(THREADS_TABLE_FILTER));
            TableColumn[] tableColumnArray = ((TableViewer)this.table.getManager().getViewer()).getTable().getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn columnWidget = tableColumnArray[n2];
                columnWidget.addListener(13, e -> this.buildChart(false));
                ++n2;
            }
            this.chart.setVisibleRange((IQuantity)ThreadsPage.this.visibleRange.getStart(), (IQuantity)ThreadsPage.this.visibleRange.getEnd());
            this.onFilterChange(ThreadsPage.this.tableFilter);
        }

        private void addActionsToToolbar(IToolBarManager tb) {
            this.foldTableAction = ActionToolkit.checkAction(selected -> this.performToolbarAction(FOLD_TABLE_ACTION, (boolean)selected), (String)(this.sash.getWeights()[0] == 0 ? Messages.ThreadsPage_SHOW_TABLE_TOOLTIP : Messages.ThreadsPage_FOLD_TABLE_TOOLTIP), (ImageDescriptor)FlightRecorderUI.getDefault().getMCImageDescriptor("table.gif"));
            this.foldTableAction.setChecked(this.sash.getWeights()[0] != 0);
            this.foldChartAction = ActionToolkit.checkAction(selected -> this.performToolbarAction(FOLD_CHART_ACTION, (boolean)selected), (String)(this.sash.getWeights()[1] == 0 ? Messages.ThreadsPage_SHOW_CHART_TOOLTIP : Messages.ThreadsPage_FOLD_CHART_TOOLTIP), (ImageDescriptor)FlightRecorderUI.getDefault().getMCImageDescriptor("chart_bar_16x16.gif"));
            this.foldChartAction.setChecked(this.sash.getWeights()[1] != 0);
            tb.add((IContributionItem)new GroupMarker(TOOLBAR_FOLD_ACTIONS));
            tb.appendToGroup(TOOLBAR_FOLD_ACTIONS, this.foldTableAction);
            tb.appendToGroup(TOOLBAR_FOLD_ACTIONS, this.foldChartAction);
            tb.appendToGroup(TOOLBAR_FOLD_ACTIONS, (IContributionItem)new Separator());
            tb.add(ActionToolkit.action(() -> this.lanes.openEditLanesDialog(this.mms, false), (String)Messages.ThreadsPage_EDIT_LANES, (ImageDescriptor)FlightRecorderUI.getDefault().getMCImageDescriptor("lanes_edit.gif")));
        }

        private void addResizeListenerToTableAndChartComponents() {
            this.tableFilterComponent.getComponent().addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    if (!ThreadsPageUi.this.foldTableAction.isChecked() && ThreadsPageUi.this.tableFilterComponent.getComponent().getSize().y > 0) {
                        ThreadsPageUi.this.foldTableAction.setChecked(true);
                    }
                }
            });
            this.canvasSash.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    if (!ThreadsPageUi.this.foldChartAction.isChecked() && ThreadsPageUi.this.chartCanvas.getSize().y > 0) {
                        ThreadsPageUi.this.foldChartAction.setChecked(true);
                    }
                }
            });
        }

        private void performToolbarAction(String action, boolean selected) {
            switch (action) {
                case "foldTableAction": {
                    if (selected) {
                        this.sash.setWeights(this.getStoredSashWeights());
                        this.foldTableAction.setToolTipText(Messages.ThreadsPage_FOLD_TABLE_TOOLTIP);
                        break;
                    }
                    if (this.sash.getWeights()[1] == 0) {
                        this.foldTableAction.setChecked(true);
                        break;
                    }
                    this.setStoredSashWeights(this.sash.getWeights());
                    int[] nArray = new int[2];
                    nArray[1] = 2;
                    this.sash.setWeights(nArray);
                    this.foldTableAction.setToolTipText(Messages.ThreadsPage_SHOW_TABLE_TOOLTIP);
                    break;
                }
                case "foldChartAction": {
                    if (selected) {
                        this.sash.setWeights(this.getStoredSashWeights());
                        this.foldChartAction.setToolTipText(Messages.ThreadsPage_FOLD_CHART_TOOLTIP);
                        break;
                    }
                    if (this.sash.getWeights()[0] == 0) {
                        this.foldChartAction.setChecked(true);
                        break;
                    }
                    this.setStoredSashWeights(this.sash.getWeights());
                    int[] nArray = new int[2];
                    nArray[0] = 1;
                    this.sash.setWeights(nArray);
                    this.foldChartAction.setToolTipText(Messages.ThreadsPage_SHOW_CHART_TOOLTIP);
                }
            }
        }

        private void initializeStoredSashWeights() {
            if (this.sash.getWeights()[0] == 0 || this.sash.getWeights()[1] == 0) {
                this.setStoredSashWeights(new int[]{1, 2});
            } else {
                this.setStoredSashWeights(this.sash.getWeights());
            }
        }

        protected int[] getStoredSashWeights() {
            return this.weights;
        }

        protected void setStoredSashWeights(int[] weights) {
            this.weights = weights;
        }

        private void setupLaneFilter() {
            MCContextMenuManager[] mms = new MCContextMenuManager[]{this.mmChart, this.mmText};
            this.laneFilter = new DropdownLaneFilter(this.controlBar.getLaneFilterContainer(), this.lanes, mms);
            this.laneFilter.setLayoutData(new GridData(16384, 0x1000000, false, false));
        }

        private void hideThread(Object thread) {
            if (this.threadRows != null && this.threadRows.size() > 0 && thread instanceof IMCThread) {
                int index = this.indexOfThread(thread);
                if (index != -1) {
                    this.threadRows.remove(index);
                    this.reloadThreads = false;
                    this.buildChart(false);
                    if (!this.isChartModified.booleanValue()) {
                        this.isChartModified = true;
                        this.setResetChartActionEnablement(true);
                    }
                }
                if (this.threadRows.size() == 0) {
                    this.setHideThreadActionEnablement(false);
                }
            }
        }

        private int indexOfThread(Object thread) {
            int i = 0;
            while (i < this.threadRows.size() && thread != null) {
                if (this.threadRows.get(i) instanceof QuantitySpanRenderer && thread.equals(((QuantitySpanRenderer)this.threadRows.get(i)).getData())) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private void addActionsToContextMenu() {
            this.mmChart.add((IContributionItem)new Separator());
            this.mmText.add((IContributionItem)new Separator());
            IAction hideThreadActionChart = ActionToolkit.action(() -> this.hideThread(this.chartCanvas.getHoveredItemData()), (String)Messages.ThreadsPage_HIDE_THREAD_ACTION, (ImageDescriptor)UIPlugin.getDefault().getMCImageDescriptor("delete-16.png"));
            hideThreadActionChart.setId(HIDE_THREAD);
            this.hideThreadActionChart = hideThreadActionChart;
            this.mmChart.add(hideThreadActionChart);
            IAction hideThreadActionText = ActionToolkit.action(() -> this.hideThread(this.textCanvas.getHoveredItemData()), (String)Messages.ThreadsPage_HIDE_THREAD_ACTION, (ImageDescriptor)UIPlugin.getDefault().getMCImageDescriptor("delete-16.png"));
            hideThreadActionText.setId(HIDE_THREAD);
            this.hideThreadActionText = hideThreadActionText;
            this.mmText.add(hideThreadActionText);
            IAction resetChartAction = ActionToolkit.action(() -> this.resetChartToSelection(), (String)Messages.ThreadsPage_RESET_CHART_TO_SELECTION_ACTION, (ImageDescriptor)UIPlugin.getDefault().getMCImageDescriptor("refresh_tab.gif"));
            resetChartAction.setId(RESET_CHART);
            resetChartAction.setEnabled(this.isChartModified.booleanValue());
            this.resetChartAction = resetChartAction;
            this.mmChart.add(resetChartAction);
            this.mmText.add(resetChartAction);
            this.isChartMenuActionsInit = true;
        }

        private void resetChartToSelection() {
            this.buildChart(false);
            this.isChartModified = false;
            this.setResetChartActionEnablement(false);
            this.setHideThreadActionEnablement(true);
        }

        private void setHideThreadActionEnablement(Boolean enabled) {
            this.hideThreadActionChart.setEnabled(enabled.booleanValue());
            this.hideThreadActionText.setEnabled(enabled.booleanValue());
        }

        private void setResetChartActionEnablement(Boolean enabled) {
            this.resetChartAction.setEnabled(enabled.booleanValue());
        }

        @Override
        protected ItemHistogram buildHistogram(Composite parent, IState state, IAttribute<?> classifier) {
            ItemHistogram build = HISTOGRAM.buildWithoutBorder(parent, classifier, TableSettings.forState((IState)state));
            return build;
        }

        @Override
        protected IXDataRenderer getChartRenderer(IItemCollection itemsInTable, ItemHistogram.HistogramSelection tableSelection) {
            boolean useDefaultSelection;
            ItemHistogram.HistogramSelection selection;
            IItemCollection selectedItems;
            List<IXDataRenderer> rows = new ArrayList<IXDataRenderer>();
            ItemHistogram histogram = this.table;
            if (tableSelection.getRowCount() == 0) {
                selectedItems = itemsInTable;
                selection = histogram.getAllRows();
            } else {
                selectedItems = tableSelection.getItems();
                selection = tableSelection;
            }
            boolean bl = useDefaultSelection = rows.size() > 1;
            if (this.lanes.getLaneDefinitions().stream().anyMatch(a -> a.isEnabled()) && selection.getRowCount() > 0) {
                if (this.reloadThreads.booleanValue()) {
                    this.threadRows = selection.getSelectedRows((object, items) -> this.lanes.buildThreadRenderer(object, (IItemCollection)items)).collect(Collectors.toList());
                    this.chartCanvas.setNumItems(this.threadRows.size());
                    this.textCanvas.setNumItems(this.threadRows.size());
                    this.isChartModified = false;
                    if (this.isChartMenuActionsInit.booleanValue()) {
                        this.setResetChartActionEnablement(false);
                        this.setHideThreadActionEnablement(true);
                    }
                } else {
                    this.reloadThreads = true;
                }
                double threadsWeight = Math.sqrt(this.threadRows.size()) * 0.15;
                double otherRowWeight = Math.max(threadsWeight * 0.1, (1.0 - threadsWeight) / (double)rows.size());
                List weights = Stream.concat(Stream.generate(() -> otherRowWeight).limit(rows.size()), Stream.of(Double.valueOf(threadsWeight))).collect(Collectors.toList());
                rows.add(RendererToolkit.uniformRows(this.threadRows));
                useDefaultSelection = true;
                rows = Arrays.asList(RendererToolkit.weightedRows(rows, weights));
            }
            IXDataRenderer root = rows.size() == 1 ? (IXDataRenderer)rows.get(0) : RendererToolkit.uniformRows(rows);
            return useDefaultSelection ? new ItemRow(root, selectedItems.apply(this.lanes.getEnabledLanesFilter())) : root;
        }

        @Override
        protected void onFilterChange(IItemFilter filter) {
            super.onFilterChange(filter);
            ThreadsPage.this.tableFilter = filter;
        }

        @Override
        public void saveTo(IWritableState state) {
            super.saveTo(state);
            this.tableFilterComponent.saveState(state.createChild(THREADS_TABLE_FILTER));
            this.lanes.saveTo(state);
            this.saveToLocal();
        }

        private void saveToLocal() {
            ThreadsPage.this.flavorSelectorState = this.flavorSelector.getFlavorSelectorState();
            ThreadsPage.this.histogramSelectionState = this.table.getManager().getSelectionState();
            ThreadsPage.this.visibleRange = this.chart.getVisibleRange();
        }

        @Override
        protected List<IAction> initializeChartConfiguration(IState state) {
            this.isChartMenuActionsInit = false;
            this.isChartModified = false;
            this.reloadThreads = true;
            this.lanes = new ThreadGraphLanes(() -> ThreadsPage.this.getDataSource(), () -> this.buildChart(false));
            return this.lanes.initializeChartConfiguration(Stream.of(state.getChildren(ThreadsPage.THREAD_LANE)));
        }
    }
}

