/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedCollectionResult;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class PasswordsInArgumentsRule
implements IRule {
    static final String PASSWORD_MATCH_STRING = "PASSW";
    public static final Pattern PASSWORD_PATTERN = Pattern.compile("(?i:PASSW)");
    private static final String PWD_RESULT_ID = "PasswordsInArguments";
    public static final TypedPreference<String> EXCLUDED_STRINGS_REGEXP = new TypedPreference("passwordsinargs.string.exclude.regexp", Messages.getString("PasswordsInArgsRule_CONFIG_EXCLUDED_STRINGS"), Messages.getString("PasswordsInArgsRule_CONFIG_EXCLUDED_STRINGS_LONG"), UnitLookup.PLAIN_TEXT.getPersister(), (Object)".*(passworld|passwise).*");
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(EXCLUDED_STRINGS_REGEXP);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.JVMInformation", RulesToolkit.EventAvailability.AVAILABLE).build();
    public static final TypedCollectionResult<String> PASSWORDS = new TypedCollectionResult("suspiciousJavaArgs", "Passwords", "Potential passwords found in command line arguments.", UnitLookup.PLAIN_TEXT, String.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(PASSWORDS);

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        String pwds;
        String stringExcludeRegexp = ((String)valueProvider.getPreferenceValue(EXCLUDED_STRINGS_REGEXP)).trim();
        if (!stringExcludeRegexp.isEmpty()) {
            IItemFilter matchesExclude = ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.JAVA_ARGUMENTS, (String)stringExcludeRegexp);
            IItemFilter stringsExcludingExclude = ItemFilters.and((IItemFilter[])new IItemFilter[]{ItemFilters.type((String)"jdk.JVMInformation"), ItemFilters.not((IItemFilter)matchesExclude)});
            items = items.apply(stringsExcludingExclude);
        }
        if ((pwds = RulesToolkit.findMatches((String)"jdk.JVMInformation", (IItemCollection)items, (IAttribute)JdkAttributes.JAVA_ARGUMENTS, (String)PASSWORD_MATCH_STRING, (boolean)true)) != null && pwds.length() > 0) {
            String[] args = pwds.split(" ");
            ArrayList<String> passwords = new ArrayList<String>();
            for (String arg : args) {
                Matcher matcher = PASSWORD_PATTERN.matcher(arg);
                if (!matcher.find()) continue;
                if (arg.contains("=")) {
                    passwords.add(arg.substring(0, arg.indexOf(61) + 1) + "[...]");
                    continue;
                }
                passwords.add(arg);
            }
            String explanation = Messages.getString("PasswordsInArgsRule_JAVAARGS_TEXT_INFO_LONG");
            if (!stringExcludeRegexp.isEmpty()) {
                explanation = explanation + " " + Messages.getString("PasswordsInArgsRule_TEXT_INFO_EXCLUDED");
            }
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.WARNING).setSummary(Messages.getString("PasswordsInArgsRule_JAVAARGS_TEXT_INFO")).setExplanation(explanation).setSolution(Messages.getString("PasswordsInArgsRule_JAVAARGS_TEXT_SOLUTION")).addResult(PASSWORDS, passwords).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("PasswordsInArgsRule_TEXT_OK")).build();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return PasswordsInArgumentsRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return PWD_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("PasswordsInArgsRule_RULE_NAME");
    }

    public String getTopic() {
        return "jvm_information";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

