/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IItemQuery;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.flightrecorder.rules.jdk.util.ColumnInfo;
import org.openjdk.jmc.flightrecorder.rules.jdk.util.IItemResultSet;
import org.openjdk.jmc.flightrecorder.rules.jdk.util.ItemResultSetException;
import org.openjdk.jmc.flightrecorder.rules.jdk.util.SingleEntryItemCollection;

final class DefaultIItemResultSet
implements IItemResultSet {
    private final IItemQuery query;
    private final List<IAttribute<?>> attributes = new ArrayList();
    private final List<IAggregator<?, ?>> aggregators = new ArrayList();
    private final Map<String, ColumnInfo> info;
    private final ArrayList<Object[]> data = new ArrayList();
    private final ConcurrentLinkedQueue<Object[]> processingQueue = new ConcurrentLinkedQueue();
    private int cursor = -1;
    private final ExecutorService exec;

    DefaultIItemResultSet(IItemCollection items, IItemQuery query, int configuredTimeout) {
        this.query = query;
        this.attributes.addAll(query.getAttributes());
        this.aggregators.addAll(query.getAggregators());
        this.info = new HashMap<String, ColumnInfo>(this.attributes.size() + this.aggregators.size());
        this.exec = Executors.newWorkStealingPool();
        this.initializeMetadata();
        try {
            this.calculateData(items, configuredTimeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateData(IItemCollection input, int configuredTimeout) throws InterruptedException {
        ArrayList<Future> futures = new ArrayList<Future>();
        input = input.apply(this.query.getFilter());
        if (this.query.getGroupBy() == null) {
            for (IItemIterable iterable : input) {
                IType type = iterable.getType();
                IMemberAccessor[] accessors = new IMemberAccessor[this.attributes.size()];
                for (int i = 0; i < accessors.length; ++i) {
                    accessors[i] = this.attributes.get(i).getAccessor(type);
                }
                for (IItem item : iterable) {
                    Object[] row = this.newRow();
                    for (int column = 0; column < this.attributes.size(); ++column) {
                        row[column] = accessors[column].getMember((Object)item);
                    }
                    for (int j = 0; j < this.aggregators.size(); ++j) {
                        row[column + j] = new SingleEntryItemCollection(item, input.getUnfilteredTimeRanges()).getAggregate(this.aggregators.get(j));
                    }
                    this.processingQueue.add(row);
                }
            }
        } else {
            IAggregator aggregator = Aggregators.distinct((IAttribute)this.query.getGroupBy());
            Future<?> future = null;
            final IItemCollection newInput = input;
            Set aggregate = (Set)input.getAggregate(aggregator);
            if (aggregate != null) {
                try {
                    for (final Object o : aggregate) {
                        future = this.exec.submit(new Runnable(){

                            @Override
                            public void run() {
                                IItemCollection rowCollection = newInput.apply(ItemFilters.equals((ICanonicalAccessorFactory)DefaultIItemResultSet.this.query.getGroupBy(), (Object)o));
                                Object[] row = DefaultIItemResultSet.this.newRow();
                                for (int column = 0; column < DefaultIItemResultSet.this.attributes.size(); ++column) {
                                    row[column] = DefaultIItemResultSet.getFirstNonNull(rowCollection, (IAttribute)DefaultIItemResultSet.this.attributes.get(column));
                                }
                                for (int j = 0; j < DefaultIItemResultSet.this.aggregators.size(); ++j) {
                                    row[column + j] = rowCollection.getAggregate((IAggregator)DefaultIItemResultSet.this.aggregators.get(j));
                                }
                                DefaultIItemResultSet.this.processingQueue.add(row);
                            }
                        });
                        futures.add(future);
                    }
                }
                finally {
                    this.exec.shutdown();
                    try {
                        if (!this.exec.awaitTermination(configuredTimeout, TimeUnit.MINUTES)) {
                            this.checkStatusOfAllTasks(futures);
                            this.exec.shutdownNow();
                        }
                    }
                    catch (InterruptedException ie) {
                        this.exec.shutdownNow();
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        this.data.addAll(this.processingQueue);
    }

    private void checkStatusOfAllTasks(List<Future> totalAssignedTasks) {
        int completedTask = 0;
        for (Future future : totalAssignedTasks) {
            if (!future.isDone()) continue;
            ++completedTask;
        }
        if (completedTask < totalAssignedTasks.size()) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "The results may be inaccurate as JMC is unable to process all the class entries to determine the class leak results. Please increase the configured timeout in preferences to see the accurate results.");
        }
    }

    private static Object getFirstNonNull(IItemCollection items, IAttribute<?> attribute) {
        for (IItemIterable iterable : items) {
            IType type = iterable.getType();
            IMemberAccessor accessor = attribute.getAccessor(type);
            if (accessor == null) continue;
            for (IItem item : iterable) {
                Object o = accessor.getMember((Object)item);
                if (o == null) continue;
                return o;
            }
        }
        return null;
    }

    private Object[] newRow() {
        return new Object[this.getNoOfColumns()];
    }

    private void initializeMetadata() {
        int columnId;
        int count = 0;
        for (final IAttribute<?> iAttribute : this.attributes) {
            columnId = count++;
            this.info.put(iAttribute.getIdentifier(), new ColumnInfo(){

                @Override
                public String getColumnId() {
                    return iAttribute.getIdentifier();
                }

                @Override
                public int getColumn() {
                    return columnId;
                }
            });
        }
        for (final IAggregator iAggregator : this.aggregators) {
            columnId = count++;
            this.info.put(iAggregator.getName(), new ColumnInfo(){

                @Override
                public String getColumnId() {
                    return iAggregator.getName();
                }

                @Override
                public int getColumn() {
                    return columnId;
                }
            });
        }
    }

    @Override
    public IItemQuery getQuery() {
        return this.query;
    }

    @Override
    public Object getValue(int column) throws ItemResultSetException {
        if (this.cursor == -1) {
            throw new ItemResultSetException("Cursor before first row.");
        }
        if (column < this.getNoOfColumns()) {
            if (this.cursor < this.data.size()) {
                return this.data.get(this.cursor)[column];
            }
            throw new ItemResultSetException("Cursor beyond last row.");
        }
        throw new ItemResultSetException("The specified column (" + column + ") is not available!");
    }

    private int getNoOfColumns() {
        return this.attributes.size() + this.aggregators.size();
    }

    @Override
    public Map<String, ColumnInfo> getColumnMetadata() {
        return this.info;
    }

    @Override
    public boolean next() {
        ++this.cursor;
        return this.cursor < this.data.size();
    }
}

