/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.attributes;

import java.rmi.UnmarshalException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.CompositeData;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.util.ExceptionToolkit;
import org.openjdk.jmc.rjmx.ConnectionException;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.ServiceNotAvailableException;
import org.openjdk.jmc.rjmx.services.IAttributeInfo;
import org.openjdk.jmc.rjmx.services.IUpdateInterval;
import org.openjdk.jmc.rjmx.subscription.IMBeanHelperService;
import org.openjdk.jmc.rjmx.subscription.IUpdatePolicy;
import org.openjdk.jmc.rjmx.subscription.MRI;
import org.openjdk.jmc.rjmx.subscription.MRIMetadataToolkit;
import org.openjdk.jmc.rjmx.subscription.MRIValueEvent;
import org.openjdk.jmc.rjmx.subscription.internal.AttributeValueToolkit;
import org.openjdk.jmc.rjmx.subscription.internal.DefaultUpdatePolicy;
import org.openjdk.jmc.rjmx.subscription.internal.ExtendedMRIMetadataToolkit;
import org.openjdk.jmc.rjmx.subscription.internal.OneShotUpdatePolicy;
import org.openjdk.jmc.rjmx.subscription.internal.SimpleUpdatePolicy;
import org.openjdk.jmc.rjmx.subscription.internal.UpdatePolicyToolkit;
import org.openjdk.jmc.rjmx.ui.RJMXUIPlugin;
import org.openjdk.jmc.rjmx.ui.attributes.Messages;
import org.openjdk.jmc.rjmx.util.internal.AbstractReadOnlyAttribute;
import org.openjdk.jmc.rjmx.util.internal.PartitionedList;
import org.openjdk.jmc.rjmx.util.internal.SimpleAttributeInfo;
import org.openjdk.jmc.ui.common.util.Environment;

public class ReadOnlyMRIAttribute
extends AbstractReadOnlyAttribute
implements IUpdateInterval,
IAdaptable {
    private static final int MAX_TRACE_FRAMES_IN_MESSAGE = 5;
    private final IConnectionHandle m_handle;
    private final MRI m_mri;
    private Object m_value;
    private String m_refreshProblem = null;

    protected ReadOnlyMRIAttribute(IConnectionHandle handle, MRI mri) {
        this(handle, mri, null);
    }

    public ReadOnlyMRIAttribute(IConnectionHandle handle, MRI mri, Object value) {
        super((IAttributeInfo)new SimpleAttributeInfo(ReadOnlyMRIAttribute.extractName(mri.getDataPath()), MRIMetadataToolkit.getMRIMetadata((IConnectionHandle)handle, (MRI)mri).getValueType()));
        this.m_handle = handle;
        this.m_mri = mri;
        this.m_value = value;
    }

    private static String extractName(String dataPath) {
        if (dataPath == null) {
            return "[null]";
        }
        int index = dataPath.lastIndexOf(47);
        if (index >= 0) {
            return String.valueOf('#') + dataPath.substring(index + 1);
        }
        return dataPath;
    }

    public boolean hasChildren() {
        if (this.getValue() instanceof CompositeData) {
            return !((CompositeData)this.getValue()).getCompositeType().keySet().isEmpty();
        }
        return super.hasChildren();
    }

    public Collection<?> getChildren() {
        if (this.getValue() instanceof CompositeData) {
            return this.getMRICompositeChildren((CompositeData)this.getValue());
        }
        return super.getChildren();
    }

    private Collection<?> getMRICompositeChildren(CompositeData compositeDataValue) {
        IConnectionHandle handle = this.getHandle();
        MRI baseMRI = this.getMRI();
        ArrayList<ReadOnlyMRIAttribute> elements = new ArrayList<ReadOnlyMRIAttribute>();
        for (String key : compositeDataValue.getCompositeType().keySet()) {
            elements.add(new ReadOnlyMRIAttribute(handle, new MRI(baseMRI, key), compositeDataValue.get(key)));
        }
        return PartitionedList.create(elements);
    }

    public boolean refresh() {
        Object newValue;
        block9: {
            newValue = this.getMBeanHelperService().getAttributeValue(this.m_mri);
            if (!(this.m_value == null ? newValue == null : this.m_value.equals(newValue))) break block9;
            return false;
        }
        try {
            this.m_refreshProblem = null;
            this.m_value = newValue;
            return true;
        }
        catch (ConnectionException connectionException) {
            this.m_refreshProblem = Messages.ReadOnlyMRIAttribute_PROBLEM_CONNECTION_CLOSED;
            RJMXUIPlugin.getDefault().getLogger().log(Level.INFO, "Could not refresh ReadOnlyMRIAttribute since the connection was closed");
        }
        catch (UnmarshalException e) {
            this.m_refreshProblem = String.valueOf(NLS.bind((String)Messages.ReadOnlyMRIAttribute_PROBLEM_UNMARSHAL, (Object)this.getMRI().getDataPath())) + "\n" + e.getMessage();
            if (Environment.isDebug()) {
                RJMXUIPlugin.getDefault().getLogger().log(Level.WARNING, MessageFormat.format("Could not unmarshal the value for attribute {0}: {1}", this.getMRI().getDataPath(), e.getMessage()), e);
            }
        }
        catch (MBeanException e) {
            Throwable cause = ReadOnlyMRIAttribute.unmarshalMBeanException(e);
            this.m_refreshProblem = String.valueOf(NLS.bind((String)Messages.ReadOnlyMRIAttribute_PROBLEM_SERVER, (Object)this.getMRI().getDataPath())) + "\n" + ExceptionToolkit.toString((Throwable)cause, (int)5);
            if (Environment.isDebug()) {
                RJMXUIPlugin.getDefault().getLogger().log(Level.WARNING, MessageFormat.format("Server error getting attribute {0}: {1}", this.getMRI().getDataPath(), cause), cause);
            }
        }
        catch (AttributeNotFoundException e) {
            this.m_refreshProblem = NLS.bind((String)Messages.ReadOnlyMRIAttribute_PROBLEM_ATTRIBUTE_NOT_FOUND, (Object)this.getMRI().getDataPath());
            RJMXUIPlugin.getDefault().getLogger().log(Level.INFO, MessageFormat.format("Error getting attribute {0}: {1}", this.getMRI().getDataPath(), e.getMessage()));
        }
        catch (Exception e) {
            this.m_refreshProblem = String.valueOf(NLS.bind((String)Messages.ReadOnlyMRIAttribute_PROBLEM_EXCEPTION, (Object)this.getMRI().getDataPath(), (Object)e.getMessage())) + "\n" + Messages.ReadOnlyMRIAttribute_STACK_TRACE_IN_LOG;
            RJMXUIPlugin.getDefault().getLogger().log(Level.WARNING, MessageFormat.format("Error getting attribute {0}: {1}", this.getMRI().getDataPath(), e.getMessage()), e);
        }
        this.m_value = MRIValueEvent.UNAVAILABLE_VALUE;
        return false;
    }

    public Object getValue() {
        return this.m_value;
    }

    protected IMBeanHelperService getMBeanHelperService() throws ConnectionException, ServiceNotAvailableException {
        return (IMBeanHelperService)this.m_handle.getServiceOrThrow(IMBeanHelperService.class);
    }

    public void updateValue(Object value) {
        this.m_value = value;
    }

    public MRI getMRI() {
        return this.m_mri;
    }

    public IUnit getUnit() {
        return ExtendedMRIMetadataToolkit.getUnit((IConnectionHandle)this.m_handle, (MRI)this.m_mri);
    }

    protected IConnectionHandle getHandle() {
        return this.m_handle;
    }

    public int getUpdateInterval() {
        IUpdatePolicy updatePolicy = UpdatePolicyToolkit.getUpdatePolicy((IConnectionHandle)this.m_handle, (MRI)this.m_mri);
        if (updatePolicy instanceof OneShotUpdatePolicy) {
            return 0;
        }
        if (updatePolicy instanceof SimpleUpdatePolicy) {
            return ((SimpleUpdatePolicy)updatePolicy).getIntervalTime();
        }
        return -1;
    }

    private static IUpdatePolicy convertToUpdatePolicy(int interval) {
        switch (interval) {
            case 0: {
                return OneShotUpdatePolicy.newPolicy();
            }
            case -1: {
                return DefaultUpdatePolicy.newPolicy();
            }
        }
        return SimpleUpdatePolicy.newPolicy((int)interval);
    }

    public void setUpdateInterval(int interval) {
        UpdatePolicyToolkit.setUpdatePolicy((IConnectionHandle)this.m_handle, (MRI)this.m_mri, (IUpdatePolicy)ReadOnlyMRIAttribute.convertToUpdatePolicy(interval));
    }

    public boolean equals(Object that) {
        return that instanceof ReadOnlyMRIAttribute ? this.getMRI().equals((Object)((ReadOnlyMRIAttribute)((Object)that)).getMRI()) : false;
    }

    public int hashCode() {
        return this.getMRI().hashCode();
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + '{' + this.getMRI() + ',' + this.getValue() + '}';
    }

    public static void refresh(IConnectionHandle connection, Map<MRI, ReadOnlyMRIAttribute> attributeMap) {
        try {
            MBeanServerConnection server = (MBeanServerConnection)connection.getServiceOrThrow(MBeanServerConnection.class);
            Map attributes = AttributeValueToolkit.getAttributes((MBeanServerConnection)server, attributeMap.keySet());
            for (Map.Entry value : attributes.entrySet()) {
                attributeMap.remove(value.getKey()).updateValue(value.getValue());
            }
        }
        catch (ConnectionException connectionException) {
            RJMXUIPlugin.getDefault().getLogger().log(Level.INFO, "Could not refresh attributes since the connection was closed");
            return;
        }
        catch (Exception e) {
            RJMXUIPlugin.getDefault().getLogger().log(Level.WARNING, "Error getting attributes: " + e.getMessage());
        }
        for (ReadOnlyMRIAttribute attribute : attributeMap.values()) {
            attribute.refresh();
        }
    }

    private static Throwable unmarshalMBeanException(MBeanException e) {
        Throwable cause = e.getTargetException();
        if (cause instanceof RuntimeErrorException) {
            cause = ((RuntimeErrorException)cause).getTargetError();
        } else if (cause instanceof RuntimeMBeanException) {
            cause = ((RuntimeMBeanException)cause).getTargetException();
        }
        return cause;
    }

    public String getRefreshProblem() {
        return this.m_refreshProblem;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return MRI.class.equals(adapter) ? (T)adapter.cast(this.m_mri) : null;
    }
}

