/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.internal;

import java.lang.reflect.Array;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.openjdk.jmc.rjmx.services.IAttribute;
import org.openjdk.jmc.rjmx.services.IIndexedAttributeChild;
import org.openjdk.jmc.rjmx.ui.internal.AbstractArrayElementMenuAction;
import org.openjdk.jmc.rjmx.ui.messages.internal.Messages;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.IColumn;

public class RemoveArrayElementMenuAction
extends AbstractArrayElementMenuAction {
    protected RemoveArrayElementMenuAction(IMenuManager mm, ColumnManager columnsManager, IColumn column) {
        super(Messages.REMOVE_ARRAY_ELEMENT_ACTION, mm, columnsManager, column);
    }

    @Override
    protected void run(IIndexedAttributeChild selectedElement) {
        IAttribute parent = (IAttribute)selectedElement.getParent();
        Object array = parent.getValue();
        Object newArray = Array.newInstance(array.getClass().getComponentType(), Array.getLength(array) - 1);
        if (selectedElement.getIndex() > 0) {
            System.arraycopy(array, 0, newArray, 0, selectedElement.getIndex());
        }
        if (selectedElement.getIndex() < Array.getLength(array) - 1) {
            System.arraycopy(array, selectedElement.getIndex() + 1, newArray, selectedElement.getIndex(), Array.getLength(array) - selectedElement.getIndex() - 1);
        }
        parent.setValue(newArray);
    }

    public static ActionContributionItem createRemoveArrayElementMenuActionContribution(IMenuManager mm, ColumnManager columnsManager, IColumn column) {
        return new RemoveArrayElementMenuAction(mm, columnsManager, column).getActionContribution();
    }
}

