/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.manager.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.openjdk.jmc.console.agent.manager.model.ICapturedValue;
import org.openjdk.jmc.console.agent.manager.model.IEvent;
import org.openjdk.jmc.console.agent.manager.model.IMethodParameter;
import org.openjdk.jmc.console.agent.manager.model.IMethodReturnValue;
import org.openjdk.jmc.console.agent.manager.model.MethodParameter;
import org.openjdk.jmc.console.agent.manager.model.MethodReturnValue;
import org.openjdk.jmc.console.agent.manager.wizards.CapturedValueEditingPage;
import org.openjdk.jmc.console.agent.messages.internal.Messages;
import org.openjdk.jmc.console.agent.wizards.BaseWizardPage;
import org.openjdk.jmc.ui.misc.AbstractStructuredContentProvider;
import org.openjdk.jmc.ui.misc.DialogToolkit;
import org.openjdk.jmc.ui.wizards.OnePageWizardDialog;

public class EventEditingWizardParameterPage
extends BaseWizardPage {
    private final IEvent event;
    private BaseWizardPage.TableInspector tableInspector;

    protected EventEditingWizardParameterPage(IEvent event) {
        super(Messages.EventEditingWizardParameterPage_PAGE_NAME);
        this.event = event;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.setTitle(Messages.EventEditingWizardParameterPage_MESSAGE_EVENT_EDITING_WIZARD_PARAMETER_PAGE_TITLE);
        this.setDescription(Messages.EventEditingWizardParameterPage_MESSAGE_EVENT_EDITING_WIZARD_PARAMETER_PAGE_DESCRIPTION);
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        Composite container = new Composite((Composite)sc, 0);
        sc.setContent((Control)container);
        container.setLayout((Layout)new FillLayout());
        this.createFieldTableContainer(container);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(container.computeSize(-1, -1));
        this.setControl((Control)sc);
        this.populateUi();
    }

    private Composite createFieldTableContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        this.tableInspector = new BaseWizardPage.TableInspector(container, 47){

            @Override
            protected void addColumns() {
                this.addColumn(Messages.EventEditingWizardParameterPage_LABEL_INDEX, Messages.EventEditingWizardParameterPage_ID_INDEX, new ParameterTableLabelProvider(){

                    @Override
                    protected String doGetText(ICapturedValue parameter) {
                        if (parameter instanceof IMethodReturnValue) {
                            return Messages.EventEditingWizardParameterPage_MESSAGE_RETURN_VALUE;
                        }
                        if (parameter instanceof IMethodParameter) {
                            return String.valueOf(((IMethodParameter)parameter).getIndex());
                        }
                        throw new IllegalArgumentException("element must be a an IMethodParameter or IMethodReturnValue");
                    }
                });
                this.addColumn(Messages.EventEditingWizardParameterPage_LABEL_NAME, Messages.EventEditingWizardParameterPage_ID_NAME, new ParameterTableLabelProvider(){

                    @Override
                    protected String doGetText(ICapturedValue parameter) {
                        return parameter.getName();
                    }
                });
                this.addColumn(Messages.EventEditingWizardParameterPage_LABEL_DESCRIPTION, Messages.EventEditingWizardParameterPage_ID_DESCRIPTION, new ParameterTableLabelProvider(){

                    @Override
                    protected String doGetText(ICapturedValue parameter) {
                        return parameter.getDescription();
                    }
                });
            }

            @Override
            protected void onAddButtonSelected(IStructuredSelection selection) {
                IMethodParameter parameter = EventEditingWizardParameterPage.this.event.createMethodParameter();
                CapturedValueEditingPage page = new CapturedValueEditingPage(EventEditingWizardParameterPage.this.event, parameter);
                while (new OnePageWizardDialog(Display.getCurrent().getActiveShell(), (IWizardPage)page).open() == 0) {
                    try {
                        ICapturedValue capturedValue = page.getResult();
                        if (capturedValue instanceof IMethodParameter) {
                            EventEditingWizardParameterPage.this.event.addMethodParameter((IMethodParameter)capturedValue);
                            break;
                        }
                        EventEditingWizardParameterPage.this.event.setMethodReturnValue((IMethodReturnValue)capturedValue);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        if (!DialogToolkit.openConfirmOnUiThread((String)Messages.EventEditingWizardParameterPage_MESSAGE_UNABLE_TO_SAVE_THE_PARAMETER_OR_RETURN_VALUE, (String)e.getMessage())) break;
                    }
                }
                EventEditingWizardParameterPage.this.tableInspector.getViewer().refresh();
            }

            @Override
            protected void onEditButtonSelected(IStructuredSelection selection) {
                ICapturedValue original = (ICapturedValue)selection.getFirstElement();
                ICapturedValue workingCopy = original instanceof IMethodParameter ? ((IMethodParameter)original).createWorkingCopy() : ((IMethodReturnValue)original).createWorkingCopy();
                CapturedValueEditingPage page = new CapturedValueEditingPage(EventEditingWizardParameterPage.this.event, workingCopy);
                if (new OnePageWizardDialog(Display.getCurrent().getActiveShell(), (IWizardPage)page).open() == 0) {
                    ICapturedValue modified = page.getResult();
                    if (original instanceof IMethodParameter) {
                        EventEditingWizardParameterPage.this.event.removeMethodParameter((IMethodParameter)original);
                    } else {
                        EventEditingWizardParameterPage.this.event.setMethodReturnValue(null);
                    }
                    if (modified instanceof IMethodParameter) {
                        EventEditingWizardParameterPage.this.event.addMethodParameter((IMethodParameter)modified);
                    } else {
                        EventEditingWizardParameterPage.this.event.setMethodReturnValue((IMethodReturnValue)modified);
                    }
                }
                EventEditingWizardParameterPage.this.tableInspector.getViewer().refresh();
            }

            @Override
            protected void onRemoveButtonSelected(IStructuredSelection selection) {
                for (Object value : selection) {
                    ICapturedValue capturedValue = (ICapturedValue)value;
                    if (capturedValue instanceof MethodParameter) {
                        EventEditingWizardParameterPage.this.event.removeMethodParameter((MethodParameter)capturedValue);
                        continue;
                    }
                    if (!(capturedValue instanceof MethodReturnValue)) continue;
                    EventEditingWizardParameterPage.this.event.setMethodReturnValue(null);
                }
                EventEditingWizardParameterPage.this.tableInspector.getViewer().refresh();
            }
        };
        this.tableInspector.setContentProvider((IContentProvider)new ParameterTableContentProvider());
        return container;
    }

    private void populateUi() {
        this.tableInspector.setInput(this.event);
    }

    private static class ParameterTableContentProvider
    extends AbstractStructuredContentProvider {
        private ParameterTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (!(inputElement instanceof IEvent)) {
                throw new IllegalArgumentException("input element must be an IEvent");
            }
            IEvent event = (IEvent)inputElement;
            Object[] parameters = event.getMethodParameters();
            if (event.getMethodReturnValue() == null) {
                return parameters;
            }
            ArrayList<Object> capturedValues = new ArrayList<Object>(Arrays.asList(parameters));
            capturedValues.add(event.getMethodReturnValue());
            return capturedValues.toArray(new ICapturedValue[0]);
        }
    }

    private static abstract class ParameterTableLabelProvider
    extends ColumnLabelProvider {
        private ParameterTableLabelProvider() {
        }

        public String getText(Object element) {
            if (!(element instanceof IMethodParameter) && !(element instanceof IMethodReturnValue)) {
                throw new IllegalArgumentException("element must be a an IMethodParameter or IMethodReturnValue");
            }
            return this.doGetText((ICapturedValue)element);
        }

        protected abstract String doGetText(ICapturedValue var1);
    }
}

