/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.utils;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.openjdk.jmc.console.agent.utils.ValidationResult;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class ProbeValidator
extends Validator {
    private final Validator validator;
    private ValidationResult validationResult = new ValidationResult();
    private static final String PROBE_SCHEMA_XSD = "jfrprobes_schema.xsd";
    private static final Schema PROBE_SCHEMA;

    static {
        try {
            Throwable throwable = null;
            Object var1_4 = null;
            try (InputStream is = ProbeValidator.class.getResourceAsStream(PROBE_SCHEMA_XSD);){
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                PROBE_SCHEMA = factory.newSchema(new StreamSource(is));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SAXException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (IOException ie) {
            throw new ExceptionInInitializerError(ie);
        }
    }

    public ProbeValidator() {
        this.validator = PROBE_SCHEMA.newValidator();
        try {
            this.validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            this.validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new RuntimeException(e);
        }
        this.validator.setErrorHandler(new ProbeValidatorErrorHandler());
    }

    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    @Override
    public void reset() {
        this.validationResult = new ValidationResult();
        this.validator.reset();
    }

    @Override
    public void validate(Source source, Result result) throws SAXException, IOException {
        this.validator.validate(source, result);
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        throw new UnsupportedOperationException("setErrorHandler is unsupported");
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.validator.getErrorHandler();
    }

    @Override
    public void setResourceResolver(LSResourceResolver resourceResolver) {
        this.validator.setResourceResolver(resourceResolver);
    }

    @Override
    public LSResourceResolver getResourceResolver() {
        return this.validator.getResourceResolver();
    }

    private class ProbeValidatorErrorHandler
    implements ErrorHandler {
        private ProbeValidatorErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            ProbeValidator.this.validationResult.addWarning(exception);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            ProbeValidator.this.validationResult.addError(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            ProbeValidator.this.validationResult.setFatalError(exception);
        }
    }
}

