/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class IncreasingMetaspaceLiveSetRule
implements IRule {
    private static final String RESULT_ID = "IncreasingMetaSpaceLiveSet";
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.MetaspaceSummary", RulesToolkit.EventAvailability.ENABLED).build();
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE);

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        IItemFilter afterFilter = ItemFilters.and((IItemFilter[])new IItemFilter[]{JdkFilters.METASPACE_SUMMARY_AFTER_GC, JdkFilters.AFTER_GC});
        Iterator allAfterItems = items.apply(afterFilter).iterator();
        if (allAfterItems.hasNext()) {
            IItemIterable afterItems = (IItemIterable)allAfterItems.next();
            IMemberAccessor timeAccessor = JfrAttributes.END_TIME.getAccessor(afterItems.getType());
            IMemberAccessor memAccessor = JdkAttributes.GC_METASPACE_USED.getAccessor(afterItems.getType());
            double leastSquare = RulesToolkit.leastSquareMemory((Iterator)afterItems.iterator(), (IMemberAccessor)timeAccessor, (IMemberAccessor)memAccessor);
            double score = RulesToolkit.mapExp100((double)leastSquare, (double)0.75);
            if (score >= 25.0) {
                return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.get((double)score)).setSummary(Messages.getString("IncreasingMetaspaceLiveSetRuleFactory_TEXT_INFO")).setExplanation(Messages.getString("IncreasingMetaspaceLiveSetRuleFactory_TEXT_INFO_LONG")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).build();
            }
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.get((double)score)).setSummary(Messages.getString("IncreasingMetaspaceLiveSetRuleFactory_TEXT_OK")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("IncreasingMetaspaceLiveSetRuleFactory_TEXT_OK")).build();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return IncreasingMetaspaceLiveSetRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("IncreasingMetaspaceLiveSetRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "garbage_collection";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

