/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.services.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.services.IDummyService;
import org.openjdk.jmc.rjmx.services.IServiceFactory;
import org.openjdk.jmc.rjmx.services.internal.ServiceEntry;

public class ServiceFactoryManager {
    private static final String EXTENSION_POINT = "org.openjdk.jmc.rjmx.service";
    private static final String EXTENSION_ELEMENT_SERVICE = "service";
    private static final String EXTENSION_ATTRIBUTE_FACTORY = "factory";
    private static final String EXTENSION_ATTRIBUTE_NAME = "name";
    private static final String EXTENSION_ATTRIBUTE_DESCRIPTION = "description";
    private static final Map<Class<?>, Collection<? extends ServiceEntry<?>>> factoryMap = new HashMap();

    public ServiceFactoryManager() {
        this.initializeFromExtensions();
    }

    private Logger getLogger() {
        return RJMXPlugin.getDefault().getLogger();
    }

    public static <T> T createDummyService(Class<T> serviceInterface, Throwable cause) {
        Class[] interfaces = new Class[]{serviceInterface, IDummyService.class};
        ClassLoader cl = serviceInterface.getClassLoader();
        return (T)Proxy.newProxyInstance(cl == null ? IDummyService.class.getClassLoader() : cl, interfaces, (InvocationHandler)new UnsupportedInvocationHandler(cause));
    }

    public <T> T createService(Class<T> serviceClass, IConnectionHandle handle) {
        T firstDummyService = null;
        Exception firstException = null;
        for (ServiceEntry<T> entry : this.getFactoriesFor(serviceClass)) {
            try {
                T service = entry.getServiceFactory().getServiceInstance(handle);
                if (service == null) continue;
                if (!ServiceFactoryManager.isDummy(service)) {
                    return service;
                }
                if (firstDummyService != null) continue;
                firstDummyService = service;
            }
            catch (Exception e) {
                if (firstException == null) {
                    firstException = e;
                }
                this.getLogger().log(Level.FINE, "Could not create service!", e);
            }
        }
        if (firstDummyService == null && firstException != null && serviceClass.isInterface()) {
            try {
                firstDummyService = ServiceFactoryManager.createDummyService(serviceClass, firstException);
            }
            catch (Exception e) {
                this.getLogger().log(Level.FINE, "Could not create dummy service to wrap exception!", e);
            }
        }
        return firstDummyService;
    }

    public static boolean isDummy(Object service) {
        return service instanceof IDummyService;
    }

    private <T> Collection<ServiceEntry<T>> getFactoriesFor(Class<T> clazz) {
        Collection<ServiceEntry<T>> factories = factoryMap.get(clazz);
        if (factories == null) {
            factories = Collections.emptyList();
        }
        return factories;
    }

    private void initializeFromExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            if (config.getName().equals(EXTENSION_ELEMENT_SERVICE)) {
                try {
                    IServiceFactory factory = (IServiceFactory)config.createExecutableExtension(EXTENSION_ATTRIBUTE_FACTORY);
                    this.registerService(this.createServiceEntry(factory, config));
                }
                catch (CoreException e) {
                    this.getLogger().log(Level.SEVERE, "Could not instantiate service factory!", e);
                }
            }
            ++n2;
        }
    }

    private <T> void registerService(ServiceEntry<T> entry) {
        Collection<Object> factories;
        Class<T> serviceClass = entry.getServiceClass();
        if (factoryMap.containsKey(serviceClass)) {
            factories = this.getFactoriesFor(entry.getServiceClass());
        } else {
            factories = new ArrayList();
            factoryMap.put(entry.getServiceClass(), factories);
        }
        factories.add(entry);
    }

    private <T> ServiceEntry<T> createServiceEntry(IServiceFactory<T> factory, IConfigurationElement config) {
        String name = config.getAttribute(EXTENSION_ATTRIBUTE_NAME);
        String description = config.getAttribute(EXTENSION_ATTRIBUTE_DESCRIPTION);
        return new ServiceEntry<T>(factory, name, description);
    }

    private static class UnsupportedInvocationHandler
    implements InvocationHandler {
        private final Throwable cause;

        public UnsupportedInvocationHandler(Throwable cause) {
            this.cause = cause;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String msg = this.cause != null && this.cause.getMessage() != null ? this.cause.getMessage() : "Does not support method " + method.getName();
            throw new UnsupportedOperationException(msg, this.cause);
        }
    }
}

