/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rcp.application;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;
import org.openjdk.jmc.rcp.application.Messages;
import org.openjdk.jmc.rcp.application.actions.OpenFileAction;
import org.openjdk.jmc.rcp.application.scripting.ShellViewCoommand;
import org.openjdk.jmc.ui.common.util.Environment;
import org.openjdk.jmc.ui.handlers.ExternalUrlAction;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private static final String FORUM_URL = "https://community.oracle.com/community/java/java_hotspot_virtual_machine/java_mission_control";
    private static final String OTN_URL = "http://www.oracle.com/missioncontrol";
    private ActionFactory.IWorkbenchAction exitAction;
    private ActionFactory.IWorkbenchAction preferenceAction;
    private ActionFactory.IWorkbenchAction aboutAction;
    private ActionFactory.IWorkbenchAction closeAction;
    private ActionFactory.IWorkbenchAction closeAllAction;
    private ActionFactory.IWorkbenchAction saveAction;
    private ActionFactory.IWorkbenchAction saveAsAction;
    private ActionFactory.IWorkbenchAction introAction;
    private ActionFactory.IWorkbenchAction helpAction;
    private ActionFactory.IWorkbenchAction helpSearchAction;
    private ActionFactory.IWorkbenchAction dynamicHelpAction;
    private OpenFileAction openAction;
    private ActionFactory.IWorkbenchAction backwardAction;
    private ActionFactory.IWorkbenchAction forwardAction;

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.openAction = new OpenFileAction(window);
        this.openAction.setActionDefinitionId("org.openjdk.jmc.rcp.application.file.open");
        this.saveAction = ActionFactory.SAVE.create(window);
        this.saveAsAction = ActionFactory.SAVE_AS.create(window);
        this.closeAction = ActionFactory.CLOSE.create(window);
        this.register((IAction)this.closeAction);
        this.closeAllAction = ActionFactory.CLOSE_ALL.create(window);
        this.register((IAction)this.closeAction);
        if (Environment.getOSType() != Environment.OSType.MAC) {
            this.preferenceAction = ActionFactory.PREFERENCES.create(window);
            this.register((IAction)this.preferenceAction);
        }
        this.aboutAction = ActionFactory.ABOUT.create(window);
        this.register((IAction)this.aboutAction);
        this.exitAction = ActionFactory.QUIT.create(window);
        this.register((IAction)this.exitAction);
        if (Platform.getProduct() != null) {
            this.introAction = ActionFactory.INTRO.create(window);
            this.register((IAction)this.introAction);
        }
        this.register((IAction)new ShellViewCoommand());
        this.helpAction = ActionFactory.HELP_CONTENTS.create(window);
        this.helpAction.setText(Messages.ApplicationActionBarAdvisor_MENU_ITEM_HELP_TEXT);
        this.helpSearchAction = ActionFactory.HELP_SEARCH.create(window);
        this.register((IAction)this.helpSearchAction);
        this.dynamicHelpAction = ActionFactory.DYNAMIC_HELP.create(window);
        this.register((IAction)this.dynamicHelpAction);
        this.backwardAction = ActionFactory.BACKWARD_HISTORY.create(window);
        this.backwardAction.setId("org.eclipse.ui.navigate.backwardHistory");
        this.register((IAction)this.backwardAction);
        this.forwardAction = ActionFactory.FORWARD_HISTORY.create(window);
        this.forwardAction.setId("org.eclipse.ui.navigate.forwardHistory");
        this.register((IAction)this.forwardAction);
    }

    private void createDebug(IMenuManager manager) {
        MenuManager menu = new MenuManager(Messages.ApplicationActionBarAdvisor_MENU_DEBUG_TEXT, "mcdebug");
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.setVisible(Environment.isDebug());
        manager.add((IContributionItem)menu);
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        IWorkbenchWindow window = this.getActionBarConfigurer().getWindowConfigurer().getWindow();
        menuBar.add((IContributionItem)this.createFileMenu(window));
        menuBar.add((IContributionItem)this.createEditMenu(window));
        menuBar.add((IContributionItem)this.createNavigateMenu(window));
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        menuBar.add((IContributionItem)this.createWindowMenu(window));
        menuBar.add((IContributionItem)this.createHelpMenu(window));
    }

    private MenuManager createHelpMenu(IWorkbenchWindow window) {
        MenuManager helpMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_MENU_HELP_TEXT, "help");
        if (this.introAction != null) {
            helpMenu.add((IAction)this.introAction);
            helpMenu.add((IContributionItem)new Separator());
        }
        helpMenu.add((IAction)this.helpAction);
        helpMenu.add((IAction)this.helpSearchAction);
        helpMenu.add((IAction)this.dynamicHelpAction);
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IContributionItem)new GroupMarker("helpStart"));
        helpMenu.add((IContributionItem)new GroupMarker("helpEnd"));
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IAction)new ExternalUrlAction(OTN_URL, Messages.ApplicationActionBarAdvisor_MENU_ITEM_OTN_TEXT));
        helpMenu.add((IAction)new ExternalUrlAction(FORUM_URL, Messages.ApplicationActionBarAdvisor_MENU_ITEM_FORUM_TEXT));
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IContributionItem)new GroupMarker("additions"));
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IAction)this.aboutAction);
        return helpMenu;
    }

    private MenuManager createWindowMenu(IWorkbenchWindow window) {
        MenuManager windowMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_MENU_WINDOW_TEXT, "window");
        windowMenu.add((IContributionItem)new GroupMarker("additions"));
        windowMenu.add((IContributionItem)new GroupMarker("mcadditions"));
        windowMenu.add((IContributionItem)new Separator());
        windowMenu.add((IContributionItem)this.createViewMenu(window));
        windowMenu.add(this.createPerspectiveMenu(window));
        windowMenu.add((IContributionItem)new Separator());
        windowMenu.add((IAction)ActionFactory.RESET_PERSPECTIVE.create(window));
        if (Environment.getOSType() != Environment.OSType.MAC) {
            windowMenu.add((IContributionItem)new Separator());
            windowMenu.add((IAction)this.preferenceAction);
        }
        return windowMenu;
    }

    private MenuManager createEditMenu(IWorkbenchWindow window) {
        MenuManager menu = new MenuManager(Messages.ApplicationActionBarAdvisor_MENU_EDIT_TEXT, "edit");
        menu.add((IContributionItem)new GroupMarker("editStart"));
        menu.add(ApplicationActionBarAdvisor.createItem((IServiceLocator)window, "org.eclipse.ui.edit.cut"));
        menu.add(ApplicationActionBarAdvisor.createItem((IServiceLocator)window, "org.eclipse.ui.edit.copy"));
        menu.add(ApplicationActionBarAdvisor.createItem((IServiceLocator)window, "org.eclipse.ui.edit.paste"));
        menu.add((IContributionItem)new Separator());
        menu.add(ApplicationActionBarAdvisor.createItem((IServiceLocator)window, "org.eclipse.ui.edit.delete"));
        menu.add(ApplicationActionBarAdvisor.createItem((IServiceLocator)window, "org.eclipse.ui.edit.selectAll"));
        menu.add((IContributionItem)new GroupMarker("editEnd"));
        if (menu.indexOf("find.ext") == -1) {
            menu.add((IContributionItem)new GroupMarker("find.ext"));
        }
        return menu;
    }

    private static IContributionItem createItem(IServiceLocator sl, String commandId) {
        return new CommandContributionItem(new CommandContributionItemParameter(sl, commandId, commandId, 8));
    }

    private IContributionItem createPerspectiveMenu(IWorkbenchWindow window) {
        MenuManager perspectiveMenuMgr = new MenuManager(Messages.ApplicationActionBarAdvisor_SHOW_PERSPECTIVE_MENU_TEXT, "showPerspective");
        IContributionItem perspectiveMenu = ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(window);
        perspectiveMenuMgr.add(perspectiveMenu);
        return perspectiveMenuMgr;
    }

    private MenuManager createViewMenu(IWorkbenchWindow window) {
        MenuManager showViewMenuMgr = new MenuManager(Messages.ApplicationActionBarAdvisor_SHOW_VIEW_MENU_TEXT, "showView");
        IContributionItem showViewMenu = ContributionItemFactory.VIEWS_SHORTLIST.create(window);
        showViewMenuMgr.add(showViewMenu);
        return showViewMenuMgr;
    }

    private MenuManager createFileMenu(IWorkbenchWindow window) {
        MenuManager menu = new MenuManager(Messages.ApplicationActionBarAdvisor_MENU_FILE_TEXT, "file");
        menu.add((IContributionItem)new GroupMarker("fileStart"));
        String newText = Messages.ApplicationActionBarAdvisor_MENU_NEW_TEXT;
        String newId = ActionFactory.NEW.getId();
        MenuManager newMenu = new MenuManager(newText, newId);
        newMenu.add((IContributionItem)new Separator(newId));
        newMenu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IContributionItem)newMenu);
        menu.add((IAction)this.openAction);
        menu.add((IAction)this.saveAction);
        menu.add((IAction)this.saveAsAction);
        this.createDebug((IMenuManager)menu);
        menu.add((IContributionItem)new GroupMarker("new.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.closeAction);
        menu.add((IAction)this.closeAllAction);
        menu.add((IContributionItem)new GroupMarker("close.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)ActionFactory.EXPORT.create(window));
        menu.add((IAction)ActionFactory.IMPORT.create(window));
        menu.add((IContributionItem)new GroupMarker("import.ext"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator());
        MenuManager recentMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_MENU_RECENT_FILES_TEXT, ContributionItemFactory.REOPEN_EDITORS.getId());
        recentMenu.add(ContributionItemFactory.REOPEN_EDITORS.create(window));
        recentMenu.add((IContributionItem)new GroupMarker("mru"));
        menu.add((IContributionItem)recentMenu);
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction(ActionFactory.QUIT.getId()));
        menu.add((IContributionItem)new GroupMarker("fileEnd"));
        return menu;
    }

    private MenuManager createNavigateMenu(IWorkbenchWindow window) {
        MenuManager menu = new MenuManager(Messages.ApplicationActionBarAdvisor_MENU_NAVIGATE_TEXT, "navigate");
        menu.add((IAction)this.backwardAction);
        menu.add((IAction)this.forwardAction);
        return menu;
    }
}

