/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.internal;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.management.MBeanServerConnection;
import org.openjdk.jmc.rjmx.ConnectionException;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.IConnectionListener;
import org.openjdk.jmc.rjmx.IServerDescriptor;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.ServiceNotAvailableException;
import org.openjdk.jmc.rjmx.internal.IDisposableService;
import org.openjdk.jmc.rjmx.internal.RJMXConnection;
import org.openjdk.jmc.rjmx.services.internal.ServiceFactoryManager;
import org.openjdk.jmc.rjmx.subscription.IMBeanHelperService;
import org.openjdk.jmc.rjmx.subscription.IMRIService;

public class DefaultConnectionHandle
implements IConnectionHandle {
    private final Map<Class<?>, Object> services = Collections.synchronizedMap(new LinkedHashMap());
    private final String description;
    private final RJMXConnection connection;
    private final IConnectionListener[] listeners;
    private static final ServiceFactoryManager FACTORY_MANAGER = new ServiceFactoryManager();
    private volatile Long closeDownThreadId;

    public DefaultConnectionHandle(RJMXConnection connection, String description, IConnectionListener[] listeners) {
        this.connection = connection;
        this.description = description;
        this.listeners = listeners == null ? new IConnectionListener[]{} : listeners;
        this.registerDefaultServices();
    }

    @Override
    public IServerDescriptor getServerDescriptor() {
        return this.connection.getServerDescriptor();
    }

    @Override
    public boolean isConnected() {
        return this.isOpen() && this.connection.isConnected();
    }

    private boolean isOpen() {
        return this.closeDownThreadId == null || Thread.currentThread().getId() == this.closeDownThreadId.longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Map<Class<?>, Object> map = this.services;
        synchronized (map) {
            if (this.closeDownThreadId != null) {
                return;
            }
            this.closeDownThreadId = Thread.currentThread().getId();
            this.shutdownServices();
            this.closeDownThreadId = -1L;
        }
        IConnectionListener[] iConnectionListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionListener l = iConnectionListenerArray[n2];
            try {
                l.onConnectionChange(this);
            }
            catch (Exception e) {
                RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "DefaultConnectionHandle listener " + l + " failed", e);
            }
            ++n2;
        }
    }

    private void shutdownServices() {
        Object[] servicesArray = this.services.values().toArray();
        int i = 0;
        while (i < servicesArray.length) {
            Object service = servicesArray[servicesArray.length - i - 1];
            if (service instanceof IDisposableService) {
                try {
                    ((IDisposableService)service).dispose();
                }
                catch (RuntimeException e) {
                    RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not shut down the " + service.getClass().getName() + " service.", e);
                }
            }
            ++i;
        }
        this.services.clear();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public String toString() {
        return String.valueOf(this.description) + " - " + this.connection.toString();
    }

    @Override
    public <T> T getServiceOrThrow(Class<T> serviceInterface) throws ConnectionException, ServiceNotAvailableException {
        if (this.isOpen()) {
            T service = this.getService(serviceInterface, false);
            if (service != null) {
                return service;
            }
        } else {
            throw new ConnectionException("Connection closed!");
        }
        throw new ServiceNotAvailableException("Service '" + serviceInterface.getName() + "' not available!");
    }

    @Override
    public <T> T getServiceOrDummy(Class<T> serviceInterface) {
        if (!serviceInterface.isInterface()) {
            throw new IllegalArgumentException("Will not be able to create dummy implementations of " + serviceInterface.getName() + " since the service is not an interface");
        }
        if (this.isOpen()) {
            return this.getService(serviceInterface, true);
        }
        return DefaultConnectionHandle.createDummyService(serviceInterface);
    }

    @Override
    public <T> T getServiceOrNull(Class<T> serviceInterface) {
        if (this.isOpen()) {
            return this.getService(serviceInterface, false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getService(Class<T> serviceInterface, boolean acceptDummy) {
        Map<Class<?>, Object> map = this.services;
        synchronized (map) {
            Object service = this.services.get(serviceInterface);
            if (service == null || ServiceFactoryManager.isDummy(service) && !acceptDummy) {
                service = FACTORY_MANAGER.createService(serviceInterface, this);
                if (service == null && acceptDummy) {
                    service = DefaultConnectionHandle.createDummyService(serviceInterface);
                }
                if (service != null) {
                    this.services.put(serviceInterface, service);
                }
            }
            return (T)(acceptDummy || !ServiceFactoryManager.isDummy(service) ? service : null);
        }
    }

    private static <T> T createDummyService(Class<T> serviceInterface) throws IllegalArgumentException {
        return ServiceFactoryManager.createDummyService(serviceInterface, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void registerDefaultServices() {
        Map<Class<?>, Object> map = this.services;
        synchronized (map) {
            this.services.put(MBeanServerConnection.class, this.connection.getMBeanServer());
            this.services.put(IMBeanHelperService.class, this.connection);
            this.services.put(IMRIService.class, this.connection.getMRIService());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasService(Class<?> serviceClass) {
        Map<Class<?>, Object> map = this.services;
        synchronized (map) {
            return this.getServiceOrNull(serviceClass) != null;
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

