/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.subscription.internal;

import java.util.logging.Level;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.modelmbean.ModelMBeanNotificationBroadcaster;
import org.openjdk.jmc.rjmx.ISyntheticNotification;
import org.openjdk.jmc.rjmx.RJMXPlugin;

public abstract class AbstractSyntheticNotification
implements ISyntheticNotification {
    private String m_type;
    private String m_message;
    private long m_sequenceNumber = 0L;
    private ModelMBeanNotificationBroadcaster broadcaster;

    @Override
    public abstract Object getValue();

    protected String getMessage() {
        return this.m_message;
    }

    @Override
    public void stop() {
    }

    protected final void triggerNotification() {
        Object value = this.getValue();
        Notification notification = new Notification(this.m_type, (Object)this, this.m_sequenceNumber++, this.getMessage());
        notification.setUserData(value);
        try {
            this.broadcaster.sendNotification(notification);
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Unable to trigger notification!", e);
        }
    }

    @Override
    public void init(MBeanServerConnection connection, String type, String message) {
        this.m_type = type;
        this.m_message = message;
    }

    @Override
    public final void init(ModelMBeanNotificationBroadcaster broadcaster) {
        this.broadcaster = broadcaster;
    }

    @Override
    public final ModelMBeanNotificationBroadcaster getBroadcaster() {
        return this.broadcaster;
    }
}

