/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.actions;

import java.io.Closeable;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.console.agent.AgentJmxHelper;
import org.openjdk.jmc.console.agent.editor.AgentEditorInput;
import org.openjdk.jmc.console.agent.messages.internal.Messages;
import org.openjdk.jmc.console.agent.wizards.StartAgentWizard;
import org.openjdk.jmc.rjmx.ConnectionException;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.IConnectionListener;
import org.openjdk.jmc.rjmx.IServerHandle;
import org.openjdk.jmc.rjmx.JVMSupportToolkit;
import org.openjdk.jmc.rjmx.actionprovider.IActionFactory;
import org.openjdk.jmc.ui.common.action.Executable;
import org.openjdk.jmc.ui.misc.DialogToolkit;
import org.openjdk.jmc.ui.misc.DisplayToolkit;

public class AgentEditorOpener
implements IActionFactory {
    public Executable createAction(IServerHandle serverHandle) {
        return () -> new ConnectJob(serverHandle).schedule();
    }

    private static final class ConnectJob
    extends Job
    implements IConnectionListener {
        private final IServerHandle serverHandle;
        private IConnectionHandle connectionHandle;
        private AgentJmxHelper helper;

        private ConnectJob(IServerHandle serverHandle) {
            super(Messages.AgentEditorOpener_JOB_NAME);
            this.serverHandle = Objects.requireNonNull(serverHandle);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.helper = new AgentJmxHelper(this.serverHandle);
                this.helper.addConnectionChangedListener(this);
                this.connectionHandle = this.helper.getConnectionHandle();
                IStatus ret = this.doRun(monitor);
                this.helper.removeConnectionChangedListener(this);
                return ret;
            }
            catch (ConnectionException e) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                DialogToolkit.showException((Shell)window.getShell(), (String)Messages.AgentEditorOpener_MESSAGE_COULD_NOT_CONNECT, (Throwable)e);
                return new Status(4, "org.openjdk.jmc.console.agent", 4, NLS.bind((String)Messages.AgentEditorOpener_MESSAGE_COULD_NOT_CONNECT, (Object)this.serverHandle.getServerDescriptor().getDisplayName(), (Object)e.getMessage()), (Throwable)e);
            }
        }

        private IStatus doRun(IProgressMonitor monitor) {
            String[] error = JVMSupportToolkit.checkConsoleSupport((IConnectionHandle)this.connectionHandle);
            if (error.length == 2 && !DialogToolkit.openConfirmOnUiThread((String)error[0], (String)error[1])) {
                return Status.CANCEL_STATUS;
            }
            if (!this.helper.isMXBeanRegistered() && this.helper.isLocalJvm()) {
                DisplayToolkit.safeAsyncExec((Display)Display.getDefault(), () -> {
                    WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)new StartAgentWizard(this.helper)){

                        public void createButtonsForButtonBar(Composite parent) {
                            super.createButtonsForButtonBar(parent);
                            Button finishButton = this.getButton(16);
                            finishButton.setText(Messages.StartAgentWizard_WIZARD_FINISH_BUTTON_TEXT);
                        }
                    };
                    dialog.create();
                    dialog.open();
                });
                return Status.OK_STATUS;
            }
            if (!this.helper.isMXBeanRegistered() && !this.helper.isLocalJvm()) {
                DisplayToolkit.safeAsyncExec((Display)Display.getDefault(), () -> {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    DialogToolkit.showError((Shell)window.getShell(), (String)Messages.AgentEditorOpener_MESSAGE_STARTING_AGENT_ON_REMOTE_JVM_NOT_SUPPORTED, (String)Messages.AgentEditorOpener_MESSAGE_START_AGENT_MANUALLY);
                });
                return Status.OK_STATUS;
            }
            DisplayToolkit.safeAsyncExec((Display)Display.getDefault(), () -> {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                try {
                    AgentEditorInput ei = new AgentEditorInput(this.serverHandle, this.helper.getConnectionHandle(), this.helper);
                    window.getActivePage().openEditor((IEditorInput)ei, "org.openjdk.jmc.console.agent.editor.AgentEditor", true);
                }
                catch (PartInitException e) {
                    DialogToolkit.showException((Shell)window.getShell(), (String)Messages.AgentEditorOpener_MESSAGE_FAILED_TO_OPEN_AGENT_EDITOR, (Throwable)e);
                }
            });
            return Status.OK_STATUS;
        }

        protected void canceling() {
            IOToolkit.closeSilently((Closeable)this.connectionHandle);
        }

        public void onConnectionChange(IConnectionHandle connection) {
            if (this.serverHandle.getState() == IServerHandle.State.DISPOSED) {
                this.cancel();
                return;
            }
        }
    }
}

