/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.editor.sections;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.console.agent.manager.model.ICapturedValue;
import org.openjdk.jmc.console.agent.manager.model.IEvent;
import org.openjdk.jmc.console.agent.manager.model.IField;
import org.openjdk.jmc.console.agent.manager.model.IMethodParameter;
import org.openjdk.jmc.ui.column.ColumnBuilder;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.misc.MCLayoutFactory;
import org.openjdk.jmc.ui.misc.MCSectionPart;

public class EventDetailSection
extends MCSectionPart {
    private static final String SECTION_TITLE = "Event Details";
    private static final String NO_EVENT_SELECTED = "No event selected";
    private static final String HEADER_KEY = "Key";
    private static final String HEADER_VALUE = "Value";
    private final Composite stack;
    private final StackLayout stackLayout;
    private final Composite message;
    private final TreeViewer viewer;

    public EventDetailSection(Composite parent, FormToolkit toolkit) {
        super(parent, toolkit, 256);
        this.getSection().setText(SECTION_TITLE);
        Composite body = this.createSectionBody(MCLayoutFactory.createMarginFreeFormPageLayout());
        this.stack = toolkit.createComposite(body);
        this.stack.setLayoutData((Object)new GridData(4, 4, true, true));
        this.stackLayout = new StackLayout();
        this.stack.setLayout((Layout)this.stackLayout);
        this.message = toolkit.createComposite(this.stack);
        this.message.setLayout((Layout)new GridLayout(1, false));
        toolkit.createLabel(this.message, NO_EVENT_SELECTED).setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        this.viewer = this.createViewer(this.stack, toolkit);
        this.viewer.getControl().setLayoutData(MCLayoutFactory.createFormPageLayoutData((int)-1, (int)-1, (boolean)true, (boolean)true));
        this.stackLayout.topControl = this.message;
    }

    private TreeViewer createViewer(Composite parent, FormToolkit formToolkit) {
        Tree tree = formToolkit.createTree(parent, 68096);
        TreeViewer viewer = new TreeViewer(tree);
        viewer.setContentProvider((IContentProvider)new TreeContentProvider());
        ArrayList<IColumn> columns = new ArrayList<IColumn>();
        columns.add(new ColumnBuilder(HEADER_KEY, HEADER_KEY, new ColumnLabelProvider(){

            public String getText(Object element) {
                Map.Entry entry = (Map.Entry)element;
                return (String)entry.getKey();
            }
        }).build());
        columns.add(new ColumnBuilder(HEADER_VALUE, HEADER_VALUE, new ColumnLabelProvider(){

            public String getText(Object element) {
                Map.Entry entry = (Map.Entry)element;
                return entry.getValue() instanceof String ? (String)entry.getValue() : "";
            }
        }).build());
        ColumnManager.build((TreeViewer)viewer, columns, null);
        return viewer;
    }

    public void setInput(IEvent event) {
        this.viewer.setInput((Object)event);
        this.stackLayout.topControl = event == null ? this.message : this.viewer.getControl();
        this.stack.layout();
    }

    private static class TreeContentProvider
    implements ITreeContentProvider {
        private TreeContentProvider() {
        }

        private Map<String, Object> serializeEvent(IEvent event) {
            HashMap<String, Object> entries = new HashMap<String, Object>();
            entries.put("ID", event.getId());
            entries.put("Name", event.getName());
            entries.put("Class", event.getClazz());
            entries.put("Description", event.getDescription());
            entries.put("Path", event.getPath());
            entries.put("Stack Trace", String.valueOf(event.getStackTrace()));
            entries.put("Rethrow", String.valueOf(event.getRethrow()));
            entries.put("Location", String.valueOf((Object)event.getLocation()));
            entries.put("Method", this.serializeMethod(event));
            entries.put("Fields", this.serializeFields(event));
            return entries;
        }

        private Map<String, Object> serializeFields(IEvent event) {
            HashMap<String, Object> fields = new HashMap<String, Object>();
            int i = 0;
            IField[] iFieldArray = event.getFields();
            int n = iFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                fields.put("[" + i++ + "]", this.serializeField(field));
                ++n2;
            }
            return fields;
        }

        private Map<String, String> serializeField(IField field) {
            Map<String, String> f = this.serializeCapturedValue(field);
            f.put("Expression", field.getExpression());
            return f;
        }

        private Map<String, Object> serializeMethod(IEvent event) {
            HashMap<String, Object> method = new HashMap<String, Object>();
            method.put("Name", event.getMethodName());
            method.put("Descriptor", event.getMethodDescriptor());
            HashMap<String, Map<String, String>> parameters = new HashMap<String, Map<String, String>>();
            int i = 0;
            IMethodParameter[] iMethodParameterArray = event.getMethodParameters();
            int n = iMethodParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodParameter methodParameter = iMethodParameterArray[n2];
                parameters.put("[" + i++ + "]", this.serializeParameter(methodParameter));
                ++n2;
            }
            method.put("Parameters", parameters);
            method.put("Return Value", event.getMethodReturnValue());
            return method;
        }

        private Map<String, String> serializeCapturedValue(ICapturedValue capturedValue) {
            HashMap<String, String> value = new HashMap<String, String>();
            value.put("Name", capturedValue.getName());
            value.put("Description", capturedValue.getDescription());
            value.put("Content Type", String.valueOf((Object)capturedValue.getContentType()));
            value.put("Relation Key", capturedValue.getRelationKey());
            value.put("Converter", capturedValue.getConverter());
            return value;
        }

        private Map<String, String> serializeParameter(IMethodParameter methodParameter) {
            Map<String, String> method = this.serializeCapturedValue(methodParameter);
            method.put("Index", String.valueOf(methodParameter.getIndex()));
            return method;
        }

        public Object[] getElements(Object o) {
            if (o == null) {
                return new Object[0];
            }
            if (!(o instanceof IEvent)) {
                throw new IllegalArgumentException("input element must be an IEvent");
            }
            return this.serializeEvent((IEvent)o).entrySet().toArray(new Map.Entry[0]);
        }

        public Object[] getChildren(Object o) {
            Map.Entry entry = (Map.Entry)o;
            if (entry.getValue() instanceof Map) {
                return ((Map)entry.getValue()).entrySet().toArray(new Map.Entry[0]);
            }
            return new Object[0];
        }

        public Object getParent(Object o) {
            return null;
        }

        public boolean hasChildren(Object o) {
            Map.Entry entry = (Map.Entry)o;
            return entry.getValue() instanceof Map;
        }
    }
}

