/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ext.graphview.graph;

import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.JfrLoaderToolkit;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.stacktrace.graph.GraphModelUtils;
import org.openjdk.jmc.flightrecorder.stacktrace.graph.StacktraceGraphModel;

final class GraphModelTest {
    GraphModelTest() {
    }

    @Test
    void testBuildGraph() throws IOException, CouldNotLoadRecordingException {
        IItemCollection events = JfrLoaderToolkit.loadEvents((InputStream)GraphModelTest.class.getResourceAsStream("hotmethods.jfr"));
        Assert.assertTrue((boolean)events.hasItems());
        IItemCollection executionSamples = events.apply(JdkFilters.EXECUTION_SAMPLE);
        Assert.assertTrue((boolean)executionSamples.hasItems());
        Assert.assertEquals((long)((IQuantity)executionSamples.getAggregate(Aggregators.count())).longValue(), (long)24526L);
        StacktraceGraphModel model = new StacktraceGraphModel(GraphModelUtils.DEFAULT_FRAME_SEPARATOR, executionSamples, null);
        Assert.assertFalse((String)"No nodes!", (boolean)model.getNodes().isEmpty());
        Assert.assertFalse((String)"No edges!", (boolean)model.getEdges().isEmpty());
    }

    public static void main(String[] args) throws IOException, CouldNotLoadRecordingException {
        new GraphModelTest().testBuildGraph();
    }
}

