/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.graphview.views;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.ItemCollectionToolkit;
import org.openjdk.jmc.common.util.Pair;
import org.openjdk.jmc.common.util.StringToolkit;
import org.openjdk.jmc.flightrecorder.serializers.dot.DotSerializer;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.graph.StacktraceGraphModel;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.ui.common.util.AdapterUtil;
import org.openjdk.jmc.ui.misc.DisplayToolkit;

public class GraphView
extends ViewPart
implements ISelectionListener {
    private static final String HTML_PAGE;
    private static final int MODEL_EXECUTOR_THREADS_NUMBER = 3;
    private static final ExecutorService MODEL_EXECUTOR;
    private FrameSeparator frameSeparator;
    private Browser browser;
    private SashForm container;
    private IItemCollection currentItems;
    private volatile ModelState modelState = ModelState.NONE;
    private ModelRebuildRunnable modelRebuildRunnable;
    private int maxNodesRendered = 100;

    static {
        String jsD3 = "jslibs/d3.v6.min.js";
        String jsGraphviz = "jslibs/index.js";
        String wasmGraphviz = "jslibs/graphvizlib.wasm";
        String jsGraphizD3 = "jslibs/d3-graphviz.js";
        String wasmBase64 = GraphView.loadBase64FromFile(wasmGraphviz);
        HTML_PAGE = String.format(GraphView.loadStringFromFile("page.template"), GraphView.loadLibraries(jsD3), GraphView.loadStringFromFile(jsGraphviz, "wasmBinaryFile=\"graphvizlib.wasm\";", "wasmBinaryFile=dataURIPrefix + '" + wasmBase64 + "';"), GraphView.loadLibraries(jsGraphizD3));
        MODEL_EXECUTOR = Executors.newFixedThreadPool(3, new ThreadFactory(){
            private ThreadGroup group = new ThreadGroup("GraphModelCalculationGroup");
            private AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(this.group, r, "GraphModelCalculation-" + this.counter.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        });
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.frameSeparator = new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false);
        IToolBarManager toolBar = site.getActionBars().getToolBarManager();
        toolBar.add((IAction)new NodeThresholdSelection());
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.container = new SashForm(parent, 256);
        this.browser = new Browser((Composite)this.container, 0);
        this.container.setMaximizedControl((Control)this.browser);
        this.browser.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                e.doit = false;
            }
        });
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public void saveState(IMemento memento) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object first = ((IStructuredSelection)selection).getFirstElement();
            IItemCollection items = (IItemCollection)AdapterUtil.getAdapter((Object)first, IItemCollection.class);
            if (items == null) {
                this.triggerRebuildTask(ItemCollectionToolkit.build(Stream.empty()));
            } else if (!items.equals(this.currentItems)) {
                this.triggerRebuildTask(items);
            }
        }
    }

    private void triggerRebuildTask(IItemCollection items) {
        if (this.modelRebuildRunnable != null) {
            this.modelRebuildRunnable.setInvalid();
        }
        this.currentItems = items;
        this.modelState = ModelState.NOT_STARTED;
        this.modelRebuildRunnable = new ModelRebuildRunnable(this, this.frameSeparator, items, this.maxNodesRendered);
        if (!this.modelRebuildRunnable.isInvalid) {
            MODEL_EXECUTOR.execute(this.modelRebuildRunnable);
        }
    }

    private void setModel(IItemCollection items, String dotString) {
        if (ModelState.FINISHED.equals((Object)this.modelState) && items.equals(this.currentItems) && !this.browser.isDisposed()) {
            this.setViewerInput(dotString);
        }
    }

    private void setViewerInput(final String model) {
        this.browser.setText(HTML_PAGE);
        this.browser.addProgressListener((ProgressListener)new ProgressAdapter(){
            private boolean loaded = false;

            public void changed(ProgressEvent event) {
                if (this.loaded) {
                    GraphView.this.browser.removeProgressListener((ProgressListener)this);
                }
            }

            public void completed(ProgressEvent event) {
                GraphView.this.browser.removeProgressListener((ProgressListener)this);
                GraphView.this.browser.execute(String.format("processGraph(`%s`);", model));
                this.loaded = true;
            }
        });
    }

    private static String toDot(StacktraceGraphModel model, int maxNodesRendered) {
        if (model == null) {
            return "\"\"";
        }
        return GraphView.render(model, maxNodesRendered);
    }

    private static String render(StacktraceGraphModel model, int maxNodesRendered) {
        return DotSerializer.toDot((StacktraceGraphModel)model, (int)maxNodesRendered, (Map)DotSerializer.getDefaultConfiguration());
    }

    private static String loadLibraries(String ... libs) {
        if (libs == null || libs.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(2048);
        String[] stringArray = libs;
        int n = libs.length;
        int n2 = 0;
        while (n2 < n) {
            String lib = stringArray[n2];
            builder.append(GraphView.loadStringFromFile(lib));
            builder.append("\n");
            ++n2;
        }
        return builder.toString();
    }

    private static String loadStringFromFile(String fileName) {
        try {
            return StringToolkit.readString((InputStream)GraphView.class.getClassLoader().getResourceAsStream(fileName));
        }
        catch (IOException e) {
            FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, MessageFormat.format("Could not load script \"{0}\",\"{1}\"", fileName, e.getMessage()));
            return "";
        }
    }

    private static String loadStringFromFile(String fileName, String substr, String newSubstr) {
        String content = GraphView.loadStringFromFile(fileName);
        return content.replaceAll(substr, newSubstr);
    }

    private static String loadBase64FromFile(String fileName) {
        try {
            byte[] fileBytes = GraphView.readBytes(GraphView.class.getClassLoader().getResourceAsStream(fileName));
            return Base64.getEncoder().encodeToString(fileBytes);
        }
        catch (IOException e) {
            FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, MessageFormat.format("Could not load resource \"{0}\",\"{1}\"", fileName, e.getMessage()));
            return "";
        }
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(in);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int result = bis.read();
        while (result != -1) {
            buf.write((byte)result);
            result = bis.read();
        }
        return buf.toByteArray();
    }

    private static class ModelRebuildRunnable
    implements Runnable {
        private final GraphView view;
        private final FrameSeparator separator;
        private IItemCollection items;
        private volatile boolean isInvalid;
        private final int maxNodesRendered;

        private ModelRebuildRunnable(GraphView view, FrameSeparator separator, IItemCollection items, int maxNodesRendered) {
            this.view = view;
            this.items = items;
            this.separator = separator;
            this.maxNodesRendered = maxNodesRendered;
        }

        private void setInvalid() {
            this.isInvalid = true;
        }

        @Override
        public void run() {
            this.view.modelState = ModelState.STARTED;
            if (this.isInvalid) {
                return;
            }
            StacktraceGraphModel model = new StacktraceGraphModel(this.separator, this.items, null);
            if (this.isInvalid) {
                return;
            }
            String dotString = GraphView.toDot(model, this.maxNodesRendered);
            if (this.isInvalid) {
                return;
            }
            this.view.modelState = ModelState.FINISHED;
            DisplayToolkit.inDisplayThread().execute(() -> this.view.setModel(this.items, dotString));
        }
    }

    private static enum ModelState {
        NOT_STARTED,
        STARTED,
        FINISHED,
        NONE;

    }

    private class NodeThresholdSelection
    extends Action
    implements IMenuCreator {
        private Menu menu;
        private final List<Pair<String, Integer>> items;

        NodeThresholdSelection() {
            super("Max Nodes", 4);
            this.items = Arrays.asList(new Pair((Object)"100", (Object)100), new Pair((Object)"500", (Object)500), new Pair((Object)"1000", (Object)1000));
            this.setMenuCreator(this);
        }

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            if (this.menu == null) {
                this.menu = new Menu(parent);
                this.populate(this.menu);
            }
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            if (this.menu == null) {
                this.menu = new Menu(parent);
                this.populate(this.menu);
            }
            return this.menu;
        }

        private void populate(Menu menu) {
            for (Pair<String, Integer> item : this.items) {
                ActionContributionItem actionItem = new ActionContributionItem((IAction)new SetNodeThreshold(item, (Integer)item.right == GraphView.this.maxNodesRendered));
                actionItem.fill(menu, -1);
            }
        }
    }

    private class SetNodeThreshold
    extends Action {
        private int value;

        SetNodeThreshold(Pair<String, Integer> item, boolean isSelected) {
            super((String)item.left, 8);
            this.value = (Integer)item.right;
            this.setChecked(isSelected);
        }

        public void run() {
            if (GraphView.this.maxNodesRendered != this.value) {
                GraphView.this.maxNodesRendered = this.value;
                GraphView.this.triggerRebuildTask(GraphView.this.currentItems);
            }
        }
    }
}

