/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.manager.wizards;

import java.io.File;
import java.io.IOException;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.openjdk.jmc.console.agent.AgentPlugin;
import org.openjdk.jmc.console.agent.manager.model.IPreset;
import org.openjdk.jmc.console.agent.manager.model.PresetRepository;
import org.openjdk.jmc.console.agent.manager.wizards.PresetEditingWizard;
import org.openjdk.jmc.console.agent.messages.internal.Messages;
import org.openjdk.jmc.console.agent.wizards.BaseWizardPage;
import org.openjdk.jmc.ui.misc.AbstractStructuredContentProvider;
import org.openjdk.jmc.ui.misc.DialogToolkit;
import org.xml.sax.SAXException;

public class PresetManagerPage
extends BaseWizardPage {
    private static final String ID_PRESET = "preset";
    private static final String PRESET_XML_EXTENSION = "*.xml";
    private final PresetRepository repository;
    private BaseWizardPage.TableInspector tableInspector;

    public PresetManagerPage(PresetRepository repository) {
        super(Messages.PresetManagerPage_PAGE_NAME);
        this.repository = repository;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.setTitle(Messages.PresetManagerPage_MESSAGE_PRESET_MANAGER_PAGE_TITLE);
        this.setDescription(Messages.PresetManagerPage_MESSAGE_PRESET_MANAGER_PAGE_DESCRIPTION);
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        Composite container = new Composite((Composite)sc, 0);
        sc.setContent((Control)container);
        container.setLayout((Layout)new FillLayout());
        this.createPresetTableContainer(container);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(container.computeSize(-1, -1));
        this.setControl((Control)sc);
        this.populateUi();
    }

    private Composite createPresetTableContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        this.tableInspector = new BaseWizardPage.TableInspector(container, 253){

            @Override
            protected void addColumns() {
                this.addColumn(PresetManagerPage.ID_PRESET, new ColumnLabelProvider(){

                    public String getText(Object element) {
                        if (!(element instanceof IPreset)) {
                            throw new IllegalArgumentException("element must be an IPreset");
                        }
                        IPreset preset = (IPreset)element;
                        return String.valueOf(preset.getFileName()) + " - " + preset.getEvents().length + " " + Messages.PresetManagerPage_MESSAGE_EVENTS;
                    }

                    public Image getImage(Object element) {
                        return AgentPlugin.getDefault().getImage("agent.png");
                    }
                });
            }

            @Override
            protected void onAddButtonSelected(IStructuredSelection selection) {
                IPreset preset = PresetManagerPage.this.repository.createPreset();
                while (PresetManagerPage.this.displayWizard(preset)) {
                    try {
                        PresetManagerPage.this.repository.addPreset(preset);
                        break;
                    }
                    catch (IOException | IllegalArgumentException e) {
                        if (!DialogToolkit.openConfirmOnUiThread((String)Messages.PresetManagerPage_MESSAGE_PRESET_MANAGER_UNABLE_TO_SAVE_THE_PRESET, (String)e.getLocalizedMessage())) break;
                    }
                }
                PresetManagerPage.this.tableInspector.getViewer().refresh();
            }

            @Override
            protected void onEditButtonSelected(IStructuredSelection selection) {
                IPreset original = (IPreset)selection.getFirstElement();
                IPreset workingCopy = original.createWorkingCopy();
                while (PresetManagerPage.this.displayWizard(workingCopy)) {
                    try {
                        PresetManagerPage.this.repository.updatePreset(original, workingCopy);
                        break;
                    }
                    catch (IOException | IllegalArgumentException e) {
                        if (!DialogToolkit.openConfirmOnUiThread((String)Messages.PresetManagerPage_MESSAGE_PRESET_MANAGER_UNABLE_TO_SAVE_THE_PRESET, (String)e.getLocalizedMessage())) break;
                    }
                }
                PresetManagerPage.this.tableInspector.getViewer().refresh();
            }

            @Override
            protected void onDuplicateButtonSelected(IStructuredSelection selection) {
                IPreset original = (IPreset)selection.getFirstElement();
                IPreset duplicate = original.createDuplicate();
                try {
                    PresetManagerPage.this.repository.addPreset(duplicate);
                }
                catch (IOException | IllegalArgumentException e) {
                    DialogToolkit.openConfirmOnUiThread((String)Messages.PresetManagerPage_MESSAGE_PRESET_MANAGER_UNABLE_TO_SAVE_THE_PRESET, (String)e.getLocalizedMessage());
                }
                PresetManagerPage.this.tableInspector.getViewer().refresh();
            }

            @Override
            protected void onRemoveButtonSelected(IStructuredSelection selection) {
                for (Object preset : selection) {
                    PresetManagerPage.this.repository.removePreset((IPreset)preset);
                }
                PresetManagerPage.this.tableInspector.getViewer().refresh();
            }

            @Override
            protected void onImportFilesButtonSelected(IStructuredSelection selection) {
                String[] files = PresetManagerPage.this.openFileDialog(Messages.PresetManagerPage_MESSAGE_IMPORT_EXTERNAL_PRESET_FILES, new String[]{PresetManagerPage.PRESET_XML_EXTENSION}, 4098);
                if (files.length != 0) {
                    String[] stringArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String path = stringArray[n2];
                        File file = new File(path);
                        try {
                            PresetManagerPage.this.repository.importPreset(file);
                        }
                        catch (IOException | SAXException e) {
                            DialogToolkit.openConfirmOnUiThread((String)Messages.PresetManagerPage_MESSAGE_PRESET_MANAGER_UNABLE_TO_IMPORT_THE_PRESET, (String)e.getLocalizedMessage());
                        }
                        ++n2;
                    }
                }
                PresetManagerPage.this.tableInspector.getViewer().refresh();
            }

            @Override
            protected void onExportFileButtonSelected(IStructuredSelection selection) {
                String[] files = PresetManagerPage.this.openFileDialog(Messages.PresetManagerPage_MESSAGE_EXPORT_PRESET_TO_A_FILE, new String[]{PresetManagerPage.PRESET_XML_EXTENSION}, 8196);
                if (files.length == 0) {
                    return;
                }
                File file = new File(files[0]);
                try {
                    PresetManagerPage.this.repository.exportPreset((IPreset)selection.getFirstElement(), file);
                }
                catch (IOException e) {
                    DialogToolkit.openConfirmOnUiThread((String)Messages.PresetManagerPage_MESSAGE_PRESET_MANAGER_UNABLE_TO_EXPORT_THE_PRESET, (String)e.getLocalizedMessage());
                }
            }
        };
        this.tableInspector.setContentProvider((IContentProvider)new PresetTableContentProvider());
        return container;
    }

    private void populateUi() {
        this.tableInspector.setInput(this.repository);
    }

    private boolean displayWizard(IPreset preset) {
        PresetEditingWizard wizard = new PresetEditingWizard(preset);
        wizard.setHelpAvailable(false);
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        return dialog.open() == 0;
    }

    private static class PresetTableContentProvider
    extends AbstractStructuredContentProvider {
        private PresetTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (!(inputElement instanceof PresetRepository)) {
                throw new IllegalArgumentException("input element must be a PresetRepository");
            }
            PresetRepository repository = (PresetRepository)inputElement;
            return repository.listPresets();
        }
    }
}

