/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.common.labelingrules;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.openjdk.jmc.ui.common.CorePlugin;
import org.openjdk.jmc.ui.common.idesupport.IDESupportFactory;
import org.openjdk.jmc.ui.common.jvm.JVMCommandLineToolkit;
import org.openjdk.jmc.ui.common.jvm.JVMDescriptor;
import org.openjdk.jmc.ui.common.labelingrules.Messages;
import org.openjdk.jmc.ui.common.labelingrules.NamingRule;
import org.openjdk.jmc.ui.common.resource.Resource;
import org.openjdk.jmc.ui.common.util.Environment;

public final class NameConverter {
    private static final String LABELING_RULES_EXTENSION_POINT = "org.openjdk.jmc.ui.common.labelingRules";
    private static final String ATTRIBUTE_ICON = "icon";
    private static final Comparator<NamingRule> COMPARATOR = new Comparator<NamingRule>(){

        @Override
        public int compare(NamingRule o1, NamingRule o2) {
            return o2.getPriority() - o1.getPriority();
        }
    };
    private static final NameConverter INSTANCE = new NameConverter();
    private final List<NamingRule> rules = new ArrayList<NamingRule>();

    public static NameConverter getInstance() {
        return INSTANCE;
    }

    public NameConverter() {
        this.initializeRulesFromExtensions();
    }

    public String format(JVMDescriptor descriptor) {
        Object[] values = this.prepareValues(descriptor);
        NamingRule rule = this.getMatchingRule(values);
        if (rule != null) {
            return rule.format(values);
        }
        return MessageFormat.format(Messages.NameConverter_LOCAL_NAME_TEMPLATE, descriptor);
    }

    public Resource getImageResource(JVMDescriptor descriptor) {
        NamingRule rule = this.getMatchingRule(this.prepareValues(descriptor));
        return rule == null ? null : rule.getImageResource();
    }

    public void addNamingRule(NamingRule rule) {
        this.rules.add(rule);
        this.rules.sort(COMPARATOR);
    }

    public List<NamingRule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    private NamingRule getMatchingRule(Object[] values) {
        for (NamingRule rule : this.rules) {
            try {
                if (!rule.matches(values)) continue;
                return rule;
            }
            catch (RuntimeException runtimeException) {}
        }
        return null;
    }

    private void initializeRulesFromExtensions() {
        IExtension[] extensions;
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IExtensionPoint ep = er.getExtensionPoint(LABELING_RULES_EXTENSION_POINT);
        IExtension[] iExtensionArray = extensions = ep.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configs;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configs = extension.getConfigurationElements();
            int n3 = configs.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement config = iConfigurationElementArray[n4];
                if (config.getName().equals("rule")) {
                    try {
                        this.rules.add(this.createRule(config));
                    }
                    catch (Exception e) {
                        CorePlugin.getDefault().getLogger().log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        this.rules.sort(COMPARATOR);
    }

    private NamingRule createRule(IConfigurationElement config) throws Exception {
        String name = config.getAttribute("name");
        try {
            int priority = Integer.parseInt(config.getAttribute("priority"));
            String matchingPart = config.getAttribute("match");
            String formattingPart = config.getAttribute("format");
            return new NamingRule(name, matchingPart, formattingPart, priority, this.getIcon(config));
        }
        catch (Exception exception) {
            throw new Exception("Problem instantiating naming rule named " + name);
        }
    }

    private Resource getIcon(IConfigurationElement configElement) {
        String iconName = configElement.getAttribute(ATTRIBUTE_ICON);
        if (iconName != null) {
            String extendingPluginId = configElement.getDeclaringExtension().getContributor().getName();
            return new Resource(extendingPluginId, iconName);
        }
        return null;
    }

    private Object[] prepareValues(JVMDescriptor descriptor) {
        return new Object[]{descriptor.getJavaVersion(), descriptor.getJvmType(), descriptor.getJvmArch(), this.getValidName(descriptor), descriptor.getJavaCommand(), descriptor.getPid() != null ? String.valueOf(descriptor.getPid()) : "", descriptor.isDebug(), descriptor.getJVMArguments()};
    }

    private String getValidName(JVMDescriptor descriptor) {
        Integer pid = descriptor.getPid();
        if (pid != null && pid == Environment.getThisPID() && descriptor.isAttachable().booleanValue()) {
            return String.valueOf(IDESupportFactory.getIDESupport().getIdentity()) + ".this";
        }
        String name = JVMCommandLineToolkit.getMainClassOrJar(descriptor.getJavaCommand());
        if (name != null && name.length() > 0) {
            return name;
        }
        return Messages.NameConverter_UNKNOWN_LOCAL_JVM;
    }

    static enum ValueArrayInfo {
        JAVAVERSION(0, "JDK", "{0}"),
        JVMTYPE(1, "JVMType", "{1}"),
        JVMARCH(2, "JVMArch", "{2}"),
        NAME(3, "Name", "{3}"),
        JAVACOMMAND(4, "JavaCmd", "{4}"),
        PID(5, "PID", "{5}"),
        DEBUG(6, "IsDebug", "{6}"),
        JVMARGS(7, "JVMArgs", "{7}");

        private int index;
        private String valueName;
        private String matchExpression;

        private ValueArrayInfo(int index, String valueName, String matchExpression) {
            this.index = index;
            this.valueName = valueName;
            this.matchExpression = matchExpression;
        }

        public int getIndex() {
            return this.index;
        }

        public String getValueName() {
            return this.valueName;
        }

        public String getMatchExpression() {
            return this.matchExpression;
        }
    }
}

