/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.common;

import org.HdrHistogram.ConcurrentHistogram;
import org.HdrHistogram.Histogram;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemConsumer;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.Pair;

public class DurationHdrHistogram {
    private static final int SIGNIFICANT_DIGITS = 3;
    private final Histogram histogram = new ConcurrentHistogram(3);

    public IQuantity getDurationAtPercentile(IQuantity percentile) {
        long rawValue = this.histogram.getValueAtPercentile(percentile.doubleValue());
        ITypedQuantity duration = UnitLookup.NANOSECOND.quantity(rawValue);
        return duration;
    }

    public Pair<IQuantity, IQuantity> getDurationAndCountAtPercentile(IQuantity percentile) {
        long rawValue = this.histogram.getValueAtPercentile(percentile.doubleValue());
        ITypedQuantity duration = UnitLookup.NANOSECOND.quantity(rawValue);
        long rawCount = this.histogram.getCountBetweenValues(rawValue, this.histogram.getMaxValue());
        ITypedQuantity count = UnitLookup.NUMBER_UNITY.quantity(rawCount);
        return new Pair((Object)duration, (Object)count);
    }

    public boolean isEmpty() {
        return this.getTotalCount() == 0L;
    }

    public long getTotalCount() {
        return this.histogram.getTotalCount();
    }

    public IQuantity getLowestEquivalentDuration(IQuantity duration) {
        long rawValue = duration.clampedLongValueIn((IUnit)UnitLookup.NANOSECOND);
        long lowestEquivalent = this.histogram.lowestEquivalentValue(rawValue);
        return UnitLookup.NANOSECOND.quantity(lowestEquivalent);
    }

    public void reset() {
        this.histogram.reset();
    }

    static class DurationItemConsumer
    implements IItemConsumer<DurationItemConsumer> {
        private final DurationHdrHistogram durationHist;
        private final IMemberAccessor<IQuantity, IItem> accessor;

        public DurationItemConsumer(DurationHdrHistogram durationHist, IMemberAccessor<IQuantity, IItem> accessor) {
            this.durationHist = durationHist;
            this.accessor = accessor;
        }

        public void consume(IItem item) {
            IQuantity quantity = (IQuantity)this.accessor.getMember((Object)item);
            this.durationHist.histogram.recordValue(quantity.clampedLongValueIn((IUnit)UnitLookup.NANOSECOND));
        }

        public DurationItemConsumer merge(DurationItemConsumer other) {
            return this;
        }
    }
}

