/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RunnableFuture;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IStateful;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.util.StateToolkit;
import org.openjdk.jmc.flightrecorder.rules.DependsOn;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.ResultProvider;
import org.openjdk.jmc.flightrecorder.rules.RuleRegistry;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.report.html.internal.RulesHtmlToolkit;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.openjdk.jmc.flightrecorder.ui.BasicConfig;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.RulesUiToolkit;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.preferences.RulesPage;
import org.xml.sax.SAXException;

public class RuleManager {
    public static final String RULE_CONFIGURATION_PREFERENCE_ID = "ruleConfiguration";
    public static final String UNMAPPED_REMAINDER_TOPIC = "";
    private final Object ruleJobFamily = new Object();
    private final ConcurrentMap<String, ConcurrentMap<String, IResult>> resultsByTopicByRuleId;
    private final ConcurrentMap<String, Set<Consumer<IResult>>> resultListenersByTopic;
    private final List<Consumer<IResult>> resultListeners = Collections.synchronizedList(new ArrayList());
    private final List<String> unmappedTopics = Collections.synchronizedList(new ArrayList());
    private Set<String> ignoredRules = Collections.synchronizedSet(new HashSet());
    private Map<Class<? extends IRule>, Severity> evaluatedRules = new ConcurrentHashMap<Class<? extends IRule>, Severity>();
    private BasicConfig config;
    private StreamModel items;
    private Runnable postEvaluationCallback;
    private int threadsPerEngine;
    private IPropertyChangeListener ignoredSetListener;
    private IPropertyChangeListener configListener;
    private ResultProvider resultProvider;

    RuleManager(Runnable postEvaluationCallback) {
        this.postEvaluationCallback = postEvaluationCallback;
        this.resultProvider = new ResultProvider();
        this.addResultListener(arg_0 -> ((ResultProvider)this.resultProvider).addResults(arg_0));
        IPreferenceStore preferenceStore = FlightRecorderUI.getDefault().getPreferenceStore();
        this.loadIgnoredSet(preferenceStore);
        this.loadConfig(preferenceStore);
        int threads = preferenceStore.getInt("flightrecorder.rule.evaluation.threads");
        this.threadsPerEngine = Math.max(threads, 1);
        Collection<String> topics = RulesUiToolkit.getTopics();
        int initialCapacity = topics.size() > 0 ? topics.size() : 1;
        this.resultsByTopicByRuleId = new ConcurrentHashMap<String, ConcurrentMap<String, IResult>>(initialCapacity, 0.75f, this.threadsPerEngine);
        this.resultListenersByTopic = new ConcurrentHashMap<String, Set<Consumer<IResult>>>(initialCapacity, 0.75f, this.threadsPerEngine);
        for (String topic : topics) {
            this.resultsByTopicByRuleId.putIfAbsent(topic, new ConcurrentHashMap());
            for (IRule rule : RulesUiToolkit.getRules(topic)) {
                if (this.ignoredRules.contains(rule.getId())) continue;
                ((ConcurrentMap)this.resultsByTopicByRuleId.get(topic)).put(rule.getId(), ResultBuilder.createFor((IRule)rule, this.config::getValue).setSeverity(Severity.NA).setSummary(Messages.JFR_EDITOR_RULES_WAITING).addResult(RulesHtmlToolkit.IN_PROGRESS, (Object)true).build());
            }
        }
    }

    private void updateListeners(IResult result) {
        Set listeners = (Set)this.resultListenersByTopic.get(result.getRule().getTopic());
        if (listeners != null) {
            ((Stream)listeners.stream().parallel()).forEach(rl -> rl.accept(result));
        }
        this.resultListeners.forEach(rl -> rl.accept(result));
    }

    void setStreamModel(StreamModel items) {
        this.items = items;
    }

    void dispose() {
        FlightRecorderUI.getDefault().getPreferenceStore().removePropertyChangeListener(this.configListener);
        FlightRecorderUI.getDefault().getPreferenceStore().removePropertyChangeListener(this.ignoredSetListener);
        Job.getJobManager().cancel(this.ruleJobFamily);
        this.saveState();
    }

    private void saveState() {
        try {
            if (this.config != null) {
                FlightRecorderUI.getDefault().getPreferenceStore().putValue(RULE_CONFIGURATION_PREFERENCE_ID, StateToolkit.toXMLString((IStateful)this.config));
            }
        }
        catch (Exception e) {
            FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Could not save configuration!", e);
        }
    }

    BasicConfig getConfig() {
        return this.config;
    }

    public Collection<IResult> getResults(String ... topics) {
        return this.getResults(Arrays.asList(topics));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IResult> getResults(Collection<String> topics) {
        HashSet<IResult> results = new HashSet<IResult>();
        results.addAll(topics.stream().filter(t -> !UNMAPPED_REMAINDER_TOPIC.equals(t)).map(t -> (ConcurrentMap)this.resultsByTopicByRuleId.get(t)).filter(m -> m != null).flatMap(m -> m.values().stream()).collect(Collectors.toList()));
        if (topics.stream().anyMatch(t -> UNMAPPED_REMAINDER_TOPIC.equals(t))) {
            List<String> list = this.unmappedTopics;
            synchronized (list) {
                this.unmappedTopics.forEach(t -> {
                    boolean bl = results.addAll(((ConcurrentMap)this.resultsByTopicByRuleId.get(t)).values());
                });
            }
        }
        return results;
    }

    public IResult getResult(IRule rule) {
        return (IResult)((ConcurrentMap)this.resultsByTopicByRuleId.get(rule.getTopic())).get(rule.getId());
    }

    public DoubleStream getScoreStream(String ... topics) {
        return this.getResults(topics).parallelStream().mapToDouble(r -> {
            IQuantity score = (IQuantity)r.getResult(TypedResult.SCORE);
            return score == null ? r.getSeverity().getLimit() : score.doubleValue();
        });
    }

    public Collection<IRule> getRules(String ... topics) {
        return this.getResults(topics).parallelStream().map(IResult::getRule).collect(Collectors.toList());
    }

    public Severity getMaxSeverity(String ... topics) {
        return this.getResults(topics).parallelStream().map(IResult::getSeverity).max(Comparator.naturalOrder()).orElse(Severity.NA);
    }

    public Collection<IResult> getUnmappedResults() {
        return this.getResults(this.unmappedTopics);
    }

    public void evaluateRules(Collection<IRule> rules) {
        if (FlightRecorderUI.getDefault().isAnalysisEnabled() && this.items != null) {
            IProgressMonitor evaluationGroup = Job.getJobManager().createProgressGroup();
            evaluationGroup.setTaskName(Messages.JFR_EDITOR_RULES_TASK_NAME);
            JobGroup group = new JobGroup("Rule Evaluation Group", this.threadsPerEngine, rules.size());
            for (IRule rule : rules) {
                String topic;
                String string = topic = rule.getTopic() == null ? UNMAPPED_REMAINDER_TOPIC : rule.getTopic();
                if (!this.ignoredRules.contains(rule.getId())) {
                    EvaluateJob job = new EvaluateJob(rule);
                    job.setJobGroup(group);
                    IResult result = ResultBuilder.createFor((IRule)rule, this.config::getValue).setSeverity(Severity.NA).setSummary(Messages.JFR_EDITOR_RULES_SCHEDULED).addResult(RulesHtmlToolkit.IN_PROGRESS, (Object)true).build();
                    ((ConcurrentMap)this.resultsByTopicByRuleId.get(topic)).put(rule.getId(), result);
                    this.updateListeners(result);
                    job.setSystem(true);
                    job.setProgressGroup(evaluationGroup, 1);
                    job.setPriority(50);
                    job.schedule();
                    continue;
                }
                IResult result = ResultBuilder.createFor((IRule)rule, this.config::getValue).setSeverity(Severity.NA).setSummary(Messages.JFR_EDITOR_RULES_IGNORED).addResult(RulesHtmlToolkit.IGNORED, (Object)true).build();
                ((ConcurrentMap)this.resultsByTopicByRuleId.get(topic)).put(rule.getId(), result);
                this.updateListeners(result);
            }
        }
    }

    public void evaluateAllRules() {
        Collection rules = RuleRegistry.getRules();
        this.evaluateRules(rules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshTopics() {
        HashSet<String> topics = new HashSet<String>(RulesUiToolkit.getTopics());
        FlightRecorderUI.getDefault().getPageManager().getAllPages().forEach(dpd -> {
            boolean bl = topics.removeAll(Arrays.asList(dpd.getTopics()));
        });
        List<String> list = this.unmappedTopics;
        synchronized (list) {
            this.unmappedTopics.clear();
            this.unmappedTopics.addAll(topics);
        }
    }

    public void addResultListener(String topic, Consumer<IResult> listener) {
        this.resultListenersByTopic.computeIfAbsent(topic, k -> Collections.synchronizedSet(new HashSet())).add(listener);
    }

    public void addResultListener(Consumer<IResult> listener) {
        this.resultListeners.add(listener);
    }

    public void removeResultListener(Consumer<IResult> listener) {
        this.resultListeners.remove(listener);
        this.resultListenersByTopic.values().forEach(r -> {
            boolean bl = r.remove(listener);
        });
    }

    private void loadIgnoredSet(IPreferenceStore preferenceStore) {
        this.ignoredSetListener = e -> {
            if (e.getProperty().equals("ignoredRules")) {
                try {
                    Set<String> newIgnoredRules = RulesPage.loadIgnoredRules(preferenceStore);
                    HashSet<String> tempSet = new HashSet<String>();
                    tempSet.addAll(this.ignoredRules);
                    tempSet.addAll(newIgnoredRules);
                    this.ignoredRules = newIgnoredRules;
                    this.evaluateRules(RuleRegistry.getRules().stream().filter(r -> tempSet.contains(r.getId())).collect(Collectors.toList()));
                }
                catch (Exception e1) {
                    FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Could not read ignored rules from preferences.", e1);
                }
            }
        };
        preferenceStore.addPropertyChangeListener(this.ignoredSetListener);
        this.ignoredRules = RulesPage.loadIgnoredRules(preferenceStore);
    }

    private void loadConfig(IPreferenceStore preferenceStore) {
        String configStateString = preferenceStore.getString(RULE_CONFIGURATION_PREFERENCE_ID);
        this.configListener = e -> {
            if (e.getProperty().equals(RULE_CONFIGURATION_PREFERENCE_ID)) {
                String newConfig = e.getNewValue().toString();
                try {
                    IState newState = StateToolkit.fromXMLString((String)newConfig);
                    this.evaluateRules(this.config.update(newState));
                }
                catch (SAXException saxe) {
                    FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Error reading configuration XML", saxe);
                }
            }
        };
        preferenceStore.addPropertyChangeListener(this.configListener);
        IState fromXMLString = null;
        try {
            fromXMLString = configStateString.length() != 0 ? StateToolkit.fromXMLString((String)configStateString) : null;
        }
        catch (SAXException saxe) {
            FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Error reading configuration XML", saxe);
        }
        this.config = new BasicConfig(fromXMLString);
    }

    public IResultValueProvider getResultProvider() {
        return this.resultProvider;
    }

    private class EvaluateJob
    extends Job {
        private final IRule rule;

        EvaluateJob(IRule rule) {
            super(rule.getId());
            this.rule = rule;
        }

        public boolean belongsTo(Object family) {
            return family == RuleManager.this.ruleJobFamily;
        }

        private boolean shouldEvaluate(IRule rule) throws InterruptedException {
            Class dependencyType;
            DependsOn dependency = rule.getClass().getAnnotation(DependsOn.class);
            if (dependency != null && (dependencyType = dependency.value()) != null) {
                while (true) {
                    if (RuleManager.this.evaluatedRules.containsKey(dependencyType)) {
                        return RuleManager.this.evaluatedRules.get(dependencyType).compareTo((Enum)dependency.severity()) >= 0;
                    }
                    FlightRecorderUI.getDefault().getLogger().log(Level.INFO, "Waiting one second to evaluate " + rule.getClass().getName() + " for result from " + dependencyType.getName());
                    Thread.sleep(1000L);
                }
            }
            return true;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IResult result;
            String topic;
            block7: {
                monitor.beginTask(this.rule.getName(), -1);
                topic = this.rule.getTopic() == null ? RuleManager.UNMAPPED_REMAINDER_TOPIC : this.rule.getTopic();
                result = ResultBuilder.createFor((IRule)this.rule, RuleManager.this.config::getValue).setSeverity(Severity.NA).addResult(RulesHtmlToolkit.IN_PROGRESS, (Object)true).build();
                ((ConcurrentMap)RuleManager.this.resultsByTopicByRuleId.get(topic)).put(this.rule.getId(), result);
                RuleManager.this.updateListeners(result);
                try {
                    if (RulesToolkit.matchesEventAvailabilityMap((IItemCollection)RuleManager.this.items.getItems(), (Map)this.rule.getRequiredEvents()) && this.shouldEvaluate(this.rule)) {
                        RuleManager.this.evaluatedRules.remove(this.rule.getClass());
                        RunnableFuture future = this.rule.createEvaluation(RuleManager.this.items.getItems(), RuleManager.this.config::getValue, (IResultValueProvider)RuleManager.this.resultProvider);
                        Thread runner = new Thread(future);
                        runner.start();
                        while (true) {
                            if (monitor.isCanceled()) {
                                future.cancel(true);
                                runner.join();
                                result = ResultBuilder.createFor((IRule)this.rule, RuleManager.this.config::getValue).setSeverity(Severity.NA).setSummary(Messages.JFR_EDITOR_RULES_CANCELLED).addResult(RulesHtmlToolkit.FAILED, (Object)true).build();
                                RuleManager.this.evaluatedRules.put(this.rule.getClass(), Severity.NA);
                                break block7;
                            }
                            if (future.isDone()) {
                                result = (IResult)future.get();
                                runner.join();
                                RuleManager.this.evaluatedRules.put(this.rule.getClass(), result.getSeverity());
                                break block7;
                            }
                            Thread.sleep(100L);
                        }
                    }
                    result = ResultBuilder.createFor((IRule)this.rule, RuleManager.this.config::getValue).setSeverity(Severity.NA).setSummary(Messages.JFR_EDITOR_RULES_IGNORED).build();
                    RuleManager.this.evaluatedRules.put(this.rule.getClass(), Severity.NA);
                }
                catch (Exception e) {
                    FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Could not evaluate " + this.rule.getName(), e);
                    result = ResultBuilder.createFor((IRule)this.rule, RuleManager.this.config::getValue).setSeverity(Severity.NA).setSummary(NLS.bind((String)Messages.JFR_EDITOR_RULE_EVALUATION_ERROR_DESCRIPTION, (Object)e)).addResult(RulesHtmlToolkit.FAILED, (Object)true).build();
                    RuleManager.this.evaluatedRules.put(this.rule.getClass(), Severity.NA);
                }
            }
            if (result == null) {
                result = ResultBuilder.createFor((IRule)this.rule, RuleManager.this.config::getValue).setSeverity(Severity.NA).setSummary(Messages.RuleManager_NULL_RESULT_DESCRIPTION).addResult(RulesHtmlToolkit.FAILED, (Object)true).build();
                RuleManager.this.evaluatedRules.put(this.rule.getClass(), Severity.NA);
            }
            ((ConcurrentMap)RuleManager.this.resultsByTopicByRuleId.get(topic)).put(this.rule.getId(), result);
            RuleManager.this.updateListeners(result);
            RuleManager.this.postEvaluationCallback.run();
            monitor.worked(1);
            monitor.done();
            return new Status(monitor.isCanceled() ? 8 : 0, "org.openjdk.jmc.flightrecorder.ui", this.rule.getName());
        }
    }
}

