/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.Attribute;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IItemQuery;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemCollectionToolkit;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.item.ItemQueryBuilder;
import org.openjdk.jmc.common.item.ItemToolkit;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.rules.jdk.memory.ReferenceStatisticsType;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.FilterComponent;
import org.openjdk.jmc.flightrecorder.ui.common.FlavorSelector;
import org.openjdk.jmc.flightrecorder.ui.common.ItemList;
import org.openjdk.jmc.flightrecorder.ui.common.ItemRow;
import org.openjdk.jmc.flightrecorder.ui.common.ThreadGraphLanes;
import org.openjdk.jmc.flightrecorder.ui.common.TypeLabelProvider;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.selection.SelectionStoreActionToolkit;
import org.openjdk.jmc.ui.charts.AWTChartToolkit;
import org.openjdk.jmc.ui.charts.ISpanSeries;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.QuantitySeries;
import org.openjdk.jmc.ui.charts.RendererToolkit;
import org.openjdk.jmc.ui.charts.SpanRenderer;
import org.openjdk.jmc.ui.charts.XYChart;
import org.openjdk.jmc.ui.column.ColumnBuilder;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.ActionToolkit;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.ActionUiToolkit;
import org.openjdk.jmc.ui.misc.ChartCanvas;
import org.openjdk.jmc.ui.misc.PersistableSashForm;

public class GarbageCollectionsPage
extends AbstractDataPage {
    private static final ReferenceStatisticsType[] REF_TYPE = ReferenceStatisticsType.values();
    private static final String SASH = "sash";
    private static final String TABLE_SASH = "tableSash";
    private static final String THREAD_LANES = "threadLane";
    private static final String GCS = "gcs";
    private static final String CHART = "chart";
    private static final String PHASE_TABLE_FILTER = "phaseTableFilter";
    private static final String GC_TABLE_FILTER = "gcTableFilter";
    private static final String METASPACE_TABLE_FILTER = "metaspaceTableFilter";
    private static final String PHASE_LIST = "phaseList";
    private static final String METASPACE_LIST = "metaspaceList";
    private static final String ACTIVITY_LANES_ID = "threadActivityLanes";
    private static final Color LONGEST_PAUSE_COLOR = DataPageToolkit.GC_BASE_COLOR.brighter();
    private static final Color SUM_OF_PAUSES_COLOR = DataPageToolkit.GC_BASE_COLOR.brighter().brighter();
    public static final IAttribute<IQuantity> HEAP_USED_POST_GC = Attribute.attr((String)"heapUsed", (String)Messages.ATTR_HEAP_USED_POST_GC, (String)Messages.ATTR_HEAP_USED_POST_GC_DESC, (ContentType)UnitLookup.MEMORY);
    public static final IItemQuery HEAP_SUMMARY_POST_GC = ItemQueryBuilder.fromWhere((IItemFilter)JdkFilters.HEAP_SUMMARY_AFTER_GC).select(HEAP_USED_POST_GC).build();
    private static final IItemQuery METASPACE_SUMMARY = ItemQueryBuilder.fromWhere((IItemFilter)JdkFilters.METASPACE_SUMMARY).select(new IAttribute[]{JdkAttributes.GC_METASPACE_USED, JdkAttributes.GC_METASPACE_CAPACITY, JdkAttributes.GC_METASPACE_COMMITTED, JdkAttributes.GC_METASPACE_RESERVED}).build();
    private static final ItemList.ItemListBuilder PHASES = new ItemList.ItemListBuilder();
    private static final ItemList.ItemListBuilder METASPACE = new ItemList.ItemListBuilder();
    private IItemFilter tableFilterState;
    private IItemFilter phasesFilterState;
    private IItemFilter metaspaceFilterState;
    private IRange<IQuantity> timelineRange;
    private ColumnManager.SelectionState gcListSelection;
    private ColumnManager.SelectionState phasesSelection;
    private ColumnManager.SelectionState metaspaceSelection;
    private int gcInfoTabSelection = 0;
    public FlavorSelector.FlavorSelectorState flavorSelectorState;

    static {
        PHASES.addColumn(JfrAttributes.EVENT_TYPE);
        PHASES.addColumn(JdkAttributes.GC_PHASE_NAME);
        PHASES.addColumn(JfrAttributes.DURATION);
        PHASES.addColumn(JfrAttributes.START_TIME);
        PHASES.addColumn(JfrAttributes.EVENT_THREAD);
        PHASES.addColumn(JdkAttributes.GC_ID);
        METASPACE.addColumn(JdkAttributes.GC_METASPACE_USED);
        METASPACE.addColumn(JdkAttributes.GC_DATASPACE_COMMITTED);
        METASPACE.addColumn(JdkAttributes.GC_DATASPACE_RESERVED);
        METASPACE.addColumn(JdkAttributes.GC_DATASPACE_USED);
        METASPACE.addColumn(JdkAttributes.GC_CLASSSPACE_COMMITTED);
        METASPACE.addColumn(JdkAttributes.GC_CLASSSPACE_RESERVED);
        METASPACE.addColumn(JdkAttributes.GC_CLASSSPACE_USED);
        METASPACE.addColumn(JdkAttributes.GC_THRESHOLD);
        METASPACE.addColumn(JdkAttributes.GC_WHEN);
        METASPACE.addColumn(JdkAttributes.GC_ID);
        METASPACE.addColumn(JfrAttributes.START_TIME);
    }

    private static void logDuplicateGcId(GC duplicateGC) {
        if (duplicateGC != null) {
            IQuantity gcID = (IQuantity)JdkAttributes.GC_ID.getAccessor(ItemToolkit.getItemType((IItem)duplicateGC.gcItem)).getMember((Object)duplicateGC.gcItem);
            FlightRecorderUI.getDefault().getLogger().severe("GC with id " + gcID + " is duplicated");
        }
    }

    private static IColumn buildGCItemAttributeColumn(IAttribute<?> a, IMemberAccessor<?, Object> cellAccessor) {
        int style = a.getContentType() instanceof LinearKindOfQuantity ? 131072 : 0;
        return new ColumnBuilder(a.getName(), a.getIdentifier(), cellAccessor).description(a.getDescription()).style(style).build();
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
        return new GarbageCollectionsUi(parent, toolkit, pageContainer, state);
    }

    public GarbageCollectionsPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
        this.timelineRange = editor.getRecordingRange();
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return ItemFilters.or((IItemFilter[])new IItemFilter[]{JdkFilters.GC_PAUSE, JdkFilters.GC_PAUSE_PHASE, JdkFilters.HEAP_SUMMARY, JdkFilters.METASPACE_SUMMARY});
    }

    private static Set<String> calculateExcludedAttributeIds(IItemCollection items) {
        Stream<Object> exclude = METASPACE_SUMMARY.getAttributes().stream();
        Iterator iterator = items.apply(METASPACE_SUMMARY.getFilter()).iterator();
        if (iterator.hasNext()) {
            IType type = ((IItemIterable)iterator.next()).getType();
            exclude = exclude.filter(a -> a.getAccessor(type) == null);
        }
        return exclude.map(ICanonicalAccessorFactory::getIdentifier).collect(Collectors.toSet());
    }

    private static class GC {
        final IType<IItem> type;
        final IItem gcItem;
        final Object[] referenceStatisticsData;
        IQuantity gcId;
        IQuantity duration;
        String gcCause;
        String gcName;
        IQuantity longestPause;
        IQuantity sumOfPauses;
        IQuantity startTime;
        IQuantity endTime;
        IQuantity usedBeforeGC;
        IQuantity usedAfterGC;
        IQuantity usedDelta;
        IQuantity committedDelta;
        IQuantity usedMetaspaceDelta;
        IQuantity committedMetaspaceDelta;

        GC(IItem gcItem, IType<IItem> type) {
            this.type = type;
            this.gcItem = gcItem;
            this.referenceStatisticsData = new Object[REF_TYPE.length];
            this.usedBeforeGC = UnitLookup.BYTE.quantity(0L);
            this.usedAfterGC = UnitLookup.BYTE.quantity(0L);
            this.usedDelta = UnitLookup.BYTE.quantity(0L);
            this.committedDelta = UnitLookup.BYTE.quantity(0L);
            this.usedMetaspaceDelta = UnitLookup.BYTE.quantity(0L);
            this.committedMetaspaceDelta = UnitLookup.BYTE.quantity(0L);
        }

        Object getRefCount(ReferenceStatisticsType type) {
            return this.referenceStatisticsData[type.ordinal()];
        }

        void setRefCount(Object type, Object count) {
            int i = 0;
            while (i < REF_TYPE.length) {
                if (GarbageCollectionsPage.REF_TYPE[i].typeValue.equals(type)) {
                    this.referenceStatisticsData[i] = count;
                    break;
                }
                ++i;
            }
        }
    }

    public static class GarbageCollectionPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.GarbageCollectionsPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/gc.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"garbage_collection"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new GarbageCollectionsPage(dpd, items, editor);
        }
    }

    private class GarbageCollectionsUi
    implements IPageUI {
        private final SashForm sash;
        private final SashForm tableSash;
        private final IPageContainer pageContainer;
        private final ChartCanvas chartCanvas;
        private final ColumnManager gcList;
        private IXDataRenderer renderRoot = RendererToolkit.empty();
        private IAction GCEventThread = DataPageToolkit.createCheckAction(Messages.JavaApplicationPage_THREAD_ACTIVITY_ACTION, Messages.JavaApplicationPage_THREAD_ACTIVITY_ACTION_DESC, "threadActivityLanes", FlightRecorderUI.getDefault().getMCImageDescriptor("lanes.gif"), b -> this.buildChart());
        private final IAction enablePhases = ActionToolkit.checkAction(b -> this.buildChart(), (String)Messages.GarbageCollectionsPage_ROW_PAUSE_PHASES, (String)Messages.GarbageCollectionsPage_ROW_PAUSE_PHASES_DESC, (ImageDescriptor)FlightRecorderUI.getDefault().getMCImageDescriptor("parts.png"), (String)"phases");
        private final IAction longestPause = DataPageToolkit.createAggregatorCheckAction(JdkAggregators.LONGEST_GC_PAUSE, "longestPause", LONGEST_PAUSE_COLOR, b -> this.buildChart());
        private final IAction sumOfPauses = DataPageToolkit.createAggregatorCheckAction(JdkAggregators.TOTAL_GC_PAUSE, "sumOfPauses", SUM_OF_PAUSES_COLOR, b -> this.buildChart());
        private final List<IAction> allChartSeriesActions = Stream.concat(Stream.concat(JdkQueries.HEAP_SUMMARY.getAttributes().stream(), Stream.concat(HEAP_SUMMARY_POST_GC.getAttributes().stream(), METASPACE_SUMMARY.getAttributes().stream())).map(a -> DataPageToolkit.createAttributeCheckAction(a, b -> this.buildChart())), Stream.of(this.longestPause, this.sumOfPauses, this.enablePhases, this.GCEventThread)).collect(Collectors.toList());
        private final Set<String> excludedAttributeIds;
        private FilterComponent tableFilter;
        private XYChart gcChart;
        private IRange<IQuantity> currentRange;
        private ItemList phasesList;
        private FilterComponent phasesFilter;
        private ItemList metaspaceList;
        private FilterComponent metaspaceFilter;
        private CTabFolder gcInfoFolder;
        private IItemCollection selectionItems;
        private FlavorSelector flavorSelector;
        private ThreadGraphLanes lanes;
        private MCContextMenuManager mm;

        GarbageCollectionsUi(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
            this.pageContainer = pageContainer;
            this.excludedAttributeIds = GarbageCollectionsPage.calculateExcludedAttributeIds(GarbageCollectionsPage.this.getDataSource().getItems());
            Form form = DataPageToolkit.createForm(parent, toolkit, GarbageCollectionsPage.this.getName(), GarbageCollectionsPage.this.getIcon());
            this.sash = new SashForm(form.getBody(), 512);
            toolkit.adapt((Composite)this.sash);
            this.tableSash = new SashForm((Composite)this.sash, 256);
            toolkit.adapt((Composite)this.tableSash);
            TableViewer tableViewer = new TableViewer((Composite)this.tableSash, 268501762);
            tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
            ArrayList<IColumn> columns = new ArrayList<IColumn>();
            columns.add(GarbageCollectionsPage.buildGCItemAttributeColumn(JdkAttributes.GC_ID, o -> ((GC)o).gcId));
            columns.add(GarbageCollectionsPage.buildGCItemAttributeColumn(JfrAttributes.DURATION, o -> ((GC)o).duration));
            columns.add(GarbageCollectionsPage.buildGCItemAttributeColumn(JdkAttributes.GC_CAUSE, o -> ((GC)o).gcCause));
            columns.add(GarbageCollectionsPage.buildGCItemAttributeColumn(JdkAttributes.GC_NAME, o -> ((GC)o).gcName));
            columns.add(GarbageCollectionsPage.buildGCItemAttributeColumn(JdkAttributes.GC_LONGEST_PAUSE, o -> ((GC)o).longestPause));
            columns.add(GarbageCollectionsPage.buildGCItemAttributeColumn(JdkAttributes.GC_SUM_OF_PAUSES, o -> ((GC)o).sumOfPauses));
            columns.add(GarbageCollectionsPage.buildGCItemAttributeColumn(JfrAttributes.START_TIME, o -> ((GC)o).startTime));
            columns.add(GarbageCollectionsPage.buildGCItemAttributeColumn(JfrAttributes.END_TIME, o -> ((GC)o).endTime));
            ReferenceStatisticsType[] referenceStatisticsTypeArray = REF_TYPE;
            int n = REF_TYPE.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceStatisticsType t = referenceStatisticsTypeArray[n2];
                columns.add(new ColumnBuilder(t.localizedName, "ReferenceStatisticsType-" + t.name(), o -> ((GC)o).getRefCount(t)).style(131072).build());
                ++n2;
            }
            columns.add(new ColumnBuilder(Messages.GarbageCollectionsPage_USED_HEAP_BEFORE_GC, "usedHeapBegoreGC", o -> ((GC)o).usedBeforeGC).style(131072).build());
            columns.add(new ColumnBuilder(Messages.GarbageCollectionsPage_USED_HEAP_AFTER_GC, "usedHeapAfterGC", o -> ((GC)o).usedAfterGC).style(131072).build());
            columns.add(new ColumnBuilder(Messages.GarbageCollectionsPage_USED_HEAP_DELTA, "usedHeapDelta", o -> ((GC)o).usedDelta).style(131072).build());
            columns.add(new ColumnBuilder(Messages.GarbageCollectionsPage_COMMITTED_HEAP_DELTA, "committedHeapDelta", o -> ((GC)o).committedDelta).style(131072).build());
            columns.add(new ColumnBuilder(Messages.GarbageCollectionsPage_USED_METASPACE_DELTA, "usedMetaspaceDelta", o -> ((GC)o).usedMetaspaceDelta).style(131072).build());
            columns.add(new ColumnBuilder(Messages.GarbageCollectionsPage_COMMITTED_METASPACE_DELTA, "committedMetaspaceDelta", o -> ((GC)o).committedMetaspaceDelta).style(131072).build());
            this.gcList = ColumnManager.build((TableViewer)tableViewer, columns, (TableSettings)TableSettings.forState((IState)state.getChild(GarbageCollectionsPage.GCS)));
            MCContextMenuManager itemListMm = MCContextMenuManager.create((Control)this.gcList.getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.gcList, (MCContextMenuManager)itemListMm);
            this.gcList.getViewer().addSelectionChangedListener(e -> {
                this.buildChart();
                pageContainer.showSelection(ItemCollectionToolkit.build(this.gcSelectedGcItems()));
                this.updatePhaseList();
                this.updateMetaspaceList();
            });
            SelectionStoreActionToolkit.addSelectionStoreActions((StructuredViewer)this.gcList.getViewer(), pageContainer.getSelectionStore(), () -> ItemCollectionToolkit.build(this.gcSelectedGcItems()), Messages.GarbageCollectionsPage_LIST_SELECTION, (IContributionManager)itemListMm);
            this.tableFilter = FilterComponent.createFilterComponent(tableViewer.getControl(), this.gcList, GarbageCollectionsPage.this.tableFilterState, GarbageCollectionsPage.this.getDataSource().getItems().apply(JdkFilters.GARBAGE_COLLECTION), pageContainer.getSelectionStore()::getSelections, this::onFilterChange);
            itemListMm.add(this.tableFilter.getShowFilterAction());
            itemListMm.add(this.tableFilter.getShowSearchAction());
            this.gcInfoFolder = new CTabFolder((Composite)this.tableSash, 0);
            this.phasesList = PHASES.buildWithoutBorder((Composite)this.gcInfoFolder, TableSettings.forState((IState)state.getChild(GarbageCollectionsPage.PHASE_LIST)));
            this.phasesList.getManager().getViewer().addSelectionChangedListener(e -> {
                this.buildChart();
                pageContainer.showSelection(ItemCollectionToolkit.build(this.phasesList.getSelection().get()));
            });
            this.phasesFilter = FilterComponent.createFilterComponent(this.phasesList, GarbageCollectionsPage.this.phasesFilterState, GarbageCollectionsPage.this.getDataSource().getItems().apply(JdkFilters.GC_PAUSE_PHASE), pageContainer.getSelectionStore()::getSelections, this::onPhasesFilterChange);
            MCContextMenuManager phasesMm = MCContextMenuManager.create((Control)this.phasesList.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.phasesList.getManager(), (MCContextMenuManager)phasesMm);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.phasesList, Messages.GarbageCollectionsPage_PAUSE_PHASE_SELECTION, (IContributionManager)phasesMm);
            phasesMm.add(this.phasesFilter.getShowFilterAction());
            phasesMm.add(this.phasesFilter.getShowSearchAction());
            DataPageToolkit.addTabItem(this.gcInfoFolder, (Control)this.phasesFilter.getComponent(), Messages.GarbageCollectionsPage_PAUSE_PHASES_TITLE);
            this.metaspaceList = METASPACE.buildWithoutBorder((Composite)this.gcInfoFolder, TableSettings.forState((IState)state.getChild(GarbageCollectionsPage.METASPACE_LIST)));
            this.metaspaceList.getManager().getViewer().addSelectionChangedListener(e -> pageContainer.showSelection(ItemCollectionToolkit.build(this.metaspaceList.getSelection().get())));
            this.metaspaceFilter = FilterComponent.createFilterComponent(this.metaspaceList, GarbageCollectionsPage.this.metaspaceFilterState, GarbageCollectionsPage.this.getDataSource().getItems().apply(JdkFilters.METASPACE_SUMMARY), pageContainer.getSelectionStore()::getSelections, this::onMetaspaceFilterChange);
            MCContextMenuManager metaspaceMm = MCContextMenuManager.create((Control)this.metaspaceList.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.metaspaceList.getManager(), (MCContextMenuManager)metaspaceMm);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.metaspaceList, Messages.GarbageCollectionsPage_METASPACE_SELECTION, (IContributionManager)metaspaceMm);
            metaspaceMm.add(this.metaspaceFilter.getShowFilterAction());
            metaspaceMm.add(this.metaspaceFilter.getShowSearchAction());
            DataPageToolkit.addTabItem(this.gcInfoFolder, (Control)this.metaspaceFilter.getComponent(), Messages.GarbageCollectionsPage_METASPACE_TITLE);
            Composite chartContainer = toolkit.createComposite((Composite)this.sash);
            chartContainer.setLayout((Layout)new GridLayout(2, false));
            this.chartCanvas = new ChartCanvas(chartContainer);
            this.chartCanvas.setLayoutData((Object)new GridData(4, 4, true, true));
            ActionToolkit.loadCheckState((IState)state.getChild(GarbageCollectionsPage.CHART), this.allChartSeriesActions.stream());
            CheckboxTableViewer chartLegend = ActionUiToolkit.buildCheckboxViewer((Composite)chartContainer, this.allChartSeriesActions.stream().filter(a -> this.includeAttribute(a.getId())));
            GridData gd = new GridData(4, 4, false, true);
            gd.widthHint = 180;
            chartLegend.getControl().setLayoutData((Object)gd);
            this.lanes = new ThreadGraphLanes(() -> GarbageCollectionsPage.this.getDataSource(), () -> this.buildChart());
            this.lanes.initializeChartConfiguration(Stream.of(state.getChildren(GarbageCollectionsPage.THREAD_LANES)));
            IAction editLanesAction = ActionToolkit.action(() -> this.lanes.openEditLanesDialog(this.mm, false), (String)Messages.ThreadsPage_EDIT_LANES, (ImageDescriptor)FlightRecorderUI.getDefault().getMCImageDescriptor("lanes_edit.gif"));
            form.getToolBarManager().add(editLanesAction);
            DataPageToolkit.createChartTimestampTooltip(this.chartCanvas);
            this.gcChart = new XYChart(pageContainer.getRecordingRange(), this.renderRoot, 180);
            this.gcChart.setVisibleRange((IQuantity)GarbageCollectionsPage.this.timelineRange.getStart(), (IQuantity)GarbageCollectionsPage.this.timelineRange.getEnd());
            this.gcChart.addVisibleRangeListener(r -> {
                IRange iRange = GarbageCollectionsPage.this.timelineRange = r;
            });
            PersistableSashForm.loadState((SashForm)this.sash, (IState)state.getChild(GarbageCollectionsPage.SASH));
            PersistableSashForm.loadState((SashForm)this.tableSash, (IState)state.getChild(GarbageCollectionsPage.TABLE_SASH));
            this.flavorSelector = FlavorSelector.itemsWithTimerange(form, JdkFilters.GARBAGE_COLLECTION, GarbageCollectionsPage.this.getDataSource().getItems(), pageContainer, this::onInputSelected, this::onShow, GarbageCollectionsPage.this.flavorSelectorState);
            this.gcInfoFolder.setSelection(GarbageCollectionsPage.this.gcInfoTabSelection);
            GarbageCollectionsPage.this.addResultActions(form);
            this.tableFilter.loadState(state.getChild(GarbageCollectionsPage.GC_TABLE_FILTER));
            this.phasesFilter.loadState(state.getChild(GarbageCollectionsPage.PHASE_TABLE_FILTER));
            this.metaspaceFilter.loadState(state.getChild(GarbageCollectionsPage.METASPACE_TABLE_FILTER));
            this.gcList.setSelectionState(GarbageCollectionsPage.this.gcListSelection);
            this.phasesList.getManager().setSelectionState(GarbageCollectionsPage.this.phasesSelection);
            this.metaspaceList.getManager().setSelectionState(GarbageCollectionsPage.this.metaspaceSelection);
            this.mm = (MCContextMenuManager)this.chartCanvas.getContextMenu();
            this.lanes.updateContextMenu(this.mm, false);
            this.lanes.updateContextMenu(MCContextMenuManager.create((Control)chartLegend.getControl()), true);
            if (!GarbageCollectionsPage.this.getDataSource().getItems().apply(ItemFilters.and((IItemFilter[])new IItemFilter[]{ItemFilters.hasAttribute((ICanonicalAccessorFactory)JfrAttributes.EVENT_THREAD), JdkFilters.GC_PAUSE})).hasItems()) {
                editLanesAction.setEnabled(false);
                editLanesAction.setToolTipText(Messages.GarbageCollectionsPage_DISABLED_TOOLTIP);
                this.GCEventThread.setEnabled(false);
                this.GCEventThread.setDescription(Messages.GarbageCollectionsPage_DISABLED_TOOLTIP);
                for (IAction action : this.lanes.getContextMenuActions()) {
                    action.setEnabled(false);
                }
            }
        }

        private void updatePhaseList() {
            this.phasesList.show(ItemCollectionToolkit.filterIfNotNull((IItemCollection)this.getPhaseItems(), (IItemFilter)GarbageCollectionsPage.this.phasesFilterState));
        }

        private void updateMetaspaceList() {
            this.metaspaceList.show(ItemCollectionToolkit.filterIfNotNull((IItemCollection)this.getMetaspaceItems(), (IItemFilter)GarbageCollectionsPage.this.metaspaceFilterState));
        }

        private IItemCollection getMetaspaceItems() {
            Set<IQuantity> selectedGcIds = this.getSelectedGcIds();
            IItemCollection metaspaceItems = GarbageCollectionsPage.this.getDataSource().getItems().apply(JdkFilters.METASPACE_SUMMARY).apply(ItemFilters.memberOf((ICanonicalAccessorFactory)JdkAttributes.GC_ID, selectedGcIds));
            return metaspaceItems;
        }

        private IItemCollection getPhaseItems() {
            Set<IQuantity> gcIds = this.getSelectedGcIds();
            IItemCollection gcIdPausePhases = GarbageCollectionsPage.this.getDataSource().getItems().apply(JdkFilters.GC_PAUSE_PHASE).apply(ItemFilters.memberOf((ICanonicalAccessorFactory)JdkAttributes.GC_ID, gcIds));
            return gcIdPausePhases;
        }

        private Set<IQuantity> getSelectedGcIds() {
            List selected = ((IStructuredSelection)this.gcList.getViewer().getSelection()).toList();
            Set<IQuantity> gcIds = selected.stream().map(gc -> (IQuantity)gc.type.getAccessor(JdkAttributes.GC_ID.getKey()).getMember((Object)gc.gcItem)).collect(Collectors.toSet());
            return gcIds;
        }

        private void onFilterChange(IItemFilter newFilter) {
            IItemCollection items = this.selectionItems != null ? this.selectionItems : GarbageCollectionsPage.this.getDataSource().getItems();
            items = items.apply(JdkFilters.GARBAGE_COLLECTION);
            if (this.tableFilter.isVisible()) {
                this.updateTable(ItemCollectionToolkit.filterIfNotNull((IItemCollection)items, (IItemFilter)newFilter));
                Object input = this.gcList.getViewer().getInput();
                this.tableFilter.setColor(input instanceof Object[] && ((Object[])input).length > 0 ? 1 : 0);
            } else {
                this.updateTable(items);
            }
            GarbageCollectionsPage.this.tableFilterState = newFilter;
        }

        private void onPhasesFilterChange(IItemFilter filter) {
            this.phasesFilter.filterChangeHelper(filter, this.phasesList, GarbageCollectionsPage.this.getDataSource().getItems().apply(JdkFilters.GC_PAUSE_PHASE));
            GarbageCollectionsPage.this.phasesFilterState = filter;
        }

        private void onMetaspaceFilterChange(IItemFilter filter) {
            this.metaspaceFilter.filterChangeHelper(filter, this.metaspaceList, GarbageCollectionsPage.this.getDataSource().getItems().apply(JdkFilters.METASPACE_SUMMARY));
            GarbageCollectionsPage.this.metaspaceFilterState = filter;
        }

        private ItemRow buildSpanRow(IItemCollection items, String typeId) {
            IItemCollection filtered = items.apply(ItemFilters.type((String)typeId));
            return new ItemRow(DataPageToolkit.buildSpanRenderer(filtered, (AWTChartToolkit.IColorProvider<IItem>)AWTChartToolkit.staticColor((Color)TypeLabelProvider.getColorOrDefault(typeId))), filtered);
        }

        private void buildChart() {
            IItemCollection allItems = GarbageCollectionsPage.this.getDataSource().getItems();
            ArrayList<IXDataRenderer> rows = new ArrayList<IXDataRenderer>();
            Predicate<IAttribute<IQuantity>> legendFilter = this::isAttributeEnabled;
            DataPageToolkit.buildLinesRow(Messages.GarbageCollectionsPage_ROW_HEAP, Messages.GarbageCollectionsPage_ROW_HEAP_DESC, allItems, false, JdkQueries.HEAP_SUMMARY, legendFilter, (IQuantity)UnitLookup.BYTE.quantity(0L), null).ifPresent(rows::add);
            DataPageToolkit.buildLinesRow(Messages.GarbageCollectionsPage_ROW_HEAP_POST_GC, Messages.GarbageCollectionsPage_ROW_HEAP_POST_GC_DESC, allItems, false, HEAP_SUMMARY_POST_GC, legendFilter, (IQuantity)UnitLookup.BYTE.quantity(0L), null).ifPresent(rows::add);
            DataPageToolkit.buildLinesRow(Messages.GarbageCollectionsPage_ROW_METASPACE, Messages.GarbageCollectionsPage_ROW_METASPACE_DESC, allItems, false, METASPACE_SUMMARY, legendFilter, (IQuantity)UnitLookup.BYTE.quantity(0L), null).ifPresent(rows::add);
            ArrayList<IXDataRenderer> gcPauseRows = new ArrayList<IXDataRenderer>();
            IItemCollection pauseEvents = allItems.apply(JdkFilters.GC_PAUSE);
            if (this.longestPause.isChecked()) {
                gcPauseRows.add(DataPageToolkit.buildTimestampHistogramRenderer(pauseEvents, JdkAggregators.LONGEST_GC_PAUSE, LONGEST_PAUSE_COLOR));
            }
            if (this.sumOfPauses.isChecked()) {
                gcPauseRows.add(DataPageToolkit.buildTimestampHistogramRenderer(pauseEvents, JdkAggregators.TOTAL_GC_PAUSE, SUM_OF_PAUSES_COLOR));
            }
            if (!gcPauseRows.isEmpty()) {
                rows.add(RendererToolkit.layers((IXDataRenderer[])new IXDataRenderer[]{DataPageToolkit.buildGcPauseRow(allItems), RendererToolkit.uniformRows(gcPauseRows)}));
            }
            if (this.enablePhases.isChecked()) {
                ItemRow pauses = this.buildSpanRow(allItems, "jdk.GCPhasePause");
                ItemRow l1 = this.buildSpanRow(allItems, "jdk.GCPhasePauseLevel1");
                ItemRow l2 = this.buildSpanRow(allItems, "jdk.GCPhasePauseLevel2");
                ItemRow l3 = this.buildSpanRow(allItems, "jdk.GCPhasePauseLevel3");
                ItemRow l4 = this.buildSpanRow(allItems, "jdk.GCPhasePauseLevel4");
                rows.add(RendererToolkit.uniformRows(Arrays.asList(pauses, l1, l2, l3, l4), (String)this.enablePhases.getText()));
            }
            IItemFilter pauseThreadsFilter = ItemFilters.and((IItemFilter[])new IItemFilter[]{JdkFilters.GC_PAUSE, ItemFilters.hasAttribute((ICanonicalAccessorFactory)JfrAttributes.EVENT_THREAD)});
            if (this.GCEventThread.isChecked() && this.phasesList.getSelection().get().count() > 0L && allItems.apply(pauseThreadsFilter).hasItems()) {
                IAggregator distinctThreadsAggregator = Aggregators.distinct((IAttribute)JfrAttributes.EVENT_THREAD);
                IItemCollection items = ItemCollectionToolkit.build(this.phasesList.getSelection().get());
                Set threads = (Set)items.getAggregate(distinctThreadsAggregator);
                List renderers = threads.stream().map(thread -> this.lanes.buildThreadRenderer(thread, GarbageCollectionsPage.this.getDataSource().getItems().apply(ItemFilters.equals((ICanonicalAccessorFactory)JfrAttributes.EVENT_THREAD, (Object)thread)))).collect(Collectors.toList());
                rows.add(RendererToolkit.uniformRows(renderers));
            }
            this.renderRoot = RendererToolkit.layers((IXDataRenderer[])new IXDataRenderer[]{RendererToolkit.uniformRows(rows), this.buildTableSelectionRenderer()});
            this.chartCanvas.replaceRenderer(this.renderRoot);
        }

        private boolean isAttributeEnabled(IAttribute<IQuantity> attr) {
            String id = attr.getIdentifier();
            String name = attr.getName();
            return this.includeAttribute(id) && this.allChartSeriesActions.stream().filter(a -> name.equals(a.getText())).findAny().get().isChecked();
        }

        private boolean includeAttribute(String attrId) {
            return !this.excludedAttributeIds.contains(attrId);
        }

        private IXDataRenderer buildTableSelectionRenderer() {
            Supplier<Stream<? extends IItem>> phaseSelection = this.phasesList.getSelection();
            Stream<? extends IItem> gcItems = phaseSelection.get().count() > 0L ? phaseSelection.get() : this.gcSelectedGcItems();
            ISpanSeries gcBackdrop = QuantitySeries.max((IItemCollection)ItemCollectionToolkit.build(gcItems), (IAttribute)JfrAttributes.START_TIME, (IAttribute)JfrAttributes.END_TIME);
            return SpanRenderer.build((ISpanSeries)gcBackdrop, (AWTChartToolkit.IColorProvider)AWTChartToolkit.staticColor((Color)new Color(100, 180, 220, 150)));
        }

        public void saveTo(IWritableState memento) {
            PersistableSashForm.saveState((SashForm)this.sash, (IWritableState)memento.createChild(GarbageCollectionsPage.SASH));
            PersistableSashForm.saveState((SashForm)this.tableSash, (IWritableState)memento.createChild(GarbageCollectionsPage.TABLE_SASH));
            this.gcList.getSettings().saveState(memento.createChild(GarbageCollectionsPage.GCS));
            this.phasesList.getManager().getSettings().saveState(memento.createChild(GarbageCollectionsPage.PHASE_LIST));
            this.metaspaceList.getManager().getSettings().saveState(memento.createChild(GarbageCollectionsPage.METASPACE_LIST));
            ActionToolkit.saveCheckState((IWritableState)memento.createChild(GarbageCollectionsPage.CHART), this.allChartSeriesActions.stream());
            this.tableFilter.saveState(memento.createChild(GarbageCollectionsPage.GC_TABLE_FILTER));
            this.phasesFilter.saveState(memento.createChild(GarbageCollectionsPage.PHASE_TABLE_FILTER));
            this.metaspaceFilter.saveState(memento.createChild(GarbageCollectionsPage.METASPACE_TABLE_FILTER));
            this.saveToLocal();
        }

        private void saveToLocal() {
            GarbageCollectionsPage.this.gcListSelection = this.gcList.getSelectionState();
            GarbageCollectionsPage.this.phasesSelection = this.phasesList.getManager().getSelectionState();
            GarbageCollectionsPage.this.metaspaceSelection = this.metaspaceList.getManager().getSelectionState();
            GarbageCollectionsPage.this.gcInfoTabSelection = this.gcInfoFolder.getSelectionIndex();
            GarbageCollectionsPage.this.flavorSelectorState = this.flavorSelector.getFlavorSelectorState();
        }

        private void updateTable(IItemCollection gcs) {
            HashMap gcMap = new HashMap();
            gcs.forEach(is -> {
                IMemberAccessor gcIdAccessor = JdkAttributes.GC_ID.getAccessor(is.getType());
                IMemberAccessor durationAccessor = JfrAttributes.DURATION.getAccessor(is.getType());
                IMemberAccessor causeAccessor = JdkAttributes.GC_CAUSE.getAccessor(is.getType());
                IMemberAccessor nameAccessor = JdkAttributes.GC_NAME.getAccessor(is.getType());
                IMemberAccessor longestPauseAccessor = JdkAttributes.GC_LONGEST_PAUSE.getAccessor(is.getType());
                IMemberAccessor sumPauseAccessor = JdkAttributes.GC_SUM_OF_PAUSES.getAccessor(is.getType());
                IMemberAccessor startTimeAccessor = JfrAttributes.START_TIME.getAccessor(is.getType());
                IMemberAccessor endTimeAccessor = JfrAttributes.END_TIME.getAccessor(is.getType());
                is.forEach(item -> {
                    GC value = new GC((IItem)item, (IType<IItem>)is.getType());
                    value.gcId = (IQuantity)gcIdAccessor.getMember(item);
                    value.duration = (IQuantity)durationAccessor.getMember(item);
                    value.gcCause = (String)causeAccessor.getMember(item);
                    value.gcName = (String)nameAccessor.getMember(item);
                    value.longestPause = (IQuantity)longestPauseAccessor.getMember(item);
                    value.sumOfPauses = (IQuantity)sumPauseAccessor.getMember(item);
                    value.startTime = (IQuantity)startTimeAccessor.getMember(item);
                    value.endTime = (IQuantity)endTimeAccessor.getMember(item);
                    GarbageCollectionsPage.logDuplicateGcId(gcMap.put(gcIdAccessor.getMember(item), value));
                });
            });
            IItemCollection refItems = GarbageCollectionsPage.this.getDataSource().getItems().apply(JdkFilters.REFERENCE_STATISTICS);
            refItems.forEach(is -> {
                IMemberAccessor gdIdAccessor = JdkAttributes.GC_ID.getAccessor(is.getType());
                IMemberAccessor typeAccessor = JdkAttributes.REFERENCE_STATISTICS_TYPE.getAccessor(is.getType());
                IMemberAccessor countAccessor = JdkAttributes.REFERENCE_STATISTICS_COUNT.getAccessor(is.getType());
                is.forEach(item -> {
                    GC gc = (GC)gcMap.get(gdIdAccessor.getMember(item));
                    if (gc != null) {
                        gc.setRefCount(typeAccessor.getMember(item), countAccessor.getMember(item));
                    }
                });
            });
            IItemCollection heapItems = GarbageCollectionsPage.this.getDataSource().getItems().apply(JdkFilters.HEAP_SUMMARY);
            heapItems.forEach(is -> {
                IMemberAccessor gcIdAccessor = JdkAttributes.GC_ID.getAccessor(is.getType());
                IMemberAccessor gcWhenAccessor = JdkAttributes.GC_WHEN.getAccessor(is.getType());
                IMemberAccessor usedHeapAccessor = JdkAttributes.HEAP_USED.getAccessor(is.getType());
                IMemberAccessor committedHeapAccessor = JdkAttributes.GC_HEAPSPACE_COMMITTED.getAccessor(is.getType());
                is.forEach(item -> {
                    GC gc = (GC)gcMap.get(gcIdAccessor.getMember(item));
                    if (gc != null) {
                        String when = (String)gcWhenAccessor.getMember(item);
                        if ("Before GC".equals(when)) {
                            gc.usedBeforeGC = (IQuantity)usedHeapAccessor.getMember(item);
                            gc.usedDelta = gc.usedDelta.subtract(gc.usedBeforeGC);
                            gc.committedDelta = gc.committedDelta.subtract((IQuantity)committedHeapAccessor.getMember(item));
                        } else {
                            gc.usedAfterGC = (IQuantity)usedHeapAccessor.getMember(item);
                            gc.usedDelta = gc.usedDelta.add(gc.usedAfterGC);
                            gc.committedDelta = gc.committedDelta.add((IQuantity)committedHeapAccessor.getMember(item));
                        }
                    }
                });
            });
            IItemCollection metaspaceItems = GarbageCollectionsPage.this.getDataSource().getItems().apply(JdkFilters.METASPACE_SUMMARY);
            metaspaceItems.forEach(is -> {
                IMemberAccessor gcIdAccessor = JdkAttributes.GC_ID.getAccessor(is.getType());
                IMemberAccessor gcWhenAccessor = JdkAttributes.GC_WHEN.getAccessor(is.getType());
                IMemberAccessor usedMetaspaceAccessor = JdkAttributes.GC_METASPACE_USED.getAccessor(is.getType());
                IMemberAccessor committedMetaspaceAccessor = JdkAttributes.GC_METASPACE_COMMITTED.getAccessor(is.getType());
                is.forEach(item -> {
                    GC gc = (GC)gcMap.get(gcIdAccessor.getMember(item));
                    if (gc != null && usedMetaspaceAccessor != null && committedMetaspaceAccessor != null && gcWhenAccessor != null) {
                        String when = (String)gcWhenAccessor.getMember(item);
                        if ("Before GC".equals(when)) {
                            gc.usedMetaspaceDelta = gc.usedMetaspaceDelta.subtract((IQuantity)usedMetaspaceAccessor.getMember(item));
                            gc.committedMetaspaceDelta = gc.committedMetaspaceDelta.subtract((IQuantity)committedMetaspaceAccessor.getMember(item));
                        } else {
                            gc.usedMetaspaceDelta = gc.usedMetaspaceDelta.add((IQuantity)usedMetaspaceAccessor.getMember(item));
                            gc.committedMetaspaceDelta = gc.committedMetaspaceDelta.add((IQuantity)committedMetaspaceAccessor.getMember(item));
                        }
                    }
                });
            });
            this.gcList.getViewer().setInput((Object)gcMap.values().toArray());
        }

        private void onShow(Boolean show) {
            IRange<IQuantity> range = show != false ? this.currentRange : this.pageContainer.getRecordingRange();
            this.gcChart.setVisibleRange((IQuantity)range.getStart(), (IQuantity)range.getEnd());
            this.buildChart();
        }

        private void updateChart() {
            DataPageToolkit.setChart(this.chartCanvas, this.gcChart, this.pageContainer::showSelection);
            SelectionStoreActionToolkit.addSelectionStoreRangeActions(this.pageContainer.getSelectionStore(), this.gcChart, (IAttribute<IRange<IQuantity>>)JfrAttributes.LIFETIME, Messages.GarbageCollectionsPage_TIMELINE_SELECTION, (IContributionManager)this.chartCanvas.getContextMenu());
            this.buildChart();
        }

        private void onInputSelected(IItemCollection items, IRange<IQuantity> timeRange) {
            this.currentRange = timeRange;
            this.selectionItems = items;
            IItemCollection gcs = items != null ? items : GarbageCollectionsPage.this.getDataSource().getItems();
            this.updateTable(gcs.apply(JdkFilters.GARBAGE_COLLECTION));
            this.updateChart();
        }

        private Stream<? extends IItem> gcSelectedGcItems() {
            List sel = ((IStructuredSelection)this.gcList.getViewer().getSelection()).toList();
            ArrayList<GC> selCopy = new ArrayList<GC>(sel);
            this.correlateSystemGCEvents(sel, selCopy);
            return selCopy.stream().map(gc -> gc.gcItem);
        }

        private void correlateSystemGCEvents(List<GC> sourceGCList, List<GC> destinationGCList) {
            IItemCollection systemGCEvents = GarbageCollectionsPage.this.getDataSource().getItems().apply(ItemFilters.type((String)"jdk.SystemGC"));
            for (GC gc : sourceGCList) {
                IItemFilter rangeFilter = RulesToolkit.createRangeFilter((IItem)gc.gcItem);
                IItemCollection correlatedItems = systemGCEvents.apply(rangeFilter);
                for (IItemIterable types : correlatedItems) {
                    for (IItem item : types) {
                        destinationGCList.add(new GC(item, null));
                    }
                }
            }
        }
    }
}

